/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.extensions.GroovyUnresolvedHighlightFilter;
import org.jetbrains.plugins.groovy.findUsages.MissingMethodAndPropertyUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.transformations.impl.GroovyObjectTransformationSupport;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GrUnresolvedAccessChecker {
    public static final Logger LOG = Logger.getInstance(GrUnresolvedAccessChecker.class);
    private static final LightCacheKey<Map<String, Boolean>> GROOVY_OBJECT_METHODS_CACHE = new LightCacheKey<Map<String, Boolean>>(){

        @Override
        protected long getModificationCount(PsiElement holder) {
            return holder.getManager().getModificationTracker().getModificationCount();
        }
    };

    static boolean areMissingMethodsDeclared(GrReferenceExpression ref) {
        PsiType qualifierType = PsiImplUtil.getQualifierType(ref);
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)qualifierType).resolve();
        if (resolved == null) {
            return false;
        }
        if (ref.getParent() instanceof GrCall) {
            PsiMethod[] found;
            for (PsiMethod method : found = resolved.findMethodsByName("methodMissing", true)) {
                if (!MissingMethodAndPropertyUtil.isMethodMissing(method)) continue;
                return true;
            }
        } else {
            PsiMethod[] found;
            for (PsiMethod method : found = resolved.findMethodsByName("propertyMissing", true)) {
                if (!MissingMethodAndPropertyUtil.isPropertyMissing(method)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean areGroovyObjectMethodsOverridden(GrReferenceExpression ref) {
        PsiMethod patternMethod = GrUnresolvedAccessChecker.findPatternMethod(ref);
        if (patternMethod == null) {
            return false;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier != null) {
            return GrUnresolvedAccessChecker.checkGroovyObjectMethodsByQualifier(ref, patternMethod);
        }
        return GrUnresolvedAccessChecker.checkMethodInPlace(ref, patternMethod);
    }

    private static boolean checkMethodInPlace(GrReferenceExpression ref, PsiMethod patternMethod) {
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{GrClosableBlock.class, PsiMember.class, PsiFile.class});
        assert (container != null);
        return GrUnresolvedAccessChecker.checkContainer(patternMethod, container);
    }

    private static boolean checkContainer(@NotNull PsiMethod patternMethod, @NotNull PsiElement container) {
        Boolean cachedResult;
        if (patternMethod == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(0);
        }
        if (container == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(1);
        }
        String name = patternMethod.getName();
        ConcurrentMap cached = GROOVY_OBJECT_METHODS_CACHE.getCachedValue(container);
        if (cached == null) {
            cached = ContainerUtil.newConcurrentMap();
            GROOVY_OBJECT_METHODS_CACHE.putCachedValue(container, cached);
        }
        if ((cachedResult = cached.get(name)) != null) {
            return cachedResult;
        }
        boolean result2 = GrUnresolvedAccessChecker.doCheckContainer(patternMethod, container, name);
        cached.put(name, result2);
        return result2;
    }

    private static boolean doCheckContainer(final PsiMethod patternMethod, PsiElement container, final String name) {
        final Ref result2 = new Ref((Object)false);
        GrScopeProcessorWithHints processor = new GrScopeProcessorWithHints(name, ClassHint.RESOLVE_KINDS_METHOD){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element instanceof PsiMethod && name.equals(((PsiMethod)element).getName()) && patternMethod.getParameterList().getParametersCount() == ((PsiMethod)element).getParameterList().getParametersCount() && GrUnresolvedAccessChecker.isNotFromGroovyObject((PsiMethod)element)) {
                    result2.set((Object)true);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessChecker$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ResolveUtil.treeWalkUp(container, processor, true);
        return (Boolean)result2.get();
    }

    private static boolean checkGroovyObjectMethodsByQualifier(GrReferenceExpression ref, PsiMethod patternMethod) {
        PsiType qualifierType = PsiImplUtil.getQualifierType(ref);
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)qualifierType).resolve();
        if (resolved == null) {
            return false;
        }
        PsiMethod found = resolved.findMethodBySignature(patternMethod, true);
        if (found == null) {
            return false;
        }
        return GrUnresolvedAccessChecker.isNotFromGroovyObject(found);
    }

    private static boolean isNotFromGroovyObject(@NotNull PsiMethod found) {
        if (found == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(2);
        }
        if (GroovyObjectTransformationSupport.isGroovyObjectSupportMethod(found)) {
            return false;
        }
        PsiClass aClass = found.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        if ("groovy.lang.GroovyObject".equals(qname)) {
            return false;
        }
        return !"groovy.lang.GroovyObjectSupport".equals(qname);
    }

    @Nullable
    private static PsiMethod findPatternMethod(@NotNull GrReferenceExpression ref) {
        PsiClass groovyObject;
        if (ref == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(3);
        }
        if ((groovyObject = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("groovy.lang.GroovyObject", ref.getResolveScope())) == null) {
            return null;
        }
        String methodName = ref.getParent() instanceof GrCall ? "invokeMethod" : (PsiUtil.isLValue(ref) ? "setProperty" : "getProperty");
        PsiMethod[] patternMethods = groovyObject.findMethodsByName(methodName, false);
        if (patternMethods.length != 1) {
            return null;
        }
        return patternMethods[0];
    }

    static boolean isStaticOk(GroovyResolveResult resolveResult2) {
        if (resolveResult2.isStaticsOK()) {
            return true;
        }
        PsiElement resolved = resolveResult2.getElement();
        LOG.assertTrue(resolved != null);
        LOG.assertTrue(resolved instanceof PsiModifierListOwner, (Object)(resolved + " : " + resolved.getText()));
        return ((PsiModifierListOwner)resolved).hasModifierProperty("static");
    }

    @NotNull
    static GroovyResolveResult getBestResolveResult(GrReferenceExpression ref) {
        GroovyResolveResult[] results = ref.multiResolve(false);
        if (results.length == 0) {
            EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
            if (emptyGroovyResolveResult == null) {
                GrUnresolvedAccessChecker.$$$reportNull$$$0(4);
            }
            return emptyGroovyResolveResult;
        }
        if (results.length == 1) {
            GroovyResolveResult groovyResolveResult = results[0];
            if (groovyResolveResult == null) {
                GrUnresolvedAccessChecker.$$$reportNull$$$0(5);
            }
            return groovyResolveResult;
        }
        for (GroovyResolveResult result2 : results) {
            if (!result2.isAccessible() || !result2.isStaticsOK()) continue;
            GroovyResolveResult groovyResolveResult = result2;
            if (groovyResolveResult == null) {
                GrUnresolvedAccessChecker.$$$reportNull$$$0(6);
            }
            return groovyResolveResult;
        }
        for (GroovyResolveResult result2 : results) {
            if (!result2.isStaticsOK()) continue;
            GroovyResolveResult groovyResolveResult = result2;
            if (groovyResolveResult == null) {
                GrUnresolvedAccessChecker.$$$reportNull$$$0(7);
            }
            return groovyResolveResult;
        }
        GroovyResolveResult groovyResolveResult = results[0];
        if (groovyResolveResult == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(8);
        }
        return groovyResolveResult;
    }

    static boolean shouldHighlightAsUnresolved(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(9);
        }
        if (GrHighlightUtil.isDeclarationAssignment(referenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)referenceExpression.getQualifier();
        if (qualifier != null && qualifier.getType() == null && !GrUnresolvedAccessChecker.isRefToPackage(qualifier)) {
            return false;
        }
        if (qualifier != null && referenceExpression.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER && referenceExpression.multiResolve(false).length > 0) {
            return false;
        }
        if (!GroovyUnresolvedHighlightFilter.shouldHighlight(referenceExpression)) {
            return false;
        }
        CollectConsumer consumer = new CollectConsumer();
        for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
            searcher.findDeclarationsAt((PsiElement)referenceExpression, 0, (Consumer)consumer);
            if (consumer.getResult().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isRefToPackage(GrExpression expr) {
        return expr instanceof GrReferenceExpression && ((GrReferenceExpression)expr).resolve() instanceof PsiPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessChecker";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessChecker";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestResolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkContainer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isNotFromGroovyObject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPatternMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightAsUnresolved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

