/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.naming.NewClassNamingConventionInspection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class NewGroovyClassNamingConventionInspection
extends AbstractNamingConventionInspection<PsiClass> {
    public NewGroovyClassNamingConventionInspection() {
        super(NewGroovyClassNamingConventionInspection.wrapClassExtensions(), "GroovyClassNamingConvention");
    }

    private static List<NamingConvention<PsiClass>> wrapClassExtensions() {
        return ContainerUtil.map((Object[])NewClassNamingConventionInspection.EP_NAME.getExtensions(), ex -> new NamingConvention<PsiClass>(){

            public boolean isApplicable(PsiClass member) {
                return ex.isApplicable((PsiNameIdentifierOwner)member);
            }

            public String getElementDescription() {
                return ex.getElementDescription();
            }

            public String getShortName() {
                String shortName = ex.getShortName();
                if (shortName.startsWith("JUnit")) {
                    return shortName;
                }
                return "Groovy" + (shortName.startsWith("Enum") ? "EnumerationNamingConvention" : shortName);
            }

            public NamingConventionBean createDefaultBean() {
                return ex.createDefaultBean();
            }
        });
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            NewGroovyClassNamingConventionInspection.$$$reportNull$$$0(0);
        }
        if (!(holder.getFile() instanceof PsiClassOwner)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                NewGroovyClassNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof GrTypeDefinition) {
                    PsiClass aClass = (PsiClass)element;
                    String name = aClass.getName();
                    if (name == null) {
                        return;
                    }
                    NewGroovyClassNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)aClass, name, holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            NewGroovyClassNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    protected LocalQuickFix createRenameFix() {
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/naming/NewGroovyClassNamingConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/naming/NewGroovyClassNamingConventionInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

