/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

public class GroovyTrivialConditionalInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Redundant conditional expression" == null) {
            GroovyTrivialConditionalInspection.$$$reportNull$$$0(0);
        }
        return "Redundant conditional expression";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        UnnecessaryConditionalExpressionVisitor unnecessaryConditionalExpressionVisitor = new UnnecessaryConditionalExpressionVisitor();
        if (unnecessaryConditionalExpressionVisitor == null) {
            GroovyTrivialConditionalInspection.$$$reportNull$$$0(1);
        }
        return unnecessaryConditionalExpressionVisitor;
    }

    @Override
    public String buildErrorString(Object ... args) {
        GrConditionalExpression exp = (GrConditionalExpression)args[0];
        return "'" + exp.getText() + "' can be simplified to '" + GroovyTrivialConditionalInspection.calculateReplacementExpression(exp) + "'  #loc";
    }

    private static String calculateReplacementExpression(GrConditionalExpression exp) {
        GrExpression thenExpression = exp.getThenBranch();
        GrExpression elseExpression = exp.getElseBranch();
        GrExpression condition = exp.getCondition();
        if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return condition.getText();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyTrivialConditionalInspection.$$$reportNull$$$0(2);
        }
        return new TrivialConditionalFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression exp) {
            if (exp == null) {
                UnnecessaryConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(exp);
            GrExpression condition = exp.getCondition();
            PsiType type2 = condition.getType();
            if (type2 == null || !PsiType.BOOLEAN.isAssignableFrom(type2)) {
                return;
            }
            if (ErrorUtil.containsError(exp)) {
                return;
            }
            GrExpression thenExpression = exp.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            GrExpression elseExpression = exp.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression) || GroovyTrivialConditionalInspection.isTrue(thenExpression) && GroovyTrivialConditionalInspection.isFalse(elseExpression)) {
                this.registerError(exp);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$UnnecessaryConditionalExpressionVisitor", "visitConditionalExpression"));
        }
    }

    private static class TrivialConditionalFix
    extends GroovyFix {
        private TrivialConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                TrivialConditionalFix.$$$reportNull$$$0(0);
            }
            return "Simplify";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                TrivialConditionalFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                TrivialConditionalFix.$$$reportNull$$$0(2);
            }
            GrConditionalExpression expression = (GrConditionalExpression)descriptor2.getPsiElement();
            String newExpression = GroovyTrivialConditionalInspection.calculateReplacementExpression(expression);
            TrivialConditionalFix.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$TrivialConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$TrivialConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

