/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.AliasedAnnotationHolder;
import org.jetbrains.plugins.groovy.annotator.checkers.AnnotationChecker;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;

public class GrAliasAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        ArrayList<GrAnnotation> aliasedAnnotations;
        if (holder == null) {
            GrAliasAnnotationChecker.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            GrAliasAnnotationChecker.$$$reportNull$$$0(1);
        }
        if ((aliasedAnnotations = GrAliasAnnotationChecker.getAliasedAnnotations(annotation)) == null) {
            return false;
        }
        AliasedAnnotationHolder aliasedHolder = new AliasedAnnotationHolder(holder, annotation);
        AnnotationChecker checker = new AnnotationChecker(aliasedHolder);
        for (GrAnnotation aliased : aliasedAnnotations) {
            checker.checkApplicability(aliased, annotation.getOwner());
        }
        return true;
    }

    @Nullable
    private static ArrayList<GrAnnotation> getAliasedAnnotations(GrAnnotation annotation) {
        PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
        if (annotationCollector == null) {
            return null;
        }
        ArrayList aliasedAnnotations = ContainerUtil.newArrayList();
        GrAnnotationCollector.collectAnnotations(aliasedAnnotations, annotation, annotationCollector);
        return aliasedAnnotations;
    }

    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        PsiAnnotation annotationCollector;
        if (holder == null) {
            GrAliasAnnotationChecker.$$$reportNull$$$0(2);
        }
        if (annotation == null) {
            GrAliasAnnotationChecker.$$$reportNull$$$0(3);
        }
        if ((annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation)) == null) {
            return false;
        }
        ArrayList annotations2 = ContainerUtil.newArrayList();
        Set<String> usedAttributes = GrAnnotationCollector.collectAnnotations(annotations2, annotation, annotationCollector);
        AliasedAnnotationHolder aliasedHolder = new AliasedAnnotationHolder(holder, annotation);
        AnnotationChecker checker = new AnnotationChecker(aliasedHolder);
        for (GrAnnotation aliased : annotations2) {
            if (!checker.checkAnnotationArgumentList(aliased)) continue;
            return true;
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        String aliasQName = annotation.getQualifiedName();
        if (attributes.length == 1 && attributes[0].getNameIdentifierGroovy() == null && !usedAttributes.contains("value")) {
            holder.createErrorAnnotation((PsiElement)attributes[0], GroovyBundle.message("at.interface.0.does.not.contain.attribute", aliasQName, "value"));
        }
        for (GrAnnotationNameValuePair pair : attributes) {
            PsiElement nameIdentifier = pair.getNameIdentifierGroovy();
            if (nameIdentifier == null || usedAttributes.contains(pair.getName())) continue;
            holder.createErrorAnnotation(nameIdentifier, GroovyBundle.message("at.interface.0.does.not.contain.attribute", aliasQName, pair.getName()));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/checkers/GrAliasAnnotationChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkApplicability";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArgumentList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

