/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0016H\u0000\u001a\u001c\u0010\u0010\u001a\u00020\u0006*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0018H\u0000\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001b"}, d2={"VARIABLE_MODIFIERS", "", "", "getVARIABLE_MODIFIERS", "()Ljava/util/Set;", "checkModifierIsNotAllowed", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "modifier", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "message", "checkVariableModifiers", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "registerFix", "annotation", "Lcom/intellij/lang/annotation/Annotation;", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "place", "Lcom/intellij/psi/PsiElement;", "createDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "element", "descriptor", "intellij.groovy.psi"})
public final class UtilKt {
    @NotNull
    private static final Set<String> VARIABLE_MODIFIERS = SetsKt.setOf((Object[])new String[]{"def", "final"});

    @NotNull
    public static final Set<String> getVARIABLE_MODIFIERS() {
        return VARIABLE_MODIFIERS;
    }

    public static final void checkVariableModifiers(@NotNull AnnotationHolder holder, @NotNull GrVariableDeclaration variableDeclaration) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)variableDeclaration, (String)"variableDeclaration");
        GrModifierList grModifierList = variableDeclaration.getModifierList();
        Intrinsics.checkExpressionValueIsNotNull((Object)grModifierList, (String)"variableDeclaration.modifierList");
        GrModifierList modifierList = grModifierList;
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (VARIABLE_MODIFIERS.contains(modifier)) continue;
            String string = modifier;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"modifier");
            UtilKt.checkModifierIsNotAllowed(modifierList, string, GroovyBundle.message("variable.cannot.be", modifier), holder);
        }
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)modifierList, (String)"modifierList");
        Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        UtilKt.checkModifierIsNotAllowed(modifierList, modifier, GroovyBundle.message("modifier.0.not.allowed", modifier), holder);
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @Nullable String message, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)modifierList, (String)"modifierList");
        Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiElement psiElement = modifierList.getModifier(modifier);
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"modifierList.getModifier(modifier) ?: return");
        PsiElement modifierElement = psiElement;
        Annotation annotation = holder.createErrorAnnotation(modifierElement, message);
        GrRemoveModifierFix fix = new GrRemoveModifierFix(modifier, GroovyBundle.message("remove.modifier", modifier));
        Annotation annotation2 = annotation;
        Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
        UtilKt.registerFix(annotation2, (LocalQuickFix)fix, modifierElement);
    }

    public static final void registerFix(@NotNull Annotation annotation, @NotNull LocalQuickFix fix, @NotNull PsiElement place) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)fix, (String)"fix");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        InspectionManager manager = InspectionManager.getInstance((Project)place.getProject());
        TextRange textRange = place.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"place.textRange");
        boolean bl2 = bl = !textRange.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            PsiFile psiFile = place.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"place.containingFile");
            String string = psiFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"place.containingFile.name");
            String string2 = string;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(place, place, annotation.getMessage(), annotation.getHighlightType(), true, new LocalQuickFix[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026tion.highlightType, true)");
        ProblemDescriptor descriptor2 = problemDescriptor;
        TextRange textRange2 = TextRange.create((int)annotation.getStartOffset(), (int)annotation.getEndOffset());
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"TextRange.create(annotat\u2026et, annotation.endOffset)");
        TextRange range = textRange2;
        annotation.registerFix(fix, range, null, descriptor2);
    }

    @NotNull
    public static final ProblemDescriptor createDescriptor(@NotNull Annotation $receiver, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)element.getProject()).createProblemDescriptor(element, element, $receiver.getMessage(), $receiver.getHighlightType(), true, new LocalQuickFix[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"InspectionManager.getIns\u2026age, highlightType, true)");
        return problemDescriptor;
    }

    public static final void registerFix(@NotNull Annotation $receiver, @NotNull LocalQuickFix fix, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)fix, (String)"fix");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        $receiver.registerFix(fix, null, null, descriptor2);
    }
}

