/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UNamedExpression;

class UastPropertiesReferenceProvider
extends UastInjectionHostReferenceProvider {
    private final boolean myDefaultSoft;

    UastPropertiesReferenceProvider(boolean defaultSoft) {
        this.myDefaultSoft = defaultSoft;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(0);
        }
        return target instanceof IProperty;
    }

    @NotNull
    public PsiReference[] getReferencesForInjectionHost(@NotNull UExpression element, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
        String text;
        if (element == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(1);
        }
        if (host == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(3);
        }
        Object value = null;
        String bundleName = null;
        boolean soft = this.myDefaultSoft;
        if (UastPropertiesReferenceProvider.canBePropertyKeyRef(element)) {
            value = element.evaluate();
            Ref resourceBundleValue = Ref.create();
            if (JavaI18nUtil.mustBePropertyKey(element, (Ref<? super UExpression>)resourceBundleValue)) {
                soft = false;
                UExpression resourceBundleName = (UExpression)resourceBundleValue.get();
                if (resourceBundleName != null) {
                    Object bundleValue = resourceBundleName.evaluate();
                    String string = bundleName = bundleValue == null ? null : bundleValue.toString();
                }
            }
        }
        if (value instanceof String && (text = (String)value).indexOf(10) == -1) {
            PropertyReference reference = new PropertyReference(text, (PsiElement)host, bundleName, soft);
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                UastPropertiesReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean canBePropertyKeyRef(@NotNull UExpression element) {
        UElement parent;
        if (element == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(6);
        }
        if ((parent = element.getUastParent()) instanceof UExpression) {
            if (parent instanceof UIfExpression && ((UIfExpression)parent).isTernary()) {
                UExpression elseExpr = ((UIfExpression)parent).getElseExpression();
                UExpression thenExpr = ((UIfExpression)parent).getThenExpression();
                PsiElement elseExprSrc = elseExpr == null ? null : elseExpr.getSourcePsi();
                PsiElement thenExprSrc = thenExpr == null ? null : thenExpr.getSourcePsi();
                PsiElement psi = element.getSourcePsi();
                return (psi == thenExprSrc || psi == elseExprSrc) && UastPropertiesReferenceProvider.canBePropertyKeyRef((UExpression)parent);
            }
            return parent instanceof UCallExpression || parent instanceof UNamedExpression;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/UastPropertiesReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/UastPropertiesReferenceProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesForInjectionHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesForInjectionHost";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBePropertyKeyRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

