/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.wagon.events.TransferEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.server.IndexedMavenId;
import org.jetbrains.idea.maven.server.Maven2ServerGlobals;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.embedder.Maven2ModelConverter;
import org.jetbrains.idea.maven.server.embedder.Maven2ServerEmbedderImpl;
import org.jetbrains.idea.maven.server.embedder.Maven2ServerIndexFetcher;
import org.jetbrains.idea.maven.server.embedder.RuntimeRemoteException;
import org.jetbrains.idea.maven.server.embedder.TransferListenerAdapter;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactScanningListener;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.ScanningResult;
import org.sonatype.nexus.index.context.IndexUtils;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;
import org.sonatype.nexus.index.creator.JarFileContentsIndexCreator;
import org.sonatype.nexus.index.creator.MinimalArtifactInfoIndexCreator;
import org.sonatype.nexus.index.updater.IndexUpdateRequest;
import org.sonatype.nexus.index.updater.IndexUpdater;
import org.sonatype.nexus.index.updater.ResourceFetcher;

public class Maven2ServerIndexerImpl
extends MavenRemoteObject
implements MavenServerIndexer {
    private final Maven2ServerEmbedderImpl myEmbedder;
    private final NexusIndexer myIndexer;
    private final IndexUpdater myUpdater;
    private final ArtifactContextProducer myArtifactContextProducer;
    private final TIntObjectHashMap<IndexingContext> myIndices = new TIntObjectHashMap();

    public Maven2ServerIndexerImpl() throws RemoteException {
        this.myEmbedder = Maven2ServerEmbedderImpl.create(new MavenServerSettings());
        this.myIndexer = this.myEmbedder.getComponent(NexusIndexer.class);
        this.myUpdater = this.myEmbedder.getComponent(IndexUpdater.class);
        this.myArtifactContextProducer = this.myEmbedder.getComponent(ArtifactContextProducer.class);
        MavenServerUtil.registerShutdownTask((Runnable)new Runnable(){

            @Override
            public void run() {
                Maven2ServerIndexerImpl.this.release();
            }
        });
    }

    public int createIndex(@NotNull String indexId, @NotNull String repositoryId, @Nullable File file, @Nullable String url, @NotNull File indexDir) throws MavenServerIndexerException {
        if (indexId == null) {
            Maven2ServerIndexerImpl.$$$reportNull$$$0(0);
        }
        if (repositoryId == null) {
            Maven2ServerIndexerImpl.$$$reportNull$$$0(1);
        }
        if (indexDir == null) {
            Maven2ServerIndexerImpl.$$$reportNull$$$0(2);
        }
        try {
            IndexingContext context = this.myIndexer.addIndexingContextForced(indexId, repositoryId, file, indexDir, url, null, Arrays.asList(new AbstractIndexCreator[]{new TinyArtifactInfoIndexCreator(), new JarFileContentsIndexCreator()}));
            int id = System.identityHashCode(context);
            this.myIndices.put(id, (Object)context);
            return id;
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    public void releaseIndex(int id) throws MavenServerIndexerException {
        try {
            this.myIndexer.removeIndexingContext(this.getIndex(id), false);
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    @NotNull
    private IndexingContext getIndex(int id) {
        IndexingContext index = (IndexingContext)this.myIndices.get(id);
        if (index == null) {
            throw new RuntimeException("Index not found for id: " + id);
        }
        IndexingContext indexingContext = index;
        if (indexingContext == null) {
            Maven2ServerIndexerImpl.$$$reportNull$$$0(3);
        }
        return indexingContext;
    }

    public boolean indexExists(File dir) throws RemoteException {
        try {
            return IndexReader.indexExists((File)dir);
        }
        catch (Exception e) {
            Maven2ServerGlobals.getLogger().warn(e);
            return false;
        }
    }

    private String getRepositoryPathOrUrl(IndexingContext index) {
        File file = index.getRepository();
        return file == null ? index.getRepositoryUrl() : file.getPath();
    }

    private boolean isLocal(IndexingContext index) {
        return index.getRepository() != null;
    }

    public int getIndexCount() {
        return this.myIndexer.getIndexingContexts().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex(int id, MavenServerSettings settings, MavenServerProgressIndicator indicator) throws MavenServerIndexerException, MavenServerProcessCanceledException, RemoteException {
        block11: {
            IndexingContext index = this.getIndex(id);
            try {
                if (this.isLocal(index)) {
                    File repository = index.getRepository();
                    if (repository == null || !repository.exists()) break block11;
                    indicator.setIndeterminate(true);
                    try {
                        this.myIndexer.scan(index, (ArtifactScanningListener)new MyScanningListener(indicator), false);
                        break block11;
                    }
                    finally {
                        indicator.setIndeterminate(false);
                    }
                }
                IndexUpdateRequest request = new IndexUpdateRequest(index);
                Maven2ServerEmbedderImpl embedder = Maven2ServerEmbedderImpl.create(settings);
                try {
                    request.setResourceFetcher((ResourceFetcher)new Maven2ServerIndexFetcher(index.getRepositoryId(), index.getRepositoryUrl(), embedder.getComponent(WagonManager.class), new TransferListenerAdapter(indicator){

                        @Override
                        protected void downloadProgress(long downloaded, long total) {
                            super.downloadProgress(downloaded, total);
                            try {
                                this.myIndicator.setFraction((double)downloaded / (double)total);
                            }
                            catch (RemoteException e) {
                                throw new RuntimeRemoteException(e);
                            }
                        }

                        @Override
                        public void transferCompleted(TransferEvent event) {
                            super.transferCompleted(event);
                            try {
                                this.myIndicator.setText2("Processing indices...");
                            }
                            catch (RemoteException e) {
                                throw new RuntimeRemoteException(e);
                            }
                        }
                    }));
                    this.myUpdater.fetchAndUpdateIndex(request);
                }
                finally {
                    embedder.release();
                }
            }
            catch (RuntimeRemoteException e) {
                throw e.getCause();
            }
            catch (MavenProcessCanceledRuntimeException e) {
                throw new MavenServerProcessCanceledException();
            }
            catch (Exception e) {
                throw new MavenServerIndexerException(this.wrapException(e));
            }
        }
    }

    public void processArtifacts(int indexId, MavenServerIndicesProcessor processor) throws MavenServerIndexerException {
        try {
            int CHUNK_SIZE = 10000;
            IndexReader r = this.getIndex(indexId).getIndexReader();
            int total = r.numDocs();
            ArrayList<IndexedMavenId> result = new ArrayList<IndexedMavenId>(Math.min(10000, total));
            for (int i = 0; i < total; ++i) {
                String[] uInfoParts;
                Document doc;
                String uinfo;
                if (r.isDeleted(i) || (uinfo = (doc = r.document(i)).get("u")) == null || (uInfoParts = uinfo.split("\\|")).length < 3) continue;
                String groupId = uInfoParts[0];
                String artifactId = uInfoParts[1];
                String version = uInfoParts[2];
                String packaging = doc.get("p");
                String description = doc.get("d");
                result.add(new IndexedMavenId(groupId, artifactId, version, packaging, description));
                if (result.size() != 10000) continue;
                processor.processArtifacts(result);
                result.clear();
            }
            if (!result.isEmpty()) {
                processor.processArtifacts(result);
            }
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    public IndexedMavenId addArtifact(int indexId, File artifactFile) throws MavenServerIndexerException {
        try {
            IndexingContext index = this.getIndex(indexId);
            ArtifactContext artifactContext = this.myArtifactContextProducer.getArtifactContext(index, artifactFile);
            if (artifactContext == null) {
                return null;
            }
            Maven2ServerIndexerImpl.addArtifact(this.myIndexer, index, artifactContext);
            ArtifactInfo a = artifactContext.getArtifactInfo();
            return new IndexedMavenId(a.groupId, a.artifactId, a.version, a.packaging, a.description);
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    public static void addArtifact(NexusIndexer indexer, IndexingContext index, ArtifactContext artifactContext) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        indexer.addArtifactToIndex(artifactContext, index);
        Method m = index.getClass().getDeclaredMethod("closeReaders", new Class[0]);
        m.setAccessible(true);
        m.invoke((Object)index, new Object[0]);
    }

    public Set<MavenArtifactInfo> search(int indexId, Query query, int maxResult) throws MavenServerIndexerException {
        try {
            IndexingContext index = this.getIndex(indexId);
            TopDocs docs = null;
            try {
                BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
                docs = index.getIndexSearcher().search(query, null, maxResult);
            }
            catch (BooleanQuery.TooManyClauses tooManyClauses) {
                // empty catch block
            }
            if (docs == null || docs.scoreDocs.length == 0) {
                return Collections.emptySet();
            }
            THashSet result = new THashSet();
            for (int i = 0; i < docs.scoreDocs.length; ++i) {
                int docIndex = docs.scoreDocs[i].doc;
                Document doc = index.getIndexReader().document(docIndex);
                ArtifactInfo a = IndexUtils.constructArtifactInfo((Document)doc, (IndexingContext)index);
                if (a == null) continue;
                a.repository = this.getRepositoryPathOrUrl(index);
                result.add(Maven2ModelConverter.convertArtifactInfo(a));
            }
            return result;
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    public Collection<MavenArchetype> getArchetypes() throws RemoteException {
        THashSet result = new THashSet();
        this.doCollectArchetypes("internal-catalog", (Set<MavenArchetype>)result);
        return result;
    }

    private void doCollectArchetypes(String roleHint, Set<MavenArchetype> result) throws RemoteException {
        try {
            ArchetypeDataSource source = this.myEmbedder.getComponent(ArchetypeDataSource.class, roleHint);
            ArchetypeCatalog catalog = source.getArchetypeCatalog(new Properties());
            for (Archetype each : catalog.getArchetypes()) {
                result.add(Maven2ModelConverter.convertArchetype(each));
            }
        }
        catch (ArchetypeDataSourceException e) {
            Maven2ServerGlobals.getLogger().warn(e);
        }
    }

    public void release() {
        try {
            this.myEmbedder.release();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/embedder/Maven2ServerIndexerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/embedder/Maven2ServerIndexerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TinyArtifactInfoIndexCreator
    extends MinimalArtifactInfoIndexCreator {
        private TinyArtifactInfoIndexCreator() {
        }

        public void updateDocument(ArtifactInfo ai, Document doc) {
            if (ai.packaging != null) {
                doc.add((Fieldable)new Field("p", ai.packaging, Field.Store.YES, Field.Index.NO));
            }
            if ("maven-archetype".equals(ai.packaging) && ai.description != null) {
                doc.add((Fieldable)new Field("d", ai.description, Field.Store.YES, Field.Index.NO));
            }
        }
    }

    private static class MyScanningListener
    implements ArtifactScanningListener {
        private final MavenServerProgressIndicator p;

        MyScanningListener(MavenServerProgressIndicator indicator) {
            this.p = indicator;
        }

        public void scanningStarted(IndexingContext ctx) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
            }
            catch (RemoteException e) {
                throw new RuntimeRemoteException(e);
            }
        }

        public void scanningFinished(IndexingContext ctx, ScanningResult result) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
            }
            catch (RemoteException e) {
                throw new RuntimeRemoteException(e);
            }
        }

        public void artifactError(ArtifactContext ac, Exception e) {
        }

        public void artifactDiscovered(ArtifactContext ac) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
                ArtifactInfo info = ac.getArtifactInfo();
                this.p.setText2(info.groupId + ":" + info.artifactId + ":" + info.version);
            }
            catch (RemoteException e) {
                throw new RuntimeRemoteException(e);
            }
        }
    }
}

