/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.tabs.TabInfo;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionEditor;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalSessionEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(1);
        }
        return file instanceof TerminalSessionVirtualFileImpl;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(3);
        }
        if (file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) != null) {
            TerminalSessionEditor terminalSessionEditor = new TerminalSessionEditor(project, (TerminalSessionVirtualFileImpl)file);
            if (terminalSessionEditor == null) {
                TerminalSessionEditorProvider.$$$reportNull$$$0(4);
            }
            return terminalSessionEditor;
        }
        TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)file;
        JBTerminalWidget widget = terminalFile.getTerminalWidget();
        TabInfo tabInfo = new TabInfo((JComponent)widget).setText(terminalFile.getName());
        TerminalTabState tts = new TerminalTabState();
        tts.myWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(widget, file.getName());
        LocalTerminalDirectRunner runner = LocalTerminalDirectRunner.createTerminalRunner(project);
        JBTerminalWidget newWidget = TerminalUtil.createTerminal(runner, tts, null);
        TerminalSessionVirtualFileImpl newSessionVirtualFile = new TerminalSessionVirtualFileImpl(tabInfo, newWidget, terminalFile.getSettingsProvider());
        tabInfo.setObject((Object)newSessionVirtualFile);
        TerminalSessionEditor editor = new TerminalSessionEditor(project, newSessionVirtualFile);
        newWidget.moveDisposable((Disposable)editor);
        TerminalSessionEditor terminalSessionEditor = editor;
        if (terminalSessionEditor == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(5);
        }
        return terminalSessionEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if ("terminal-session-editor" == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(6);
        }
        return "terminal-session-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(7);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditorProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

