/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.actions.SvnExcludingIgnoredOperation;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.dialogs.ShareDialog;

public class ShareProjectAction
extends BasicAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = SvnBundle.message("share.directory.action", new Object[0]);
        if (string == null) {
            ShareProjectAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShareProjectAction.$$$reportNull$$$0(1);
        }
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project = e.getProject();
        boolean visible = project != null && !ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning() && !ArrayUtil.isEmpty((Object[])files) && files.length == 1 && files[0].isDirectory();
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && !SvnStatusUtil.isUnderControl(project, (VirtualFile)files[0]));
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ShareProjectAction.$$$reportNull$$$0(3);
        }
        return false;
    }

    public static boolean share(@NotNull Project project, @NotNull VirtualFile file) throws VcsException {
        if (project == null) {
            ShareProjectAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ShareProjectAction.$$$reportNull$$$0(5);
        }
        return ShareProjectAction.performImpl(SvnVcs.getInstance(project), file);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            ShareProjectAction.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ShareProjectAction.$$$reportNull$$$0(8);
        }
        ShareProjectAction.performImpl(vcs, file);
    }

    private static boolean performImpl(@NotNull SvnVcs vcs, @NotNull VirtualFile file) throws VcsException {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ShareProjectAction.$$$reportNull$$$0(10);
        }
        ShareDialog shareDialog = new ShareDialog(vcs.getProject(), file.getName());
        shareDialog.show();
        String parent = shareDialog.getSelectedURL();
        if (shareDialog.isOK() && parent != null) {
            Ref actionStarted = new Ref((Object)Boolean.TRUE);
            Exception[] error = new Exception[1];
            ShareDialog.ShareTarget shareTarget = shareDialog.getShareTarget();
            if (ShareDialog.ShareTarget.useSelected.equals((Object)shareTarget) && !ShareProjectAction.isFolderEmpty(vcs, parent) && 0 != Messages.showYesNoDialog((Project)vcs.getProject(), (String)("Remote folder \"" + parent + "\" is not empty.\nDo you want to continue sharing?"), (String)"Share Directory", (Icon)Messages.getWarningIcon())) {
                return false;
            }
            WorkingCopyFormat format = SvnCheckoutProvider.promptForWCopyFormat(VfsUtilCore.virtualToIoFile((VirtualFile)file), vcs.getProject());
            actionStarted.set((Object)(format != WorkingCopyFormat.UNKNOWN ? 1 : 0));
            if (format == WorkingCopyFormat.UNKNOWN) {
                return true;
            }
            ExclusiveBackgroundVcsAction.run(vcs.getProject(), () -> ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    Target checkoutTarget = ShareProjectAction.createFolderStructure(vcs, file, shareTarget, shareDialog.createStandardStructure(), SvnUtil.createUrl(parent), shareDialog.getCommitText());
                    ProgressManager.progress((String)SvnBundle.message("share.directory.checkout.back.progress.text", checkoutTarget.getPath()));
                    ClientFactory factory = SvnCheckoutProvider.getFactory(vcs);
                    factory.createCheckoutClient().checkout(Target.on(checkoutTarget.getUrl()), VfsUtilCore.virtualToIoFile((VirtualFile)file), checkoutTarget.getPegRevision(), Depth.INFINITY, false, false, format, null);
                    ShareProjectAction.addRecursively(vcs, factory, file);
                }
                catch (VcsException e) {
                    error[0] = e;
                }
                finally {
                    vcs.invokeRefreshSvnRoots();
                }
            }, SvnBundle.message("share.directory.title", new Object[0]), true, vcs.getProject()));
            if (Boolean.TRUE.equals(actionStarted.get())) {
                if (error[0] != null) {
                    throw new VcsException(error[0].getMessage());
                }
                Messages.showInfoMessage((Project)vcs.getProject(), (String)SvnBundle.message("share.directory.info.message", file.getName()), (String)SvnBundle.message("share.directory.title", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static Target createFolderStructure(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull ShareDialog.ShareTarget shareTarget, boolean createStandardStructure, @NotNull Url parentUrl, @NotNull String commitText) throws VcsException {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            ShareProjectAction.$$$reportNull$$$0(12);
        }
        if (shareTarget == null) {
            ShareProjectAction.$$$reportNull$$$0(13);
        }
        if (parentUrl == null) {
            ShareProjectAction.$$$reportNull$$$0(14);
        }
        if (commitText == null) {
            ShareProjectAction.$$$reportNull$$$0(15);
        }
        switch (shareTarget) {
            case useSelected: {
                Target target = Target.on(parentUrl, Revision.HEAD);
                if (target == null) {
                    ShareProjectAction.$$$reportNull$$$0(16);
                }
                return target;
            }
            case useProjectName: {
                Target target = ShareProjectAction.createRemoteFolder(vcs, parentUrl, file.getName(), commitText);
                if (target == null) {
                    ShareProjectAction.$$$reportNull$$$0(17);
                }
                return target;
            }
        }
        Target projectRoot = ShareProjectAction.createRemoteFolder(vcs, parentUrl, file.getName(), commitText);
        Target trunk = ShareProjectAction.createRemoteFolder(vcs, projectRoot.getUrl(), "trunk", commitText);
        if (createStandardStructure) {
            ShareProjectAction.createRemoteFolder(vcs, projectRoot.getUrl(), "branches", commitText);
            ShareProjectAction.createRemoteFolder(vcs, projectRoot.getUrl(), "tags", commitText);
        }
        Target target = trunk;
        if (target == null) {
            ShareProjectAction.$$$reportNull$$$0(18);
        }
        return target;
    }

    private static boolean isFolderEmpty(@NotNull SvnVcs vcs, @NotNull String folderUrl) throws VcsException {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(19);
        }
        if (folderUrl == null) {
            ShareProjectAction.$$$reportNull$$$0(20);
        }
        return (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SvnUtil.remoteFolderIsEmpty(vcs, folderUrl), "Check Remote Folder Contents", false, vcs.getProject());
    }

    @NotNull
    private static Target createRemoteFolder(@NotNull SvnVcs vcs, @NotNull Url parent, @NotNull String folderName, @NotNull String commitText) throws VcsException {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(21);
        }
        if (parent == null) {
            ShareProjectAction.$$$reportNull$$$0(22);
        }
        if (folderName == null) {
            ShareProjectAction.$$$reportNull$$$0(23);
        }
        if (commitText == null) {
            ShareProjectAction.$$$reportNull$$$0(24);
        }
        Url url = SvnUtil.append(parent, folderName);
        String message = SvnBundle.message("share.directory.commit.message", folderName, ApplicationNamesInfo.getInstance().getFullProductName(), commitText);
        Target target = Target.on(url);
        ProgressManager.progress((String)SvnBundle.message("share.directory.create.dir.progress.text", url.toDecodedString()));
        long revision = vcs.getFactoryFromSettings().createBrowseClient().createDirectory(target, message, false);
        Target target2 = Target.on(url, Revision.of(revision));
        if (target2 == null) {
            ShareProjectAction.$$$reportNull$$$0(25);
        }
        return target2;
    }

    @Override
    protected void doVcsRefresh(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(26);
        }
        if (file == null) {
            ShareProjectAction.$$$reportNull$$$0(27);
        }
        VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).dirDirtyRecursively(file);
    }

    private static void addRecursively(@NotNull SvnVcs vcs, @NotNull ClientFactory factory, @NotNull VirtualFile rootFile) throws VcsException {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(28);
        }
        if (factory == null) {
            ShareProjectAction.$$$reportNull$$$0(29);
        }
        if (rootFile == null) {
            ShareProjectAction.$$$reportNull$$$0(30);
        }
        SvnExcludingIgnoredOperation operation = new SvnExcludingIgnoredOperation(vcs.getProject(), file -> {
            ProgressManager.progress((String)SvnBundle.message("share.or.import.add.progress.text", file.getPath()));
            factory.createAddClient().add(VfsUtilCore.virtualToIoFile((VirtualFile)file), Depth.EMPTY, false, false, true, null);
        }, Depth.INFINITY);
        operation.execute(rootFile);
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) {
        if (vcs == null) {
            ShareProjectAction.$$$reportNull$$$0(31);
        }
        if (files == null) {
            ShareProjectAction.$$$reportNull$$$0(32);
        }
        if (context == null) {
            ShareProjectAction.$$$reportNull$$$0(33);
        }
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/ShareProjectAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shareTarget";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUrl";
                break;
            }
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderUrl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/ShareProjectAction";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFolderStructure";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteFolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "share";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFolderStructure";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isFolderEmpty";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteFolder";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doVcsRefresh";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addRecursively";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "batchPerform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

