/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.kapt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.kapt.ClassLoaderData;
import org.jetbrains.kotlin.utils.kapt.MemoryLeak;
import org.jetbrains.kotlin.utils.kapt.MemoryLeakDetectorKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/utils/kapt/MemoryLeakDetector;", "", "()V", "classLoaderData", "", "Lorg/jetbrains/kotlin/utils/kapt/ClassLoaderData;", "add", "", "classLoader", "Ljava/lang/ClassLoader;", "inspectStatics", "", "Lorg/jetbrains/kotlin/utils/kapt/MemoryLeak;", "process", "isParanoid", "", "util"})
public final class MemoryLeakDetector {
    private static final List<ClassLoaderData> classLoaderData;
    public static final MemoryLeakDetector INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        List<ClassLoaderData> list2 = classLoaderData;
        synchronized (list2) {
            boolean bl = classLoaderData.add(new ClassLoaderData(classLoader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<MemoryLeak> process(boolean isParanoid) {
        Set memoryLeaks = new LinkedHashSet();
        List<ClassLoaderData> list2 = classLoaderData;
        synchronized (list2) {
            List newClassLoaderData = new ArrayList();
            for (ClassLoaderData data : classLoaderData) {
                ClassLoader classLoader;
                if ((ClassLoader)data.getRef().get() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"data.ref.get() ?: continue");
                ClassLoaderData classLoaderData = data;
                classLoaderData.setAge(classLoaderData.getAge() + 1);
                if (isParanoid || data.getAge() >= 5) {
                    INSTANCE.inspectStatics(classLoader);
                    continue;
                }
                Collection collection = newClassLoaderData;
                collection.add(data);
            }
            classLoaderData.clear();
            boolean bl = classLoaderData.addAll(newClassLoaderData);
        }
        return memoryLeaks;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MemoryLeak> inspectStatics(ClassLoader classLoader) {
        Field[] it;
        Set $receiver$iv;
        Vector loadedClasses = MemoryLeakDetectorKt.access$loadedClasses(classLoader);
        try {
            void destination$iv;
            Iterable iterable = loadedClasses;
            Collection collection = new LinkedHashSet();
            for (Object item$iv : $receiver$iv) {
                void var17_8;
                Class clazz = (Class)item$iv;
                void var16_7 = destination$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                var16_7.add(var17_8);
            }
            $receiver$iv = (Set)destination$iv;
        }
        catch (ConcurrentModificationException e) {
            Thread.sleep(100L);
            return this.inspectStatics(classLoader);
        }
        Set loadedClassesSet = $receiver$iv;
        Set leaks = new LinkedHashSet();
        for (Class clazz : loadedClassesSet) {
            Field[] declaredFields;
            try {
                it = clazz.getDeclaredFields();
            }
            catch (Throwable e) {
                continue;
            }
            Field[] fieldArray = declaredFields = it;
            int n = fieldArray.length;
            for (int j = 0; j < n; ++j) {
                MemoryLeak memoryLeak;
                Object object;
                Object it2;
                Field field2;
                Field field3 = field2 = fieldArray[j];
                Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
                if (!Modifier.isStatic(field3.getModifiers())) continue;
                Object object2 = MemoryLeakDetectorKt.access$getSafe(field2, null);
                if (object2 == null || (object2 = !MemoryLeakDetectorKt.access$isPrimitiveOrString(it2 = (object = object2)) ? object : null) == null) {
                    continue;
                }
                Object value = object2;
                if (MemoryLeakDetectorKt.access$isJavacComponent(value)) {
                    object = leaks;
                    String string = clazz.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clazz.name");
                    String string2 = field2.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"field.name");
                    memoryLeak = new MemoryLeak(string, string2, "Field leaks an Annotation Processing component (" + value + ").");
                    object.add(memoryLeak);
                    continue;
                }
                if (!(value instanceof Class) || !loadedClassesSet.contains(value)) continue;
                object = leaks;
                String string = clazz.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clazz.name");
                String string3 = field2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"field.name");
                memoryLeak = new MemoryLeak(string, string3, "Field leaks a class type from the same ClassLoader (" + ((Class)value).getName() + ").");
                object.add(memoryLeak);
            }
        }
        return leaks;
    }

    private MemoryLeakDetector() {
    }

    static {
        MemoryLeakDetector memoryLeakDetector;
        INSTANCE = memoryLeakDetector = new MemoryLeakDetector();
        classLoaderData = new ArrayList();
    }
}

