/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker$WhenMappings;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0016\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0017\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0018\u001a\u00020\u0011*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0019\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0015H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker;", "", "()V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkAsTopLevelTypeReference", "topLevelTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isReceiver", "", "checkDeclaration", "checkIfDelegatedProperty", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIfHasBackingField", "checkIfMutableProperty", "checkIfProperty", "checkTypeReference", "useSiteDescription", "", "frontend"})
public final class AnnotationUseSiteTargetChecker {
    public static final AnnotationUseSiteTargetChecker INSTANCE;

    public final void check(@NotNull KtAnnotated annotated, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.checkDeclaration(trace, annotated, descriptor2);
        if (annotated instanceof KtCallableDeclaration) {
            KtTypeReference ktTypeReference;
            KtTypeReference it;
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)annotated).getReceiverTypeReference();
            if (ktTypeReference2 != null) {
                KtTypeReference ktTypeReference3 = it = (ktTypeReference = ktTypeReference2);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"it");
                INSTANCE.checkTypeReference(trace, ktTypeReference3, languageVersionSettings, true);
            }
            KtTypeReference ktTypeReference4 = ((KtCallableDeclaration)annotated).getTypeReference();
            if (ktTypeReference4 != null) {
                KtTypeReference ktTypeReference5 = it = (ktTypeReference = ktTypeReference4);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference5, (String)"it");
                INSTANCE.checkTypeReference(trace, ktTypeReference5, languageVersionSettings, false);
            }
        }
        if (annotated instanceof KtFunction) {
            for (KtParameter parameter : ((KtFunction)annotated).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                if (parameter.hasValOrVar()) continue;
                if ((VariableDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter) == null) {
                    continue;
                }
                KtParameter ktParameter = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                this.checkDeclaration(trace, ktParameter, parameterDescriptor);
                if (parameter.getTypeReference() != null) {
                    KtTypeReference ktTypeReference;
                    KtTypeReference it;
                    KtTypeReference ktTypeReference6 = it = ktTypeReference;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference6, (String)"it");
                    INSTANCE.checkTypeReference(trace, ktTypeReference6, languageVersionSettings, false);
                }
            }
        }
    }

    private final void checkTypeReference(@NotNull BindingTrace $receiver, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings, boolean isReceiver) {
        this.checkAsTopLevelTypeReference($receiver, topLevelTypeReference, languageVersionSettings, isReceiver);
        topLevelTypeReference.acceptChildren(VisitorWrappersKt.typeReferenceRecursiveVisitor((Function1<? super KtTypeReference, Unit>)((Function1)new Function1<KtTypeReference, Unit>($receiver, languageVersionSettings){
            final /* synthetic */ BindingTrace $this_checkTypeReference;
            final /* synthetic */ LanguageVersionSettings $languageVersionSettings;

            public final void invoke(@NotNull KtTypeReference typeReference) {
                Intrinsics.checkParameterIsNotNull((Object)typeReference, (String)"typeReference");
                AnnotationUseSiteTargetChecker.access$checkAsTopLevelTypeReference(AnnotationUseSiteTargetChecker.INSTANCE, this.$this_checkTypeReference, typeReference, this.$languageVersionSettings, false);
            }
            {
                this.$this_checkTypeReference = bindingTrace;
                this.$languageVersionSettings = languageVersionSettings;
                super(1);
            }
        })));
    }

    private final void checkAsTopLevelTypeReference(@NotNull BindingTrace $receiver, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings, boolean isReceiver) {
        for (KtAnnotationEntry annotationEntry2 : topLevelTypeReference.getAnnotationEntries()) {
            ParametrizedDiagnostic<KtAnnotationEntry> diagnostic;
            Object object = annotationEntry2.getUseSiteTarget();
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) {
                continue;
            }
            Object target = object;
            if (target == AnnotationUseSiteTarget.RECEIVER && isReceiver) continue;
            Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings.supportsFeature(LanguageFeature.RestrictionOfWrongAnnotationsWithUseSiteTargetsOnTypes) ? Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)annotationEntry2), "undefined target", ((AnnotationUseSiteTarget)((Object)target)).getRenderName()) : Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET_ON_TYPE.on((KtAnnotationEntry)((PsiElement)annotationEntry2), ((AnnotationUseSiteTarget)((Object)target)).getRenderName()), (String)"if (languageVersionSetti\u2026Entry, target.renderName)");
            diagnostic = diagnostic;
            DiagnosticUtilsKt.reportDiagnosticOnce($receiver, diagnostic);
        }
    }

    private final void checkDeclaration(@NotNull BindingTrace $receiver, KtAnnotated annotated, DeclarationDescriptor descriptor2) {
        Iterator<KtAnnotationEntry> iterator2 = annotated.getAnnotationEntries().iterator();
        block10: while (iterator2.hasNext()) {
            KtAnnotationEntry annotation2;
            KtAnnotationEntry ktAnnotationEntry = annotation2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"annotation");
            KtAnnotationUseSiteTarget useSiteTarget = ktAnnotationEntry.getUseSiteTarget();
            Object object = useSiteTarget;
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) {
                continue;
            }
            Object target = object;
            switch (AnnotationUseSiteTargetChecker$WhenMappings.$EnumSwitchMapping$0[((Enum)target).ordinal()]) {
                case 1: {
                    this.checkIfHasBackingField($receiver, annotated, descriptor2, annotation2);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    this.checkIfDelegatedProperty($receiver, annotated, annotation2);
                    break;
                }
                case 5: {
                    this.checkIfMutableProperty($receiver, annotated, annotation2);
                    break;
                }
                case 6: {
                    DeclarationDescriptor containingDeclaration2;
                    if (!(annotated instanceof KtParameter)) {
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on((PsiElement)annotation2));
                        break;
                    }
                    VariableDescriptor variableDescriptor = (VariableDescriptor)$receiver.getBindingContext().get(BindingContext.VALUE_PARAMETER, annotated);
                    DeclarationDescriptor declarationDescriptor = containingDeclaration2 = variableDescriptor != null ? variableDescriptor.getContainingDeclaration() : null;
                    if (!(containingDeclaration2 instanceof ConstructorDescriptor) || !((ConstructorDescriptor)containingDeclaration2).isPrimary()) {
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on((PsiElement)annotation2));
                        break;
                    }
                    if (((KtParameter)annotated).hasValOrVar()) continue block10;
                    $receiver.report(Errors.REDUNDANT_ANNOTATION_TARGET.on((PsiElement)annotation2, ((AnnotationUseSiteTarget)((Object)target)).getRenderName()));
                    break;
                }
                case 7: {
                    this.checkIfMutableProperty($receiver, annotated, annotation2);
                    break;
                }
                case 8: {
                    SimpleDiagnostic<KtAnnotationUseSiteTarget> simpleDiagnostic = Errors.INAPPLICABLE_FILE_TARGET.on((KtAnnotationUseSiteTarget)((PsiElement)useSiteTarget));
                    Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"INAPPLICABLE_FILE_TARGET.on(useSiteTarget)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($receiver, simpleDiagnostic);
                    break;
                }
                case 9: {
                    ParametrizedDiagnostic<KtAnnotationEntry> parametrizedDiagnostic = Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)annotation2), "declaration", ((AnnotationUseSiteTarget)((Object)target)).getRenderName());
                    Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"WRONG_ANNOTATION_TARGET_\u2026tion\", target.renderName)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($receiver, parametrizedDiagnostic);
                }
            }
        }
    }

    private final void checkIfDelegatedProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && !((KtProperty)annotated).hasDelegate() || annotated instanceof KtParameter && ((KtParameter)annotated).hasValOrVar()) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE.on((PsiElement)annotation2));
        }
    }

    private final void checkIfHasBackingField(@NotNull BindingTrace $receiver, KtAnnotated annotated, DeclarationDescriptor descriptor2, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && ((KtProperty)annotated).hasDelegate() && descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((Boolean)$receiver.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2)), (Object)true) ^ true) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD.on((PsiElement)annotation2));
        }
    }

    private final String useSiteDescription(@NotNull KtAnnotationEntry $receiver) {
        Object object = $receiver.getUseSiteTarget();
        if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (object = ((AnnotationUseSiteTarget)((Object)object)).getRenderName()) == null) {
            object = "unknown target";
        }
        return object;
    }

    private final void checkIfMutableProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isMutable;
        if (!this.checkIfProperty($receiver, annotated, annotation2)) {
            return;
        }
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? ((KtProperty)annotated).isVar() : (isMutable = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).isMutable() : false);
        if (!isMutable) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_IMMUTABLE.on((PsiElement)annotation2, this.useSiteDescription(annotation2)));
        }
    }

    private final boolean checkIfProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isProperty;
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? !((KtProperty)annotated).isLocal() : (isProperty = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).hasValOrVar() : false);
        if (!isProperty) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_ON_PROPERTY.on((PsiElement)annotation2, this.useSiteDescription(annotation2)));
        }
        return isProperty;
    }

    private AnnotationUseSiteTargetChecker() {
    }

    static {
        AnnotationUseSiteTargetChecker annotationUseSiteTargetChecker;
        INSTANCE = annotationUseSiteTargetChecker = new AnnotationUseSiteTargetChecker();
    }

    public static final /* synthetic */ void access$checkAsTopLevelTypeReference(AnnotationUseSiteTargetChecker $this, BindingTrace $receiver, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings, boolean isReceiver) {
        $this.checkAsTopLevelTypeReference($receiver, topLevelTypeReference, languageVersionSettings, isReceiver);
    }
}

