/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.psi.tree.IElementType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

public final class OperatorTable {
    private static final Map<KtToken, JsBinaryOperator> binaryOperatorsMap = ImmutableBiMap.builder().put((Object)KtTokens.PLUS, (Object)JsBinaryOperator.ADD).put((Object)KtTokens.MINUS, (Object)JsBinaryOperator.SUB).put((Object)KtTokens.MUL, (Object)JsBinaryOperator.MUL).put((Object)KtTokens.DIV, (Object)JsBinaryOperator.DIV).put((Object)KtTokens.EQ, (Object)JsBinaryOperator.ASG).put((Object)KtTokens.GT, (Object)JsBinaryOperator.GT).put((Object)KtTokens.GTEQ, (Object)JsBinaryOperator.GTE).put((Object)KtTokens.LT, (Object)JsBinaryOperator.LT).put((Object)KtTokens.LTEQ, (Object)JsBinaryOperator.LTE).put((Object)KtTokens.ANDAND, (Object)JsBinaryOperator.AND).put((Object)KtTokens.OROR, (Object)JsBinaryOperator.OR).put((Object)KtTokens.PERC, (Object)JsBinaryOperator.MOD).put((Object)KtTokens.PLUSEQ, (Object)JsBinaryOperator.ASG_ADD).put((Object)KtTokens.MINUSEQ, (Object)JsBinaryOperator.ASG_SUB).put((Object)KtTokens.DIVEQ, (Object)JsBinaryOperator.ASG_DIV).put((Object)KtTokens.MULTEQ, (Object)JsBinaryOperator.ASG_MUL).put((Object)KtTokens.PERCEQ, (Object)JsBinaryOperator.ASG_MOD).put((Object)KtTokens.IN_KEYWORD, (Object)JsBinaryOperator.INOP).put((Object)KtTokens.EQEQEQ, (Object)JsBinaryOperator.REF_EQ).put((Object)KtTokens.EXCLEQEQEQ, (Object)JsBinaryOperator.REF_NEQ).build();
    private static final ImmutableBiMap<KtToken, JsUnaryOperator> unaryOperatorsMap = ImmutableBiMap.builder().put((Object)KtTokens.PLUSPLUS, (Object)JsUnaryOperator.INC).put((Object)KtTokens.MINUSMINUS, (Object)JsUnaryOperator.DEC).put((Object)KtTokens.EXCL, (Object)JsUnaryOperator.NOT).put((Object)KtTokens.MINUS, (Object)JsUnaryOperator.NEG).put((Object)KtTokens.PLUS, (Object)JsUnaryOperator.POS).build();

    private OperatorTable() {
    }

    public static boolean hasCorrespondingOperator(@NotNull KtToken token) {
        return binaryOperatorsMap.containsKey((Object)token) || unaryOperatorsMap.containsKey((Object)token);
    }

    public static boolean hasCorrespondingBinaryOperator(@NotNull KtToken token) {
        return binaryOperatorsMap.containsKey((Object)token);
    }

    @NotNull
    public static JsBinaryOperator getBinaryOperator(@NotNull KtToken token) {
        assert (KtTokens.OPERATIONS.contains((IElementType)token)) : "Token should represent an operation!";
        return binaryOperatorsMap.get((Object)token);
    }

    @NotNull
    public static JsUnaryOperator getUnaryOperator(@NotNull KtToken token) {
        assert (KtTokens.OPERATIONS.contains((IElementType)token)) : "Token should represent an operation!";
        return (JsUnaryOperator)unaryOperatorsMap.get((Object)token);
    }
}

