/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.refactoring.memberPushDown.JavaPushDownDelegate;
import com.intellij.refactoring.memberPushDown.NewSubClassData;
import com.intellij.refactoring.memberPushDown.PushDownData;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.containers.MultiMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.util.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownImplKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.substitutions.SubstitutionUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J$\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/JavaToKotlinPushDownDelegate;", "Lcom/intellij/refactoring/memberPushDown/JavaPushDownDelegate;", "()V", "checkTargetClassConflicts", "", "targetClass", "Lcom/intellij/psi/PsiElement;", "pushDownData", "Lcom/intellij/refactoring/memberPushDown/PushDownData;", "Lcom/intellij/refactoring/util/classMembers/MemberInfo;", "Lcom/intellij/psi/PsiMember;", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "", "subClassData", "Lcom/intellij/refactoring/memberPushDown/NewSubClassData;", "pushDownToClass", "idea"})
public final class JavaToKotlinPushDownDelegate
extends JavaPushDownDelegate {
    public void checkTargetClassConflicts(@Nullable PsiElement targetClass, @NotNull PushDownData<MemberInfo, PsiMember> pushDownData, @NotNull MultiMap<PsiElement, String> conflicts2, @Nullable NewSubClassData subClassData) {
        Intrinsics.checkParameterIsNotNull(pushDownData, (String)"pushDownData");
        Intrinsics.checkParameterIsNotNull(conflicts2, (String)"conflicts");
        super.checkTargetClassConflicts(targetClass, pushDownData, conflicts2, subClassData);
        PsiElement psiElement2 = targetClass;
        Object object = psiElement2 != null ? LightClassUtilsKt.getUnwrapped(psiElement2) : null;
        if (!(object instanceof KtClassOrObject)) {
            object = null;
        }
        KtClassOrObject ktClassOrObject = (KtClassOrObject)object;
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject ktClass2 = ktClassOrObject;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default(ktClass2, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor targetClassDescriptor2 = (ClassDescriptor)declarationDescriptor;
        Iterator iterator2 = pushDownData.getMembersToMove().iterator();
        while (iterator2.hasNext()) {
            PsiMember member;
            MemberInfo memberInfo;
            MemberInfo memberInfo2 = memberInfo = (MemberInfo)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)memberInfo2, (String)"memberInfo");
            if ((PsiMember)memberInfo2.getMember() == null) {
                continue;
            }
            PushDownConflictsUtilsKt.checkExternalUsages(conflicts2, (PsiElement)member, targetClassDescriptor2, ResolutionUtils.getResolutionFacade(ktClass2));
        }
    }

    public void pushDownToClass(@NotNull PsiElement targetClass, @NotNull PushDownData<MemberInfo, PsiMember> pushDownData) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull(pushDownData, (String)"pushDownData");
        PsiElement psiElement2 = pushDownData.getSourceClass();
        if (!(psiElement2 instanceof PsiClass)) {
            psiElement2 = null;
        }
        PsiClass psiClass2 = (PsiClass)psiElement2;
        if (psiClass2 == null) {
            return;
        }
        PsiClass superClass = psiClass2;
        PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped(targetClass);
        if (!(psiElement3 instanceof KtClassOrObject)) {
            psiElement3 = null;
        }
        KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement3;
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject subClass = ktClassOrObject;
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(subClass);
        ClassDescriptor classDescriptor2 = JavaResolutionUtils.getJavaClassDescriptor(superClass, resolutionFacade);
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor superClassDescriptor = classDescriptor2;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default(subClass, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor subClassDescriptor = (ClassDescriptor)declarationDescriptor;
        SimpleType simpleType2 = superClassDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"superClassDescriptor.defaultType");
        KotlinType kotlinType2 = simpleType2;
        SimpleType simpleType3 = subClassDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"subClassDescriptor.defaultType");
        TypeSubstitutor typeSubstitutor2 = SubstitutionUtilsKt.getTypeSubstitutor(kotlinType2, simpleType3);
        if (typeSubstitutor2 == null) {
            typeSubstitutor2 = TypeSubstitutor.EMPTY;
        }
        TypeSubstitutor substitutor3 = typeSubstitutor2;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default(subClass, false, 2, null);
        boolean hasAbstractMembers = false;
        Iterator iterator2 = pushDownData.getMembersToMove().iterator();
        while (iterator2.hasNext()) {
            KtClassOrObject ktClass2;
            PsiMember member;
            MemberInfo memberInfo;
            MemberInfo memberInfo2 = memberInfo = (MemberInfo)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)memberInfo2, (String)"memberInfo");
            PsiMember psiMember = member = (PsiMember)memberInfo2.getMember();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMember, (String)"member");
            if (JavaResolutionUtils.getJavaMemberDescriptor(psiMember, resolutionFacade) == null) {
                continue;
            }
            PsiMember psiMember2 = member;
            if (psiMember2 instanceof PsiMethod || psiMember2 instanceof PsiField) {
                KtCallableDeclaration ktCallableDeclaration;
                DeclarationDescriptor memberDescriptor;
                KtCallableDeclaration ktMember;
                KtNamedDeclaration ktNamedDeclaration = KotlinRefactoringUtilKt.j2k(member);
                if (!(ktNamedDeclaration instanceof KtCallableDeclaration)) {
                    ktNamedDeclaration = null;
                }
                if ((KtCallableDeclaration)ktNamedDeclaration == null) {
                    continue;
                }
                ktMember.removeModifier(KtTokens.DEFAULT_VISIBILITY_KEYWORD);
                boolean isStatic = member.hasModifierProperty("static");
                KtClassOrObject targetMemberClass = isStatic && subClass instanceof KtClass ? (KtClassOrObject)PsiModificationUtilsKt.getOrCreateCompanionObject((KtClass)subClass) : subClass;
                DeclarationDescriptor declarationDescriptor2 = ResolutionFacade.DefaultImpls.resolveToDescriptor$default(resolutionFacade, targetMemberClass, null, 2, null);
                if (declarationDescriptor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                ClassDescriptor targetMemberClassDescriptor = (ClassDescriptor)declarationDescriptor2;
                if (member.hasModifierProperty("abstract")) {
                    hasAbstractMembers = true;
                }
                DeclarationDescriptor declarationDescriptor3 = memberDescriptor;
                if (declarationDescriptor3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                }
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor3;
                TypeSubstitutor typeSubstitutor3 = substitutor3;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor3, (String)"substitutor");
                KtCallableDeclaration $receiver = ktCallableDeclaration = PushDownImplKt.moveCallableMemberToClass(ktMember, callableMemberDescriptor, targetMemberClass, targetMemberClassDescriptor, typeSubstitutor3, memberInfo.isToAbstract());
                if (!KotlinRefactoringUtilKt.isInterfaceClass((PsiNamedElement)subClass)) continue;
                $receiver.removeModifier(KtTokens.ABSTRACT_KEYWORD);
                continue;
            }
            if (!(psiMember2 instanceof PsiClass)) continue;
            if (memberInfo.getOverrides() != null) {
                Object object = RefactoringUtil.findReferenceToClass((PsiReferenceList)superClass.getImplementsList(), (PsiClass)((PsiClass)member));
                if (object == null || (object = KotlinRefactoringUtilKt.j2kText((PsiElement)object)) == null) {
                    continue;
                }
                Object typeText = object;
                subClass.addSuperTypeListEntry(psiFactory.createSuperTypeEntry((String)typeText));
                continue;
            }
            KtNamedDeclaration ktNamedDeclaration = KotlinRefactoringUtilKt.j2k(member);
            if (!(ktNamedDeclaration instanceof KtClassOrObject)) {
                ktNamedDeclaration = null;
            }
            if ((KtClassOrObject)ktNamedDeclaration == null) {
                continue;
            }
            PullUpUtilsKt.addMemberToTarget(ktClass2, subClass);
        }
        if (hasAbstractMembers && !KotlinRefactoringUtilKt.isInterfaceClass((PsiNamedElement)subClass)) {
            subClass.addModifier(KtTokens.ABSTRACT_KEYWORD);
        }
    }
}

