/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveFilesOrDirectories;

import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveJavaFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.move.moveFilesOrDirectories.FqNameFixingMoveJavaFIleHandlerKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016JP\u0010\t\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u0001 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\r0\n2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00102\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/FqNameFixingMoveJavaFileHandler;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFileHandler;", "()V", "delegate", "Lcom/intellij/refactoring/move/moveClassesOrPackages/MoveJavaFileHandler;", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiFile;", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "kotlin.jvm.PlatformType", "", "psiFile", "newParent", "Lcom/intellij/psi/PsiDirectory;", "searchInComments", "searchInNonJavaFiles", "prepareMovedFile", "", "file", "moveDestination", "oldToNewMap", "", "Lcom/intellij/psi/PsiElement;", "retargetUsages", "usageInfos", "updateMovedFile", "idea"})
public final class FqNameFixingMoveJavaFileHandler
extends MoveFileHandler {
    private final MoveJavaFileHandler delegate = new MoveJavaFileHandler();

    public boolean canProcessElement(@NotNull PsiFile element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.delegate.canProcessElement(element3);
    }

    @Nullable
    public List<UsageInfo> findUsages(@NotNull PsiFile psiFile, @Nullable PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        return this.delegate.findUsages(psiFile, newParent, searchInComments, searchInNonJavaFiles);
    }

    public void prepareMovedFile(@NotNull PsiFile file, @NotNull PsiDirectory moveDestination, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)moveDestination, (String)"moveDestination");
        Intrinsics.checkParameterIsNotNull(oldToNewMap, (String)"oldToNewMap");
        this.delegate.prepareMovedFile(file, moveDestination, oldToNewMap);
        if (file instanceof PsiJavaFile && FqNameFixingMoveJavaFIleHandlerKt.getShouldFixFqName((PsiJavaFile)file)) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(moveDestination);
            if (psiPackage == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiPackage, (String)"JavaDirectoryService.get\u2026oveDestination) ?: return");
            PsiPackage newPackage = psiPackage;
            if (!FileTypeUtils.isInServerPageFile((PsiElement)((PsiElement)file)) && !PsiUtil.isModuleFile((PsiFile)file)) {
                ((PsiJavaFile)file).setPackageName(newPackage.getQualifiedName());
            }
        }
    }

    public void updateMovedFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.delegate.updateMovedFile(file);
    }

    public void retargetUsages(@NotNull List<UsageInfo> usageInfos, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        Intrinsics.checkParameterIsNotNull(usageInfos, (String)"usageInfos");
        Intrinsics.checkParameterIsNotNull(oldToNewMap, (String)"oldToNewMap");
        this.delegate.retargetUsages(usageInfos, oldToNewMap);
    }
}

