/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.introduceTypeAlias.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceTypeAlias.IntroduceTypeAliasDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceTypeAlias.IntroduceTypeAliasImplKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceTypeAlias.ui.IntroduceTypeAliasParameterTablePanel;
import org.jetbrains.kotlin.idea.refactoring.introduce.ui.KotlinSignatureComponent;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KotlinIntroduceTypeAliasDialog
extends DialogWrapper {
    private JPanel contentPane;
    private TitledSeparator inputParametersPanel;
    private JComboBox visibilityBox;
    private KotlinSignatureComponent signaturePreviewField;
    private JPanel aliasNamePanel;
    private NameSuggestionsField aliasNameField;
    private JLabel aliasNameLabel;
    private IntroduceTypeAliasParameterTablePanel parameterTablePanel;
    private final Project project;
    private final IntroduceTypeAliasDescriptor originalDescriptor;
    private IntroduceTypeAliasDescriptor currentDescriptor;
    private final Function1<KotlinIntroduceTypeAliasDialog, Unit> onAccept;

    public KotlinIntroduceTypeAliasDialog(@NotNull Project project, @NotNull IntroduceTypeAliasDescriptor originalDescriptor, @NotNull Function1<KotlinIntroduceTypeAliasDialog, Unit> onAccept) {
        if (project == null) {
            KotlinIntroduceTypeAliasDialog.$$$reportNull$$$0(0);
        }
        if (originalDescriptor == null) {
            KotlinIntroduceTypeAliasDialog.$$$reportNull$$$0(1);
        }
        if (onAccept == null) {
            KotlinIntroduceTypeAliasDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.project = project;
        this.originalDescriptor = originalDescriptor;
        this.currentDescriptor = originalDescriptor;
        this.onAccept = onAccept;
        this.$$$setupUI$$$();
        this.setModal(true);
        this.setTitle("Introduce Type Alias");
        this.init();
        this.update();
    }

    private void createUIComponents() {
        this.signaturePreviewField = new KotlinSignatureComponent("", this.project);
    }

    private boolean isVisibilitySectionAvailable() {
        return !this.getApplicableVisibilities().isEmpty();
    }

    @NotNull
    private List<KtModifierKeywordToken> getApplicableVisibilities() {
        List<KtModifierKeywordToken> list2 = IntroduceTypeAliasImplKt.getApplicableVisibilities(this.originalDescriptor.getOriginalData());
        if (list2 == null) {
            KotlinIntroduceTypeAliasDialog.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private String getAliasName() {
        return KtPsiUtilKt.quoteIfNeeded(this.aliasNameField.getEnteredName());
    }

    @Nullable
    private KtModifierKeywordToken getVisibility() {
        if (!this.isVisibilitySectionAvailable()) {
            return null;
        }
        return (KtModifierKeywordToken)((Object)this.visibilityBox.getSelectedItem());
    }

    private boolean checkNames() {
        if (!KtPsiUtilKt.isIdentifier(this.getAliasName())) {
            return false;
        }
        if (this.parameterTablePanel != null) {
            for (IntroduceTypeAliasParameterTablePanel.TypeParameterInfo parameterInfo : this.parameterTablePanel.getSelectedTypeParameterInfos()) {
                if (KtPsiUtilKt.isIdentifier(parameterInfo.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private void update() {
        this.currentDescriptor = this.createDescriptor();
        this.setOKActionEnabled(this.checkNames());
        this.signaturePreviewField.setText(IntroduceTypeAliasImplKt.generateTypeAlias(this.currentDescriptor, true).getText());
    }

    protected void init() {
        super.init();
        this.visibilityBox.setModel(new DefaultComboBoxModel<Object>(this.getApplicableVisibilities().toArray()));
        this.visibilityBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
                String tokenValue = value != null ? ((KtModifierKeywordToken)((Object)value)).getValue() : null;
                return super.getListCellRendererComponent((JList<?>)list2, tokenValue, index2, isSelected, cellHasFocus);
            }
        });
        this.aliasNameField = new NameSuggestionsField(new String[]{this.originalDescriptor.getName()}, this.project, (FileType)KotlinFileType.INSTANCE);
        this.aliasNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            public void dataChanged() {
                KotlinIntroduceTypeAliasDialog.this.update();
            }
        });
        this.aliasNamePanel.add((Component)this.aliasNameField, "Center");
        this.aliasNameLabel.setLabelFor((Component)this.aliasNameField);
        boolean enableVisibility = this.isVisibilitySectionAvailable();
        this.visibilityBox.setEnabled(enableVisibility);
        if (enableVisibility) {
            KtModifierKeywordToken defaultVisibility = this.originalDescriptor.getVisibility();
            if (defaultVisibility == null) {
                defaultVisibility = KtTokens.PUBLIC_KEYWORD;
            }
            this.visibilityBox.setSelectedItem((Object)defaultVisibility);
        }
        this.visibilityBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                KotlinIntroduceTypeAliasDialog.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceTypeAlias/ui/KotlinIntroduceTypeAliasDialog$3", "itemStateChanged"));
            }
        });
        if (!this.originalDescriptor.getTypeParameters().isEmpty()) {
            this.parameterTablePanel = new IntroduceTypeAliasParameterTablePanel(){

                @Override
                protected void updateSignature() {
                    KotlinIntroduceTypeAliasDialog.this.update();
                }

                @Override
                protected void onEnterAction() {
                    KotlinIntroduceTypeAliasDialog.this.doOKAction();
                }

                @Override
                protected void onCancelAction() {
                    KotlinIntroduceTypeAliasDialog.this.doCancelAction();
                }
            };
            this.parameterTablePanel.init(this.originalDescriptor.getTypeParameters());
            this.inputParametersPanel.setText("Type &Parameters");
            this.inputParametersPanel.setLabelFor((Component)this.parameterTablePanel.getTable());
            this.inputParametersPanel.add((Component)this.parameterTablePanel);
        } else {
            this.inputParametersPanel.setVisible(false);
        }
    }

    protected void doOKAction() {
        MultiMap<PsiElement, String> conflicts2 = IntroduceTypeAliasImplKt.validate(this.currentDescriptor).getConflicts();
        KotlinRefactoringUtilKt.checkConflictsInteractively(this.project, conflicts2, new Function0<Unit>(){

            public Unit invoke() {
                KotlinIntroduceTypeAliasDialog.this.close(0);
                return Unit.INSTANCE;
            }
        }, new Function0<Unit>(){

            public Unit invoke() {
                KotlinIntroduceTypeAliasDialog.super.doOKAction();
                return (Unit)KotlinIntroduceTypeAliasDialog.this.onAccept.invoke((Object)KotlinIntroduceTypeAliasDialog.this);
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.aliasNameField;
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @NotNull
    protected JComponent createContentPane() {
        JPanel jPanel2 = this.contentPane;
        if (jPanel2 == null) {
            KotlinIntroduceTypeAliasDialog.$$$reportNull$$$0(4);
        }
        return jPanel2;
    }

    @NotNull
    private IntroduceTypeAliasDescriptor createDescriptor() {
        IntroduceTypeAliasDescriptor introduceTypeAliasDescriptor = this.originalDescriptor.copy(this.originalDescriptor.getOriginalData(), this.getAliasName(), this.getVisibility(), this.parameterTablePanel != null ? this.parameterTablePanel.getSelectedTypeParameters() : Collections.emptyList());
        if (introduceTypeAliasDescriptor == null) {
            KotlinIntroduceTypeAliasDialog.$$$reportNull$$$0(5);
        }
        return introduceTypeAliasDescriptor;
    }

    public IntroduceTypeAliasDescriptor getCurrentDescriptor() {
        return this.currentDescriptor;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel2;
        JLabel jLabel;
        TitledSeparator titledSeparator;
        JPanel jPanel3;
        this.createUIComponents();
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        this.inputParametersPanel = titledSeparator = new TitledSeparator();
        titledSeparator.setLayout(new BorderLayout(0, 0));
        titledSeparator.setText("");
        jPanel5.add((Component)titledSeparator, "Center");
        titledSeparator.setBorder(BorderFactory.createTitledBorder(null, "Parameters", 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(-1, 200), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Signature Preview", 0, 0, null, null));
        KotlinSignatureComponent kotlinSignatureComponent = this.signaturePreviewField;
        kotlinSignatureComponent.setText("");
        jPanel7.add((Component)((Object)kotlinSignatureComponent), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(500, 100), new Dimension(500, 100), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setEnabled(true);
        ((Component)jPanel8).setVisible(true);
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.aliasNameLabel = jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Visibility:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        ((Component)jLabel2).setVisible(true);
        jPanel8.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(114, 16), null));
        this.aliasNamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.visibilityBox = jComboBox = new JComboBox();
        ((Component)jComboBox).setVisible(true);
        jPanel8.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 0, 2, 0, null, new Dimension(114, 26), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onAccept";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/introduce/introduceTypeAlias/ui/KotlinIntroduceTypeAliasDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/introduce/introduceTypeAlias/ui/KotlinIntroduceTypeAliasDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableVisibilities";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentPane";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

