/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.SurroundWithNullCheckFix$TypeMismatchFactory$createAction$;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003\u0014\u0015\u0016B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "expression", "nullableExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "nullableExpressionPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "IteratorOnNullableFactory", "TypeMismatchFactory", "idea"})
public final class SurroundWithNullCheckFix
extends KotlinQuickFixAction<KtExpression>
implements HighPriorityAction {
    private final SmartPsiElementPointer<KtExpression> nullableExpressionPointer;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Surround with null check";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression element3 = ktExpression;
        KtExpression ktExpression2 = (KtExpression)this.nullableExpressionPointer.getElement();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"nullableExpressionPointer.element ?: return");
        KtExpression nullableExpression = ktExpression2;
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        KtExpression surrounded = CreateByPatternKt.createExpressionByPattern$default(factory2, "if ($0 != null) { $1 }", new Object[]{nullableExpression, element3}, false, 4, null);
        element3.replace((PsiElement)surrounded);
    }

    public SurroundWithNullCheckFix(@NotNull KtExpression expression2, @NotNull KtExpression nullableExpression) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)nullableExpression, (String)"nullableExpression");
        super((PsiElement)expression2);
        this.nullableExpressionPointer = PsiUtilsKt.createSmartPointer((PsiElement)nullableExpression);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$IteratorOnNullableFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class IteratorOnNullableFactory
    extends KotlinSingleIntentionActionFactory {
        public static final IteratorOnNullableFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtReferenceExpression)) {
                psiElement2 = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)psiElement2;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression nullableExpression = ktReferenceExpression;
            PsiElement psiElement3 = nullableExpression.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"nullableExpression.parent");
            PsiElement psiElement4 = psiElement3.getParent();
            if (!(psiElement4 instanceof KtForExpression)) {
                psiElement4 = null;
            }
            KtForExpression ktForExpression = (KtForExpression)psiElement4;
            if (ktForExpression == null) {
                return null;
            }
            KtForExpression forExpression = ktForExpression;
            if (!(forExpression.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            if (!IfThenUtilsKt.isStableSimpleExpression$default(nullableExpression, null, 1, null)) {
                return null;
            }
            return new SurroundWithNullCheckFix(forExpression, nullableExpression);
        }

        private IteratorOnNullableFactory() {
        }

        static {
            IteratorOnNullableFactory iteratorOnNullableFactory;
            INSTANCE = iteratorOnNullableFactory = new IteratorOnNullableFactory();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$TypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class TypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final TypeMismatchFactory INSTANCE;

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtExpression rootCall;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.TYPE_MISMATCH.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.TYPE_MISMATCH.cast(diagnostic)");
            DiagnosticWithParameters2 typeMismatch = (DiagnosticWithParameters2)d;
            Object e = typeMismatch.getPsiElement();
            if (!(e instanceof KtReferenceExpression)) {
                e = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)e;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression nullableExpression = ktReferenceExpression;
            PsiElement psiElement2 = nullableExpression.getParent();
            if (!(psiElement2 instanceof KtValueArgument)) {
                psiElement2 = null;
            }
            KtValueArgument ktValueArgument = (KtValueArgument)psiElement2;
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument argument2 = ktValueArgument;
            PsiElement psiElement3 = (PsiElement)argument2;
            boolean strict$iv = true;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallExpression.class, (boolean)strict$iv);
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression call2 = ktCallExpression;
            PsiElement $receiver$iv2 = (PsiElement)call2;
            Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParents($receiver$iv2), (Function1)TypeMismatchFactory$createAction$$inlined$getLastParentOfTypeInRow$1.INSTANCE));
            if (!(object instanceof KtQualifiedExpression)) {
                object = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)object;
            KtExpression ktExpression = rootCall = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)call2;
            if (!(rootCall.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            Object a = typeMismatch.getA();
            Intrinsics.checkExpressionValueIsNotNull(a, (String)"typeMismatch.a");
            KotlinType kotlinType2 = (KotlinType)a;
            Object b = typeMismatch.getB();
            Intrinsics.checkExpressionValueIsNotNull(b, (String)"typeMismatch.b");
            if (!TypeUtilsKt.isNullabilityMismatch(kotlinType2, (KotlinType)b)) {
                return null;
            }
            if (!IfThenUtilsKt.isStableSimpleExpression$default(nullableExpression, null, 1, null)) {
                return null;
            }
            return new SurroundWithNullCheckFix(rootCall, nullableExpression);
        }

        private TypeMismatchFactory() {
        }

        static {
            TypeMismatchFactory typeMismatchFactory;
            INSTANCE = typeMismatchFactory = new TypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "hasAcceptableParent", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasAcceptableParent(@NotNull KtExpression $receiver) {
            PsiElement psiElement2 = $receiver.getParent();
            PsiElement $receiver2 = psiElement2;
            if ($receiver2 instanceof KtBlockExpression) return true;
            PsiElement psiElement3 = $receiver2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"this");
            if (psiElement3.getParent() instanceof KtIfExpression) return true;
            if ($receiver2 instanceof KtWhenEntry) return true;
            if (!($receiver2.getParent() instanceof KtLoopExpression)) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtExpression ktExpression;
            PsiElement parent2;
            void $receiver$iv;
            PsiElement element3;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement psiElement3 = element3 = psiElement2;
            boolean strict$iv = element3 instanceof KtOperationReferenceExpression;
            KtExpression ktExpression2 = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtExpression.class, (boolean)strict$iv);
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression expressionParent = ktExpression2;
            BindingContext context = ResolutionUtils.analyze(expressionParent, BodyResolveMode.PARTIAL_WITH_CFA);
            PsiElement psiElement4 = parent2 = element3.getParent();
            if (psiElement4 instanceof KtDotQualifiedExpression) {
                ktExpression = ((KtDotQualifiedExpression)parent2).getReceiverExpression();
            } else if (psiElement4 instanceof KtBinaryExpression) {
                ktExpression = ((KtBinaryExpression)parent2).getLeft();
            } else if (psiElement4 instanceof KtCallExpression) {
                ktExpression = ((KtCallExpression)parent2).getCalleeExpression();
            } else {
                return null;
            }
            KtExpression ktExpression3 = ktExpression;
            if (!(ktExpression instanceof KtReferenceExpression)) {
                ktExpression3 = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression3;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression nullableExpression = ktReferenceExpression;
            if (!IfThenUtilsKt.isStableSimpleExpression(nullableExpression, context)) {
                return null;
            }
            KtExpression ktExpression4 = (KtExpression)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)expressionParent, false, new Class[]{KtExpression.class}, (Function1)new Function1<KtExpression, Boolean>(context){
                final /* synthetic */ BindingContext $context;

                public final boolean invoke(@NotNull KtExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return !BindingContextUtilsKt.isUsedAsExpression(it, this.$context) && org.jetbrains.kotlin.idea.quickfix.SurroundWithNullCheckFix$Companion.access$hasAcceptableParent(SurroundWithNullCheckFix.Companion, it);
                }
                {
                    this.$context = bindingContext2;
                    super(1);
                }
            });
            if (ktExpression4 == null) {
                return null;
            }
            KtExpression expressionTarget2 = ktExpression4;
            if (expressionTarget2 instanceof KtDeclaration) {
                return null;
            }
            return new SurroundWithNullCheckFix(expressionTarget2, nullableExpression);
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$hasAcceptableParent(Companion $this, KtExpression $receiver) {
            return $this.hasAcceptableParent($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

