/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedValueFix$WhenMappings;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "showDialog", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$RemoveMode;", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "RemoveMode", "idea"})
public final class RemoveUnusedValueFix
extends KotlinQuickFixAction<KtBinaryExpression> {
    public static final Companion Companion = new Companion(null);

    private final RemoveMode showDialog(KtProperty variable2) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return RemoveMode.KEEP_INITIALIZE;
        }
        String message2 = "<html>\n                    <body>\n                        There are possible side effects found in expressions assigned to the variable '" + variable2.getName() + "'<br>\n                        You can:<br>\n                        -&nbsp;<b>Remove</b> the entire assignment, or<br>\n                        -&nbsp;<b>Transform</b> assignment right-hand side into the statement on its own.<br>\n                    </body>\n                </html>";
        int exitCode = Messages.showYesNoCancelDialog((Project)variable2.getProject(), (String)message2, (String)QuickFixBundle.message((String)"side.effects.warning.dialog.title", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.remove", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.transform", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.cancel", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        return RemoveMode.values()[exitCode];
    }

    @NotNull
    public String getFamilyName() {
        return "Remove redundant assignment";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)this.getElement();
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression element3 = ktBinaryExpression;
        KtExpression ktExpression = element3.getLeft();
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lhs = ktSimpleNameExpression;
        KtExpression ktExpression2 = element3.getRight();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"element.right ?: return");
        KtExpression rhs = ktExpression2;
        PsiElement psiElement2 = ReferenceUtilKt.getMainReference(lhs).resolve();
        if (!(psiElement2 instanceof KtProperty)) {
            psiElement2 = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement2;
        if (ktProperty == null) {
            return;
        }
        KtProperty variable2 = ktProperty;
        Pseudocode pseudocode2 = PseudocodeUtilsKt.getContainingPseudocode(rhs, ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL));
        Object object = pseudocode2;
        boolean isSideEffectFree = object != null && (object = object.getElementValue(rhs)) != null && (object = object.getCreatedAt()) != null ? PseudocodeUtilsKt.getSideEffectFree((Instruction)object) : false;
        RemoveMode removeMode = RemoveMode.REMOVE_ALL;
        if (!isSideEffectFree) {
            removeMode = this.showDialog(variable2);
        }
        switch (RemoveUnusedValueFix$WhenMappings.$EnumSwitchMapping$0[removeMode.ordinal()]) {
            case 1: {
                element3.delete();
                break;
            }
            case 2: {
                element3.replace((PsiElement)rhs);
            }
        }
    }

    public RemoveUnusedValueFix(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        super((PsiElement)expression2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$RemoveMode;", "", "(Ljava/lang/String;I)V", "REMOVE_ALL", "KEEP_INITIALIZE", "CANCEL", "idea"})
    public static final class RemoveMode
    extends Enum<RemoveMode> {
        public static final /* enum */ RemoveMode REMOVE_ALL;
        public static final /* enum */ RemoveMode KEEP_INITIALIZE;
        public static final /* enum */ RemoveMode CANCEL;
        private static final /* synthetic */ RemoveMode[] $VALUES;

        static {
            RemoveMode[] removeModeArray = new RemoveMode[3];
            RemoveMode[] removeModeArray2 = removeModeArray;
            removeModeArray[0] = REMOVE_ALL = new RemoveMode();
            removeModeArray[1] = KEEP_INITIALIZE = new RemoveMode();
            removeModeArray[2] = CANCEL = new RemoveMode();
            $VALUES = removeModeArray;
        }

        public static RemoveMode[] values() {
            return (RemoveMode[])$VALUES.clone();
        }

        public static RemoveMode valueOf(String string) {
            return Enum.valueOf(RemoveMode.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.UNUSED_VALUE.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.UNUSED_VALUE.cast(diagnostic)");
            Object e = ((DiagnosticWithParameters2)d).getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"Errors.UNUSED_VALUE.cast(diagnostic).psiElement");
            KtBinaryExpression expression2 = (KtBinaryExpression)e;
            if (!KtPsiUtil.isAssignment((PsiElement)expression2)) {
                return null;
            }
            if (!(expression2.getLeft() instanceof KtSimpleNameExpression)) {
                return null;
            }
            return new RemoveUnusedValueFix(expression2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

