/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SamConversionToAnonymousObjectIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.tower.WrongResolutionToClassifier;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertToAnonymousObjectFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "element", "(Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class ConvertToAnonymousObjectFix
extends KotlinQuickFixAction<KtNameReferenceExpression> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Convert to anonymous object";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Named named;
        KtCallExpression call2;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)this.getElement();
            if (ktNameReferenceExpression == null) {
                return;
            }
            KtNameReferenceExpression nameReference = ktNameReferenceExpression;
            PsiElement psiElement2 = nameReference.getParent();
            if (!(psiElement2 instanceof KtCallExpression)) {
                psiElement2 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
            if (ktCallExpression == null) {
                return;
            }
            call2 = ktCallExpression;
            Iterable $receiver$iv = ResolutionUtils.analyze$default(nameReference, null, 1, null).getDiagnostics().forElement((PsiElement)nameReference);
            for (Object element$iv : $receiver$iv) {
                SimpleFunctionDescriptor result$iv;
                SimpleFunctionDescriptor simpleFunctionDescriptor;
                Diagnostic it = (Diagnostic)element$iv;
                if (Intrinsics.areEqual(it.getFactory(), Errors.RESOLUTION_TO_CLASSIFIER)) {
                    Object d = Errors.RESOLUTION_TO_CLASSIFIER.cast(it);
                    Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.RESOLUTION_TO_CLASSIFIER.cast(it)");
                    simpleFunctionDescriptor = ConvertToAnonymousObjectFix.Companion.getFunctionDescriptor((DiagnosticWithParameters3)d);
                } else {
                    simpleFunctionDescriptor = null;
                }
                if ((result$iv = simpleFunctionDescriptor) == null) continue;
                named = result$iv;
                break block7;
            }
            named = null;
        }
        if (named == null) {
            return;
        }
        Named functionDescriptor2 = named;
        String string = functionDescriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"functionDescriptor.name.asString()");
        String functionName = string;
        SamConversionToAnonymousObjectIntention.Companion.convertToAnonymousObject(call2, (FunctionDescriptor)functionDescriptor2, functionName);
    }

    public ConvertToAnonymousObjectFix(@NotNull KtNameReferenceExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J*\u0010\b\u001a\u0004\u0018\u00010\t2\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertToAnonymousObjectFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "d", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticWithParameters3;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/tower/WrongResolutionToClassifier;", "", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtNameReferenceExpression> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.RESOLUTION_TO_CLASSIFIER.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.RESOLUTION_TO_CLASSIFIER.cast(diagnostic)");
            DiagnosticWithParameters3 casted = (DiagnosticWithParameters3)d;
            if ((WrongResolutionToClassifier)((Object)casted.getB()) != WrongResolutionToClassifier.INTERFACE_AS_FUNCTION) {
                return null;
            }
            Object e = casted.getPsiElement();
            if (!(e instanceof KtNameReferenceExpression)) {
                e = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)e;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression nameReference = ktNameReferenceExpression;
            PsiElement psiElement2 = nameReference.getParent();
            if (!(psiElement2 instanceof KtCallExpression)) {
                psiElement2 = null;
            }
            if ((KtCallExpression)psiElement2 == null) {
                return null;
            }
            if (this.getFunctionDescriptor(casted) == null) {
                return null;
            }
            return new ConvertToAnonymousObjectFix(nameReference);
        }

        private final SimpleFunctionDescriptor getFunctionDescriptor(DiagnosticWithParameters3<KtReferenceExpression, ClassifierDescriptor, WrongResolutionToClassifier, String> d) {
            CallableMemberDescriptor callableMemberDescriptor;
            Object object;
            ClassifierDescriptor classifierDescriptor = d.getA();
            if (!(classifierDescriptor instanceof LazyClassDescriptor)) {
                classifierDescriptor = null;
            }
            if (!(((object = (LazyClassDescriptor)classifierDescriptor) != null && (object = ((LazyClassDescriptor)object).getDeclaredCallableMembers()) != null ? (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object)) : (callableMemberDescriptor = null)) instanceof SimpleFunctionDescriptor)) {
                callableMemberDescriptor = null;
            }
            return (SimpleFunctionDescriptor)callableMemberDescriptor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

