/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AssignOperatorAmbiguityFactoryKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableMutabilityFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplaceWithAssignFunctionCallFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AssignOperatorAmbiguityFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
public final class AssignOperatorAmbiguityFactory
extends KotlinIntentionActionsFactory {
    public static final AssignOperatorAmbiguityFactory INSTANCE;

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        List fixes = new ArrayList();
        PsiElement psiElement2 = diagnostic.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
        PsiElement element3 = psiElement2.getParent();
        if (element3 instanceof KtBinaryExpression) {
            BindingContext context;
            String operationText;
            KtExpression left = ((KtBinaryExpression)element3).getLeft();
            KtExpression right = ((KtBinaryExpression)element3).getRight();
            IElementType iElementType = ((KtBinaryExpression)element3).getOperationToken();
            String string = Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSEQ)) ? "plus" : (operationText = Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSEQ)) ? "minus" : null);
            if (left != null && right != null && operationText != null && AssignOperatorAmbiguityFactoryKt.access$isMutableCollection(CallUtilKt.getType(left, context = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL)))) {
                String propertyName;
                KtProperty property;
                KtReference ktReference = ReferenceUtilKt.getMainReference(left);
                Object object = ktReference != null ? ktReference.resolve() : null;
                if (!(object instanceof KtProperty)) {
                    object = null;
                }
                KtProperty ktProperty = property = (KtProperty)object;
                String string2 = propertyName = ktProperty != null ? ktProperty.getName() : null;
                if (property != null && propertyName != null && property.isLocal()) {
                    fixes.add(new ChangeVariableMutabilityFix(property, false, "Change '" + propertyName + "' to val", false, 8, null));
                }
                fixes.add(new ReplaceWithAssignFunctionCallFix((KtBinaryExpression)element3, operationText));
            }
        }
        return fixes;
    }

    private AssignOperatorAmbiguityFactory() {
    }

    static {
        AssignOperatorAmbiguityFactory assignOperatorAmbiguityFactory;
        INSTANCE = assignOperatorAmbiguityFactory = new AssignOperatorAmbiguityFactory();
    }
}

