/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddExplicitImportForDeprecatedVisibilityFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "expression", "targetFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/name/FqName;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Factory", "idea"})
public final class AddExplicitImportForDeprecatedVisibilityFix
extends KotlinQuickFixAction<KtElement> {
    private final FqName targetFqName;

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ResolutionUtils.resolveImportReference(file, this.targetFqName));
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor targetDescriptor = declarationDescriptor;
        ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(project), file, targetDescriptor, false, 4, null);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Add explicit import";
    }

    public AddExplicitImportForDeprecatedVisibilityFix(@NotNull KtElement expression2, @NotNull FqName targetFqName) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)targetFqName, (String)"targetFqName");
        super((PsiElement)expression2);
        this.targetFqName = targetFqName;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddExplicitImportForDeprecatedVisibilityFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        public static final Factory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            if (Intrinsics.areEqual(diagnostic.getFactory(), Errors.DEPRECATED_ACCESS_BY_SHORT_NAME) ^ true) {
                return null;
            }
            Object d = Errors.DEPRECATED_ACCESS_BY_SHORT_NAME.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.DEPRECATED_ACCESS\u2026ORT_NAME.cast(diagnostic)");
            DiagnosticWithParameters1 castedDiagnostic = (DiagnosticWithParameters1)d;
            Object e = castedDiagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"castedDiagnostic.psiElement");
            KtElement soonToBeDeprecatedType = (KtElement)e;
            Object a = castedDiagnostic.getA();
            Intrinsics.checkExpressionValueIsNotNull(a, (String)"castedDiagnostic.a");
            FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)a);
            if (fqName2 == null) {
                return null;
            }
            FqName importableFqNameOfTargetDescriptor = fqName2;
            return new AddExplicitImportForDeprecatedVisibilityFix(soonToBeDeprecatedType, importableFqNameOfTargetDescriptor);
        }

        private Factory() {
        }

        static {
            Factory factory2;
            INSTANCE = factory2 = new Factory();
        }
    }
}

