/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddDefaultConstructorFix$Companion$createAction$;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddDefaultConstructorFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtClass;", "expectClass", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class AddDefaultConstructorFix
extends KotlinQuickFixAction<KtClass> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Add default constructor to expect class";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtClass ktClass2 = (KtClass)this.getElement();
            if (ktClass2 == null) break block0;
            KtClassKt.createPrimaryConstructorIfAbsent(ktClass2);
        }
    }

    public AddDefaultConstructorFix(@NotNull KtClass expectClass) {
        Intrinsics.checkParameterIsNotNull((Object)expectClass, (String)"expectClass");
        super((PsiElement)expectClass);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddDefaultConstructorFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtClass;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "superTypeEntryToClass", "typeEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Nullable
        public final KtClass superTypeEntryToClass(@NotNull KtSuperTypeListEntry typeEntry, @NotNull BindingContext context) {
            Intrinsics.checkParameterIsNotNull((Object)typeEntry, (String)"typeEntry");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            KotlinType kotlinType2 = (KotlinType)context.get(BindingContext.TYPE, typeEntry.getTypeReference());
            if (kotlinType2 == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context[BindingContext.T\u2026Reference] ?: return null");
            KotlinType baseType = kotlinType2;
            ClassifierDescriptor classifierDescriptor = baseType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor2 == null) {
                return null;
            }
            ClassDescriptor baseClassDescriptor2 = classDescriptor2;
            if (!baseClassDescriptor2.isExpect()) {
                return null;
            }
            if (baseClassDescriptor2.getKind() != ClassKind.CLASS) {
                return null;
            }
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(baseClassDescriptor2);
            if (!(psiElement2 instanceof KtClass)) {
                psiElement2 = null;
            }
            return (KtClass)psiElement2;
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtClass> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtValueArgumentList)) {
                psiElement2 = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement2;
            if (ktValueArgumentList == null) {
                return null;
            }
            KtValueArgumentList argumentList2 = ktValueArgumentList;
            List<KtValueArgument> list2 = argumentList2.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"argumentList.arguments");
            Collection collection = list2;
            if (!collection.isEmpty()) {
                return null;
            }
            PsiElement $receiver$iv = (PsiElement)argumentList2;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)true);
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject derivedClass = ktClassOrObject;
            BindingContext context = ResolutionUtils.analyze$default(derivedClass, null, 1, null);
            Sequence $receiver$iv2 = CollectionsKt.asSequence((Iterable)derivedClass.getSuperTypeListEntries());
            Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv2, (Function1)Companion$createAction$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            KtSuperTypeCallEntry ktSuperTypeCallEntry = (KtSuperTypeCallEntry)SequencesKt.firstOrNull((Sequence)sequence2);
            if (ktSuperTypeCallEntry == null) {
                return null;
            }
            KtSuperTypeCallEntry baseTypeCallEntry = ktSuperTypeCallEntry;
            KtClass ktClass2 = this.superTypeEntryToClass(baseTypeCallEntry, context);
            if (ktClass2 == null) {
                return null;
            }
            KtClass baseClass = ktClass2;
            return new AddDefaultConstructorFix(baseClass);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

