/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a)\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000b\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\r\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u00010\u0003H\u0002\u001a\n\u0010\u000f\u001a\u00020\r*\u00020\r\u001a\u0014\u0010\u0010\u001a\u00020\u0003*\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a8\u0006\u0011"}, d2={"appendConditionWithSubjectRemoved", "", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "conditionExpression", "subject", "combineWhenConditions", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "conditions", "", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "(Lorg/jetbrains/kotlin/psi/KtPsiFactory;[Lorg/jetbrains/kotlin/psi/KtWhenCondition;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "getSubjectToIntroduce", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "getWhenConditionSubjectCandidate", "introduceSubject", "toExpression", "idea"})
public final class BranchedTransformationUtilsKt {
    @NotNull
    public static final KtExpression toExpression(@NotNull KtWhenCondition $receiver, @Nullable KtExpression subject) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$receiver, false, 2, null);
        KtWhenCondition ktWhenCondition = $receiver;
        if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            Object object;
            String op = ((KtWhenConditionIsPattern)$receiver).isNegated() ? "!is" : "is";
            String string = "$0 " + op + " $1";
            Object[] objectArray = new Object[2];
            Object object2 = subject;
            if (object2 == null) {
                object2 = objectArray[0] = "_";
            }
            if ((object = ((KtWhenConditionIsPattern)$receiver).getTypeReference()) == null) {
                object = "";
            }
            objectArray[1] = object;
            ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, string, objectArray, false, 4, null);
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            Object object;
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtWhenConditionInRange)$receiver).getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"operationReference");
            String op = ktOperationReferenceExpression.getText();
            String string = "$0 " + op + " $1";
            Object[] objectArray = new Object[2];
            Object object3 = subject;
            if (object3 == null) {
                object3 = objectArray[0] = "_";
            }
            if ((object = ((KtWhenConditionInRange)$receiver).getRangeExpression()) == null) {
                object = "";
            }
            objectArray[1] = object;
            ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, string, objectArray, false, 4, null);
        } else if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            if (subject != null) {
                Object[] objectArray = new Object[2];
                objectArray[0] = subject;
                Object object = ((KtWhenConditionWithExpression)$receiver).getExpression();
                if (object == null) {
                    object = "";
                }
                objectArray[1] = object;
                ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "$0 == $1", objectArray, false, 4, null);
            } else {
                KtExpression ktExpression2 = ((KtWhenConditionWithExpression)$receiver).getExpression();
                if (ktExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                ktExpression = ktExpression2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression!!");
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown JetWhenCondition type: " + $receiver);
        }
        return ktExpression;
    }

    @Nullable
    public static final KtExpression getSubjectToIntroduce(@NotNull KtWhenExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver.getSubjectExpression() != null) {
            return null;
        }
        KtExpression lastCandidate = null;
        Iterator<KtWhenEntry> iterator2 = $receiver.getEntries().iterator();
        while (iterator2.hasNext()) {
            KtWhenCondition[] conditions2;
            KtWhenCondition[] ktWhenConditionArray;
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry.getConditions(), (String)"entry.conditions");
            if (!entry.isElse() && (ktWhenConditionArray = conditions2).length == 0) {
                return null;
            }
            for (KtWhenCondition condition2 : conditions2) {
                KtNameReferenceExpression candidate2;
                if (!(condition2 instanceof KtWhenConditionWithExpression)) {
                    return null;
                }
                KtExpression ktExpression = ((KtWhenConditionWithExpression)condition2).getExpression();
                KtExpression ktExpression2 = ktExpression != null ? BranchedTransformationUtilsKt.getWhenConditionSubjectCandidate(ktExpression) : null;
                if (!(ktExpression2 instanceof KtNameReferenceExpression)) {
                    ktExpression2 = null;
                }
                if ((KtNameReferenceExpression)ktExpression2 == null) {
                    return null;
                }
                if (lastCandidate == null) {
                    lastCandidate = candidate2;
                    continue;
                }
                if (KotlinPsiUnifierKt.matches((PsiElement)lastCandidate, (PsiElement)candidate2)) continue;
                return null;
            }
        }
        return lastCandidate;
    }

    private static final KtExpression getWhenConditionSubjectCandidate(@Nullable KtExpression $receiver) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = $receiver;
        if (ktExpression2 instanceof KtIsExpression) {
            ktExpression = ((KtIsExpression)$receiver).getLeftHandSide();
        } else if (ktExpression2 instanceof KtBinaryExpression) {
            IElementType op;
            KtExpression lhs = ((KtBinaryExpression)$receiver).getLeft();
            IElementType iElementType = ((KtBinaryExpression)$receiver).getOperationToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"operationToken");
            IElementType iElementType2 = op = iElementType;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.IN_KEYWORD)) || Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.NOT_IN))) {
                ktExpression = lhs;
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.EQEQ))) {
                KtExpression ktExpression3 = lhs;
                if (!(ktExpression3 instanceof KtNameReferenceExpression)) {
                    ktExpression3 = null;
                }
                KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression3;
                ktExpression = ktNameReferenceExpression != null ? (KtExpression)ktNameReferenceExpression : ((KtBinaryExpression)$receiver).getRight();
            } else {
                KtExpression rightCandidate;
                KtExpression leftCandidate;
                ktExpression = Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.OROR)) ? (KotlinPsiUnifierKt.matches((PsiElement)(leftCandidate = BranchedTransformationUtilsKt.getWhenConditionSubjectCandidate(lhs)), (PsiElement)(rightCandidate = BranchedTransformationUtilsKt.getWhenConditionSubjectCandidate(((KtBinaryExpression)$receiver).getRight()))) ? leftCandidate : null) : null;
            }
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    @NotNull
    public static final KtWhenExpression introduceSubject(@NotNull KtWhenExpression $receiver) {
        KtWhenExpression ktWhenExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        KtExpression ktExpression = BranchedTransformationUtilsKt.getSubjectToIntroduce($receiver);
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression subject = ktExpression;
        CommentSaver commentSaver = new CommentSaver((PsiElement)$receiver, true);
        KtExpression ktExpression2 = CreateByPatternKt.buildExpression$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$receiver, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>($receiver, subject){
            final /* synthetic */ KtWhenExpression $this_introduceSubject;
            final /* synthetic */ KtExpression $subject;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                $receiver.appendFixedText("when(").appendExpression(this.$subject).appendFixedText("){\n");
                Iterator<KtWhenEntry> iterator2 = this.$this_introduceSubject.getEntries().iterator();
                while (iterator2.hasNext()) {
                    KtWhenEntry entry;
                    KtWhenEntry ktWhenEntry = entry = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
                    KtExpression branchExpression = ktWhenEntry.getExpression();
                    if (entry.isElse()) {
                        $receiver.appendFixedText("else");
                    } else {
                        KtWhenCondition[] ktWhenConditionArray;
                        Intrinsics.checkExpressionValueIsNotNull((Object)entry.getConditions(), (String)"entry.conditions");
                        int n = ktWhenConditionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            void i2;
                            KtWhenCondition condition2 = ktWhenConditionArray[n2];
                            if (i2 > 0) {
                                $receiver.appendFixedText(",");
                            }
                            KtWhenCondition ktWhenCondition = condition2;
                            if (ktWhenCondition == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenConditionWithExpression");
                            }
                            KtExpression conditionExpression = ((KtWhenConditionWithExpression)ktWhenCondition).getExpression();
                            BranchedTransformationUtilsKt.access$appendConditionWithSubjectRemoved($receiver, conditionExpression, this.$subject);
                            ++i2;
                        }
                    }
                    $receiver.appendFixedText("->");
                    $receiver.appendExpression(branchExpression);
                    $receiver.appendFixedText("\n");
                }
                $receiver.appendFixedText("}");
            }
            {
                this.$this_introduceSubject = ktWhenExpression;
                this.$subject = ktExpression;
                super(1);
            }
        }, 1, null);
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
        }
        PsiElement $receiver$iv = (PsiElement)$receiver;
        KtWhenExpression whenExpression2 = (KtWhenExpression)ktExpression2;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)whenExpression2);
        PsiElement psiElement2 = result$iv;
        if (!(psiElement2 instanceof KtWhenExpression)) {
            psiElement2 = null;
        }
        if ((ktWhenExpression = (KtWhenExpression)psiElement2) == null) {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
            }
            ktWhenExpression = (KtWhenExpression)ktExpression3;
        }
        KtWhenExpression result2 = ktWhenExpression;
        CommentSaver.restore$default(commentSaver, (PsiElement)result2, false, 2, null);
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void appendConditionWithSubjectRemoved(@NotNull BuilderByPattern<KtExpression> $receiver, KtExpression conditionExpression, KtExpression subject) {
        KtExpression ktExpression = conditionExpression;
        if (ktExpression instanceof KtIsExpression) {
            if (((KtIsExpression)conditionExpression).isNegated()) {
                $receiver.appendFixedText("!");
            }
            $receiver.appendFixedText("is ");
            Object object = ((KtIsExpression)conditionExpression).getTypeReference();
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            $receiver.appendNonFormattedText((String)object);
            return;
        } else {
            IElementType op;
            if (!(ktExpression instanceof KtBinaryExpression)) throw (Throwable)new IllegalStateException();
            KtExpression lhs = ((KtBinaryExpression)conditionExpression).getLeft();
            KtExpression rhs = ((KtBinaryExpression)conditionExpression).getRight();
            IElementType iElementType = ((KtBinaryExpression)conditionExpression).getOperationToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"conditionExpression.operationToken");
            IElementType iElementType2 = op = iElementType;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.IN_KEYWORD))) {
                $receiver.appendFixedText("in ").appendExpression(rhs);
                return;
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.NOT_IN))) {
                $receiver.appendFixedText("!in ").appendExpression(rhs);
                return;
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.EQEQ))) {
                $receiver.appendExpression(KotlinPsiUnifierKt.matches((PsiElement)subject, (PsiElement)lhs) ? rhs : lhs);
                return;
            } else {
                if (!Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.OROR))) throw (Throwable)new IllegalStateException();
                BranchedTransformationUtilsKt.appendConditionWithSubjectRemoved($receiver, lhs, subject);
                $receiver.appendFixedText(", ");
                BranchedTransformationUtilsKt.appendConditionWithSubjectRemoved($receiver, rhs, subject);
            }
        }
    }

    @Nullable
    public static final KtExpression combineWhenConditions(@NotNull KtPsiFactory $receiver, @NotNull KtWhenCondition[] conditions2, @Nullable KtExpression subject) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)conditions2, (String)"conditions");
        switch (conditions2.length) {
            case 0: {
                ktExpression = null;
                break;
            }
            case 1: {
                ktExpression = BranchedTransformationUtilsKt.toExpression(conditions2[0], subject);
                break;
            }
            default: {
                ktExpression = CreateByPatternKt.buildExpression$default($receiver, false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(conditions2, subject){
                    final /* synthetic */ KtWhenCondition[] $conditions;
                    final /* synthetic */ KtExpression $subject;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                        Collection<KtExpression> collection;
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                        KtWhenCondition[] ktWhenConditionArray = this.$conditions;
                        BuilderByPattern<KtExpression> builderByPattern = $receiver;
                        void var3_4 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(((void)$receiver$iv).length);
                        void var5_6 = $receiver$iv$iv;
                        int n = ((void)var5_6).length;
                        for (int j = 0; j < n; ++j) {
                            void it;
                            void item$iv$iv;
                            void var9_10 = item$iv$iv = var5_6[j];
                            collection = destination$iv$iv;
                            KtExpression ktExpression = BranchedTransformationUtilsKt.toExpression((KtWhenCondition)it, this.$subject);
                            collection.add(ktExpression);
                        }
                        collection = (List)destination$iv$iv;
                        builderByPattern.appendExpressions((Iterable<KtExpression>)collection, "||");
                    }
                    {
                        this.$conditions = ktWhenConditionArray;
                        this.$subject = ktExpression;
                        super(1);
                    }
                }, 1, null);
            }
        }
        return ktExpression;
    }

    public static final /* synthetic */ void access$appendConditionWithSubjectRemoved(BuilderByPattern $receiver, KtExpression conditionExpression, KtExpression subject) {
        BranchedTransformationUtilsKt.appendConditionWithSubjectRemoved($receiver, conditionExpression, subject);
    }
}

