/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveRedundantCallsOfConversionMethodsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "()V", "targetClassMap", "", "", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFqNameAsString", "Lorg/jetbrains/kotlin/types/KotlinType;", "isApplicableReceiverExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "qualifiedName", "idea"})
public final class RemoveRedundantCallsOfConversionMethodsIntention
extends SelfTargetingRangeIntention<KtQualifiedExpression> {
    private final Map<String, String> targetClassMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"toString()", (Object)Reflection.getOrCreateKotlinClass(String.class).getQualifiedName()), TuplesKt.to((Object)"toDouble()", (Object)Reflection.getOrCreateKotlinClass(Double.TYPE).getQualifiedName()), TuplesKt.to((Object)"toFloat()", (Object)Reflection.getOrCreateKotlinClass(Float.TYPE).getQualifiedName()), TuplesKt.to((Object)"toLong()", (Object)Reflection.getOrCreateKotlinClass(Long.TYPE).getQualifiedName()), TuplesKt.to((Object)"toInt()", (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE).getQualifiedName()), TuplesKt.to((Object)"toChar()", (Object)Reflection.getOrCreateKotlinClass(Character.TYPE).getQualifiedName()), TuplesKt.to((Object)"toShort()", (Object)Reflection.getOrCreateKotlinClass(Short.TYPE).getQualifiedName()), TuplesKt.to((Object)"toByte()", (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE).getQualifiedName())});

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtQualifiedExpression element3, @Nullable Editor editor2) {
        KtExpression ktExpression;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = (PsiElement)element3;
        PsiElement newElement$iv = (PsiElement)element3.getReceiverExpression();
        PsiElement result$iv = $receiver$iv.replace(newElement$iv);
        PsiElement psiElement3 = result$iv;
        if (!(psiElement3 instanceof KtExpression)) {
            psiElement3 = null;
        }
        if ((ktExpression = (KtExpression)psiElement3) == null) {
            PsiElement psiElement4 = result$iv;
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            ktExpression = ((KtParenthesizedExpression)psiElement4).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selectorExpression = ktExpression;
        String selectorExpressionText = selectorExpression.getText();
        String string = this.targetClassMap.get(selectorExpressionText);
        if (string == null) {
            return null;
        }
        String qualifiedName2 = string;
        return this.isApplicableReceiverExpression(element3.getReceiverExpression(), qualifiedName2) ? selectorExpression.getTextRange() : null;
    }

    private final String getFqNameAsString(@NotNull KotlinType $receiver) {
        String string;
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor classifierDescriptor2;
            ClassifierDescriptor it = classifierDescriptor2 = classifierDescriptor;
            string = DescriptorUtils.getFqName(it).asString();
        } else {
            string = null;
        }
        return string;
    }

    private final boolean isApplicableReceiverExpression(@NotNull KtExpression $receiver, String qualifiedName2) {
        Object object;
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtStringTemplateExpression) {
            object = Reflection.getOrCreateKotlinClass(String.class).getQualifiedName();
        } else if (ktExpression instanceof KtConstantExpression) {
            KotlinType kotlinType2 = CallUtilKt.getType($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
            object = kotlinType2 != null ? this.getFqNameAsString(kotlinType2) : null;
        } else {
            KtElement ktElement;
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default($receiver, null, 1, null);
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
            Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"OperatorConventions.COMPARISON_OPERATIONS");
            Iterable iterable = (Iterable)immutableSet;
            Object object2 = resolvedCall2;
            if (!((object2 != null && (object2 = object2.getCall()) != null ? object2.getCallElement() : (ktElement = null)) instanceof KtBinaryExpression)) {
                ktElement = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
            if (CollectionsKt.contains((Iterable)iterable, (Object)(ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null))) {
                object = Reflection.getOrCreateKotlinClass(Boolean.TYPE).getQualifiedName();
            } else {
                Object object3 = resolvedCall2;
                if (object3 != null && (object3 = object3.getCandidateDescriptor()) != null && (object3 = object3.getReturnType()) != null) {
                    Object object4;
                    Object it;
                    Object object5 = it = (object4 = object3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"it");
                    object = FlexibleTypesKt.isFlexible((KotlinType)object5) ? null : (!($receiver.getParent() instanceof KtSafeQualifiedExpression) && ($receiver instanceof KtSafeQualifiedExpression || ((KotlinType)it).isMarkedNullable()) ? null : this.getFqNameAsString((KotlinType)it));
                } else {
                    object = null;
                }
            }
        }
        return Intrinsics.areEqual((Object)object, (Object)qualifiedName2);
    }

    public RemoveRedundantCallsOfConversionMethodsIntention() {
        super(KtQualifiedExpression.class, "Remove redundant calls of the conversion method", null, 4, null);
    }
}

