/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveLabeledReturnInLambdaIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class RemoveLabeledReturnInLambdaIntention
extends SelfTargetingIntention<KtReturnExpression>
implements LowPriorityAction {
    @Override
    public boolean isApplicableTo(@NotNull KtReturnExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        String string = element3.getLabelName();
        if (string == null) {
            return false;
        }
        String labelName2 = string;
        PsiElement $receiver$iv = (PsiElement)element3;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtBlockExpression.class, (boolean)true);
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression block = ktBlockExpression;
        List<KtExpression> list2 = block.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"block.statements");
        if (Intrinsics.areEqual((Object)((KtExpression)CollectionsKt.lastOrNull(list2)), (Object)element3) ^ true) {
            return false;
        }
        String string2 = UtilsKt.getParentLambdaLabelName(block);
        if (string2 == null) {
            return false;
        }
        String callName = string2;
        if (Intrinsics.areEqual((Object)labelName2, (Object)callName) ^ true) {
            return false;
        }
        this.setText("Remove return@" + labelName2);
        return true;
    }

    @Override
    public void applyTo(@NotNull KtReturnExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression returnedExpression = element3.getReturnedExpression();
        if (returnedExpression == null) {
            element3.delete();
        } else {
            element3.replace((PsiElement)returnedExpression);
        }
    }

    public RemoveLabeledReturnInLambdaIntention() {
        super(KtReturnExpression.class, "Remove labeled return from last expression in a lambda", null, 4, null);
    }
}

