/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H$J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0007H\u0004J\u0016\u0010\"\u001a\u0004\u0018\u00010!*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\nH\u0004J\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020\u001cH\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010\u0007*\u00020!H\u0004J\f\u0010&\u001a\u00020\n*\u00020\u001cH\u0002J$\u0010'\u001a\u00020\u0010*\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u0016H\u0002R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention;", "TExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "elementType", "Ljava/lang/Class;", "text", "", "(Ljava/lang/Class;Ljava/lang/String;)V", "isParameterScopeFunction", "", "()Z", "scopeReceiverName", "getScopeReceiverName", "()Ljava/lang/String;", "applyWithGivenReceiverText", "", "expression", "receiverExpressionText", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;)V", "createScopeExpression", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "element", "(Lorg/jetbrains/kotlin/psi/KtPsiFactory;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "findBoundaryExpression", "forward", "findCallExpressionFrom", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "scopeExpression", "findFirstExpressionToMove", "findLastExpressionToMove", "isApplicableWithGivenReceiverText", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "getDotQualifiedSiblingIfAny", "getFirstLambdaArgumentBody", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "getReceiverExpressionText", "isApplicable", "moveRangeInto", "firstElement", "Lcom/intellij/psi/PsiElement;", "lastElement", "psiFactory", "idea"})
public abstract class ConvertToScopeIntention<TExpression extends KtExpression>
extends SelfTargetingIntention<TExpression> {
    public abstract boolean isParameterScopeFunction();

    @NotNull
    protected final String getScopeReceiverName() {
        return this.isParameterScopeFunction() ? "it" : "this";
    }

    @Nullable
    protected abstract KtExpression createScopeExpression(@NotNull KtPsiFactory var1, @NotNull TExpression var2);

    @Nullable
    protected abstract KtCallExpression findCallExpressionFrom(@NotNull KtExpression var1);

    @Nullable
    protected final String getReceiverExpressionText(@NotNull KtDotQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return UtilsKt.getLeftMostReceiverExpression($receiver).getText();
    }

    protected final boolean isApplicableWithGivenReceiverText(@NotNull KtDotQualifiedExpression expression2, @NotNull String receiverExpressionText) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)receiverExpressionText, (String)"receiverExpressionText");
        if (Intrinsics.areEqual((Object)receiverExpressionText, (Object)this.getReceiverExpressionText(expression2)) ^ true) {
            return false;
        }
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(expression2);
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        if (!this.isApplicable(callExpression2)) {
            return false;
        }
        KtExpression receiverExpression = expression2.getReceiverExpression();
        return !(receiverExpression instanceof KtDotQualifiedExpression) || this.isApplicableWithGivenReceiverText((KtDotQualifiedExpression)receiverExpression, receiverExpressionText);
    }

    protected final void applyWithGivenReceiverText(@NotNull TExpression expression2, @NotNull String receiverExpressionText) {
        PsiElement firstExpressionToMove;
        Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)receiverExpressionText, (String)"receiverExpressionText");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
        KtExpression ktExpression = this.createScopeExpression(factory2, expression2);
        if (ktExpression == null) {
            return;
        }
        KtExpression scopeBlockExpression = ktExpression;
        KtCallExpression ktCallExpression = this.findCallExpressionFrom(scopeBlockExpression);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        KtBlockExpression ktBlockExpression = this.getFirstLambdaArgumentBody(callExpression2);
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression blockExpression2 = ktBlockExpression;
        PsiElement parent2 = expression2.getParent();
        KtExpression lastExpressionToMove = this.findLastExpressionToMove(receiverExpressionText, (KtExpression)expression2);
        TExpression firstTargetExpression = expression2 instanceof KtProperty ? expression2 : this.findFirstExpressionToMove(receiverExpressionText, (KtExpression)expression2);
        PsiElement psiElement2 = firstExpressionToMove = expression2 instanceof KtProperty ? ((KtProperty)expression2).getNextSibling() : (PsiElement)firstTargetExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"firstExpressionToMove");
        this.moveRangeInto(blockExpression2, psiElement2, (PsiElement)lastExpressionToMove, factory2);
        parent2.addBefore((PsiElement)scopeBlockExpression, (PsiElement)firstTargetExpression);
        parent2.deleteChildRange((PsiElement)firstTargetExpression, (PsiElement)lastExpressionToMove);
    }

    @Nullable
    protected final KtDotQualifiedExpression getDotQualifiedSiblingIfAny(@NotNull KtExpression $receiver, boolean forward) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiElement sibling = forward ? PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments((PsiElement)$receiver, false) : PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments((PsiElement)$receiver, false);
        PsiElement psiElement2 = sibling;
        if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
            psiElement2 = null;
        }
        return (KtDotQualifiedExpression)psiElement2;
    }

    private final KtBlockExpression getFirstLambdaArgumentBody(@NotNull KtCallExpression $receiver) {
        List<KtLambdaArgument> list2 = $receiver.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lambdaArguments");
        KtElement ktElement = (KtLambdaArgument)CollectionsKt.firstOrNull(list2);
        return ktElement != null && (ktElement = ((KtLambdaArgument)ktElement).getLambdaExpression()) != null ? ((KtLambdaExpression)ktElement).getBodyExpression() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void moveRangeInto(@NotNull KtBlockExpression $receiver, PsiElement firstElement, PsiElement lastElement, KtPsiFactory psiFactory) {
        void $receiver$iv;
        $receiver.addRange(firstElement, lastElement);
        Object[] objectArray = $receiver.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"children");
        Iterable iterable = ArraysKt.filterIsInstance((Object[])objectArray, KtDotQualifiedExpression.class);
        for (Object element$iv : $receiver$iv) {
            KtDotQualifiedExpression it = (KtDotQualifiedExpression)element$iv;
            KtExpression replaced = UtilsKt.deleteFirstReceiver(it);
            if (!this.isParameterScopeFunction()) continue;
            replaced.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, this.getScopeReceiverName() + ".$0", new Object[]{replaced}, false, 4, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(@NotNull KtCallExpression $receiver) {
        KtValueArgument ktValueArgument;
        if (!$receiver.getLambdaArguments().isEmpty()) return false;
        List<KtValueArgument> list2 = $receiver.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
        Iterable $receiver$iv = list2;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            KtValueArgument it;
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            ktValueArgument = it = (KtValueArgument)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgument, (String)"it");
        } while (Intrinsics.areEqual((Object)ktValueArgument.getText(), (Object)this.getScopeReceiverName()) ^ true);
        return false;
    }

    private final KtExpression findFirstExpressionToMove(String receiverExpressionText, KtExpression expression2) {
        return this.findBoundaryExpression(receiverExpressionText, expression2, false);
    }

    private final KtExpression findLastExpressionToMove(String receiverExpressionText, KtExpression expression2) {
        return this.findBoundaryExpression(receiverExpressionText, expression2, true);
    }

    private final KtExpression findBoundaryExpression(String receiverExpressionText, KtExpression expression2, boolean forward) {
        KtExpression targetExpression = expression2;
        KtDotQualifiedExpression dotQualifiedSibling;
        while ((dotQualifiedSibling = this.getDotQualifiedSiblingIfAny(targetExpression, forward)) != null && this.isApplicableWithGivenReceiverText(dotQualifiedSibling, receiverExpressionText)) {
            targetExpression = dotQualifiedSibling;
        }
        return targetExpression;
    }

    public ConvertToScopeIntention(@NotNull Class<TExpression> elementType, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        super(elementType, text2, null, 4, null);
    }
}

