/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.ConvertToScopeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertDotQualifiedToScopeIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "text", "", "(Ljava/lang/String;)V", "isParameterScopeFunction", "", "()Z", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "caretOffset", "", "idea"})
public abstract class ConvertDotQualifiedToScopeIntention
extends ConvertToScopeIntention<KtDotQualifiedExpression> {
    private final boolean isParameterScopeFunction = false;

    @Override
    public boolean isParameterScopeFunction() {
        return this.isParameterScopeFunction;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtDotQualifiedExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression receiverExpression = UtilsKt.getLeftMostReceiverExpression(element3);
        KtReference ktReference = ReferenceUtilKt.getMainReference(receiverExpression);
        if ((ktReference != null ? ktReference.resolve() : null) instanceof PsiClass) {
            return false;
        }
        String receiverExpressionText = receiverExpression.getText();
        if (Intrinsics.areEqual((Object)receiverExpressionText, (Object)this.getScopeReceiverName())) {
            return false;
        }
        String string = receiverExpressionText;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"receiverExpressionText");
        if (!this.isApplicableWithGivenReceiverText(element3, string)) {
            return false;
        }
        KtDotQualifiedExpression nextSibling = this.getDotQualifiedSiblingIfAny(element3, true);
        if (nextSibling != null && this.isApplicableWithGivenReceiverText(nextSibling, receiverExpressionText)) {
            return true;
        }
        KtDotQualifiedExpression prevSibling2 = this.getDotQualifiedSiblingIfAny(element3, false);
        return prevSibling2 != null && this.isApplicableWithGivenReceiverText(prevSibling2, receiverExpressionText);
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        String string = this.getReceiverExpressionText(element3);
        if (string == null) {
            return;
        }
        String receiverExpressionText = string;
        this.applyWithGivenReceiverText((KtExpression)element3, receiverExpressionText);
    }

    public ConvertDotQualifiedToScopeIntention(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        super(KtDotQualifiedExpression.class, text2);
    }
}

