/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.AddNameToArgumentIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddNamesToCallArgumentsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class AddNamesToCallArgumentsIntention
extends SelfTargetingRangeIntention<KtCallElement> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtCallElement element3) {
        boolean bl;
        block11: {
            boolean bl2;
            List<? extends ValueArgument> arguments2;
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                List<? extends ValueArgument> list2 = element3.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.valueArguments");
                arguments2 = list2;
                Iterable $receiver$iv = arguments2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ValueArgument it = (ValueArgument)element$iv;
                        if (it.isNamed() || it instanceof LambdaArgument) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return null;
            }
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(element3, null, 1, null);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            if (!resolvedCall3.getResultingDescriptor().hasStableParameterNames()) {
                return null;
            }
            Iterable $receiver$iv = arguments2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueArgument it;
                    ValueArgument valueArgument = it = (ValueArgument)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"it");
                    if (AddNameToArgumentIntention.Companion.argumentMatchedAndCouldBeNamedInCall(valueArgument, resolvedCall3, PlatformKt.getLanguageVersionSettings((PsiElement)element3))) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            KtExpression ktExpression = element3.getCalleeExpression();
            return ktExpression != null ? ktExpression.getTextRange() : null;
        }
        return null;
    }

    @Override
    public void applyTo(@NotNull KtCallElement element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        List<? extends ValueArgument> list2 = element3.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.valueArguments");
        List<? extends ValueArgument> arguments2 = list2;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(element3, null, 1, null);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        for (ValueArgument valueArgument : arguments2) {
            Name name2;
            ArgumentMatch argumentMatch;
            if (!(valueArgument instanceof KtValueArgument) || valueArgument instanceof KtLambdaArgument) continue;
            ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(valueArgument);
            if (!(argumentMapping instanceof ArgumentMatch)) {
                argumentMapping = null;
            }
            if ((ArgumentMatch)argumentMapping == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)argumentMatch.getValueParameter().getName(), (String)"argumentMatch.valueParameter.name");
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            KtExpression ktExpression = valueArgument.getArgumentExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtValueArgument newArgument = KtPsiFactory.createArgument$default(ktPsiFactory, ktExpression, name2, valueArgument.getSpreadElement() != null, false, 8, null);
            ((KtValueArgument)valueArgument).replace((PsiElement)newArgument);
        }
    }

    public AddNamesToCallArgumentsIntention() {
        super(KtCallElement.class, "Add names to call arguments", null, 4, null);
    }
}

