/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ChooseStringExpression;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddForLoopIndicesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "WITH_INDEX_FQ_NAMES", "", "", "WITH_INDEX_NAME", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "createWithIndexExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "originalExpression", "reformat", "", "runTemplate", "forExpression", "indexVariable", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "idea"})
public final class AddForLoopIndicesIntention
extends SelfTargetingRangeIntention<KtForExpression>
implements LowPriorityAction {
    private final String WITH_INDEX_NAME = "withIndex";
    private final Set<String> WITH_INDEX_FQ_NAMES = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])new String[]{"collections", "sequences", "text", "ranges"}), (Function1)((Function1)new Function1<String, String>(this){
        final /* synthetic */ AddForLoopIndicesIntention this$0;

        @NotNull
        public final String invoke(@NotNull String it) {
            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
            return "kotlin." + it + '.' + AddForLoopIndicesIntention.access$getWITH_INDEX_NAME$p(this.this$0);
        }
        {
            this.this$0 = addForLoopIndicesIntention;
            super(1);
        }
    })));

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtForExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3.getLoopParameter() == null) {
            return null;
        }
        KtParameter ktParameter = element3.getLoopParameter();
        if ((ktParameter != null ? ktParameter.getDestructuringDeclaration() : null) != null) {
            return null;
        }
        KtExpression ktExpression = element3.getLoopRange();
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.loopRange ?: return null");
        KtExpression loopRange = ktExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL_WITH_CFA);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(loopRange, bindingContext2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (CollectionsKt.contains((Iterable)this.WITH_INDEX_FQ_NAMES, resolvedCall3 != null && (resolvedCall3 = resolvedCall3.getResultingDescriptor()) != null && (resolvedCall3 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((Object)resolvedCall3))) != null ? ((FqNameUnsafe)((Object)resolvedCall3)).asString() : null)) {
            return null;
        }
        KtExpression potentialExpression = this.createWithIndexExpression(loopRange, false);
        BindingContext newBindingContext = AnalyzerUtilKt.analyzeAsReplacement$default(potentialExpression, loopRange, bindingContext2, null, null, null, 28, null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall(potentialExpression, newBindingContext);
        if (resolvedCall4 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> newResolvedCall = resolvedCall4;
        if (!this.WITH_INDEX_FQ_NAMES.contains(DescriptorUtilsKt.getFqNameUnsafe(newResolvedCall.getResultingDescriptor()).asString())) {
            return null;
        }
        KtExpression ktExpression2 = element3.getBody();
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)element3), ktExpression2 != null ? PsiUtilsKt.getStartOffset((PsiElement)ktExpression2) : PsiUtilsKt.getEndOffset((PsiElement)element3));
    }

    @Override
    public void applyTo(@NotNull KtForExpression element3, @Nullable Editor editor2) {
        KtDestructuringDeclaration ktDestructuringDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (editor2 == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor");
        }
        KtExpression ktExpression = element3.getLoopRange();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.loopRange!!");
        KtExpression loopRange = ktExpression;
        KtParameter ktParameter = element3.getLoopParameter();
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"element.loopParameter!!");
        KtParameter loopParameter = ktParameter;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        loopRange.replace((PsiElement)this.createWithIndexExpression(loopRange, true));
        Object[] objectArray = new Object[1];
        String string = loopParameter.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loopParameter.text");
        objectArray[0] = string;
        KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "for((index, $0) in x){}", objectArray, false, 4, null);
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
        }
        KtDestructuringDeclaration ktDestructuringDeclaration2 = ((KtForExpression)ktExpression2).getDestructuringDeclaration();
        if (ktDestructuringDeclaration2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclaration2, (String)"(psiFactory.createExpres\u2026estructuringDeclaration!!");
        KtDestructuringDeclaration multiParameter = ktDestructuringDeclaration2;
        PsiElement $receiver$iv = loopParameter;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)multiParameter);
        PsiElement psiElement2 = result$iv;
        if (!(psiElement2 instanceof KtDestructuringDeclaration)) {
            psiElement2 = null;
        }
        if ((ktDestructuringDeclaration = (KtDestructuringDeclaration)psiElement2) == null) {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDestructuringDeclaration");
            }
            ktDestructuringDeclaration = (KtDestructuringDeclaration)ktExpression3;
        }
        multiParameter = ktDestructuringDeclaration;
        KtDestructuringDeclarationEntry indexVariable = multiParameter.getEntries().get(0);
        CaretModel caretModel = editor2.getCaretModel();
        KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = indexVariable;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"indexVariable");
        caretModel.moveToOffset(PsiUtilsKt.getStartOffset(ktDestructuringDeclarationEntry));
        this.runTemplate(editor2, element3, indexVariable);
    }

    private final void runTemplate(Editor editor2, KtForExpression forExpression, KtDestructuringDeclarationEntry indexVariable) {
        KtExpression body2;
        PsiDocumentManager.getInstance((Project)forExpression.getProject()).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)forExpression);
        templateBuilder.replaceElement((PsiElement)indexVariable, (Expression)new ChooseStringExpression((Collection)CollectionsKt.listOf((Object[])new String[]{"index", "i"}), null, null, 6, null));
        KtExpression ktExpression = body2 = forExpression.getBody();
        if (ktExpression instanceof KtBlockExpression) {
            List<KtExpression> list2 = ((KtBlockExpression)body2).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"body.statements");
            KtExpression statement2 = (KtExpression)CollectionsKt.firstOrNull(list2);
            if (statement2 != null) {
                templateBuilder.setEndVariableBefore((PsiElement)statement2);
            } else {
                templateBuilder.setEndVariableAfter(((KtBlockExpression)body2).getLBrace());
            }
        } else if (ktExpression == null) {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = forExpression.getRightParenthesis();
            templateBuilder.setEndVariableAfter(it);
        } else {
            templateBuilder.setEndVariableBefore((PsiElement)body2);
        }
        templateBuilder.run(editor2, true);
    }

    private final KtExpression createWithIndexExpression(KtExpression originalExpression, boolean reformat) {
        Object[] objectArray = new Object[]{originalExpression};
        boolean bl = reformat;
        return CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)originalExpression, false, 2, null), "$0." + this.WITH_INDEX_NAME + "()", objectArray, bl);
    }

    public AddForLoopIndicesIntention() {
        super(KtForExpression.class, "Add indices to 'for' loop", null, 4, null);
    }

    public static final /* synthetic */ String access$getWITH_INDEX_NAME$p(AddForLoopIndicesIntention $this) {
        return $this.WITH_INDEX_NAME;
    }
}

