/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspectionKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0006H\u0002\u001a$\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"deleteFalseEntries", "", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "usedAsExpression", "", "isFalseConstantCondition", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "isTrueConstantCondition", "replaceTrueEntry", "closeBrace", "Lcom/intellij/psi/PsiElement;", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "idea"})
public final class SimplifyWhenWithBooleanConstantConditionInspectionKt {
    private static final void deleteFalseEntries(@NotNull KtWhenExpression $receiver, boolean usedAsExpression) {
        block4: {
            List<KtWhenEntry> entries2;
            Object object;
            block3: {
                object = $receiver.getEntries().iterator();
                while (object.hasNext()) {
                    KtWhenEntry entry;
                    KtWhenEntry ktWhenEntry = entry = object.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
                    if (!SimplifyWhenWithBooleanConstantConditionInspectionKt.isFalseConstantCondition(ktWhenEntry)) continue;
                    entry.delete();
                }
                List<KtWhenEntry> list2 = $receiver.getEntries();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"entries");
                entries2 = list2;
                if (!entries2.isEmpty() || usedAsExpression) break block3;
                $receiver.delete();
                break block4;
            }
            KtWhenEntry ktWhenEntry = (KtWhenEntry)CollectionsKt.singleOrNull(entries2);
            if (ktWhenEntry == null) break block4;
            if (ktWhenEntry.isElse()) {
                KtExpression ktExpression = $receiver.getElseExpression();
                if (ktExpression != null) {
                    Object it = object = ktExpression;
                    KtExpression ktExpression2 = $receiver;
                    Object object2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                    ConstantConditionIfInspectionKt.replaceWithBranch$default(ktExpression2, (KtExpression)object2, usedAsExpression, false, 4, null);
                }
            }
        }
    }

    private static final void replaceTrueEntry(@NotNull KtWhenExpression $receiver, boolean usedAsExpression, PsiElement closeBrace, KtPsiFactory factory2) {
        int trueIndex;
        List<KtWhenEntry> entries2;
        block7: {
            int n;
            List<KtWhenEntry> list2 = $receiver.getEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"entries");
            List<KtWhenEntry> $receiver$iv = entries2 = list2;
            int index$iv = 0;
            Iterator<KtWhenEntry> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                KtWhenEntry item$iv;
                KtWhenEntry it;
                KtWhenEntry ktWhenEntry = it = (item$iv = iterator2.next());
                Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"it");
                if (SimplifyWhenWithBooleanConstantConditionInspectionKt.isTrueConstantCondition(ktWhenEntry)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = trueIndex = -1;
        }
        if (trueIndex == -1) {
            return;
        }
        KtWhenEntry ktWhenEntry = entries2.get(trueIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entries[trueIndex]");
        KtExpression ktExpression = ktWhenEntry.getExpression();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"entries[trueIndex].expression ?: return");
        KtExpression expression2 = ktExpression;
        if (trueIndex == 0) {
            ConstantConditionIfInspectionKt.replaceWithBranch$default($receiver, expression2, usedAsExpression, false, 4, null);
        } else {
            KtWhenEntry elseEntry = factory2.createWhenEntry("else -> " + expression2.getText());
            for (KtWhenEntry entry : entries2.subList(trueIndex, entries2.size())) {
                entry.delete();
            }
            $receiver.addBefore((PsiElement)elseEntry, closeBrace);
        }
    }

    private static final boolean isTrueConstantCondition(@NotNull KtWhenEntry $receiver) {
        Object[] objectArray = $receiver.getConditions();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"conditions");
        Object object = ArraysKt.singleOrNull((Object[])objectArray);
        if (!(object instanceof KtWhenConditionWithExpression)) {
            object = null;
        }
        KtWhenConditionWithExpression ktWhenConditionWithExpression = (KtWhenConditionWithExpression)object;
        return CommonUtilsKt.isTrueConstant(ktWhenConditionWithExpression != null ? ktWhenConditionWithExpression.getExpression() : null);
    }

    private static final boolean isFalseConstantCondition(@NotNull KtWhenEntry $receiver) {
        Object[] objectArray = $receiver.getConditions();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"conditions");
        Object object = ArraysKt.singleOrNull((Object[])objectArray);
        if (!(object instanceof KtWhenConditionWithExpression)) {
            object = null;
        }
        KtWhenConditionWithExpression ktWhenConditionWithExpression = (KtWhenConditionWithExpression)object;
        return CommonUtilsKt.isFalseConstant(ktWhenConditionWithExpression != null ? ktWhenConditionWithExpression.getExpression() : null);
    }

    public static final /* synthetic */ boolean access$isTrueConstantCondition(KtWhenEntry $receiver) {
        return SimplifyWhenWithBooleanConstantConditionInspectionKt.isTrueConstantCondition($receiver);
    }

    public static final /* synthetic */ boolean access$isFalseConstantCondition(KtWhenEntry $receiver) {
        return SimplifyWhenWithBooleanConstantConditionInspectionKt.isFalseConstantCondition($receiver);
    }

    public static final /* synthetic */ void access$deleteFalseEntries(KtWhenExpression $receiver, boolean usedAsExpression) {
        SimplifyWhenWithBooleanConstantConditionInspectionKt.deleteFalseEntries($receiver, usedAsExpression);
    }

    public static final /* synthetic */ void access$replaceTrueEntry(KtWhenExpression $receiver, boolean usedAsExpression, PsiElement closeBrace, KtPsiFactory factory2) {
        SimplifyWhenWithBooleanConstantConditionInspectionKt.replaceTrueEntry($receiver, usedAsExpression, closeBrace, factory2);
    }
}

