/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinVariableInplaceRenameHandler;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"counterpartNames", "", "", "getCounterpart", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "nameResolvesToStdlib", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "name", "startInPlaceRename", "", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class ScopeFunctionConversionInspectionKt {
    private static final Map<String, String> counterpartNames = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"apply", (Object)"also"), TuplesKt.to((Object)"run", (Object)"let"), TuplesKt.to((Object)"also", (Object)"apply"), TuplesKt.to((Object)"let", (Object)"run")});

    private static final String getCounterpart(KtCallExpression expression2) {
        KtLambdaExpression lambdaExpression2;
        KtExpression ktExpression = expression2.getCalleeExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (ktNameReferenceExpression == null) {
            return null;
        }
        KtNameReferenceExpression callee = ktNameReferenceExpression;
        String calleeName = callee.getReferencedName();
        String counterpartName = counterpartNames.get(calleeName);
        List<KtLambdaArgument> list2 = expression2.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull(list2);
        KtLambdaExpression ktLambdaExpression = lambdaExpression2 = ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
        if (counterpartName != null && lambdaExpression2 != null) {
            List<KtParameter> list3 = lambdaExpression2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"lambdaExpression.valueParameters");
            Collection collection = list3;
            if (!collection.isEmpty()) {
                return null;
            }
            BindingContext bindingContext2 = ResolutionUtils.analyze(callee, BodyResolveMode.PARTIAL);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callee, bindingContext2);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor()).asString(), (Object)("kotlin." + calleeName)) && ScopeFunctionConversionInspectionKt.nameResolvesToStdlib(expression2, bindingContext2, counterpartName)) {
                return counterpartName;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean nameResolvesToStdlib(KtCallExpression expression2, BindingContext bindingContext2, String name2) {
        Object element$iv;
        DeclarationDescriptor it;
        Collection descriptors2;
        LexicalScope lexicalScope = ScopeUtils.getResolutionScope((PsiElement)expression2, bindingContext2);
        if (lexicalScope == null) return true;
        LexicalScope scope2 = lexicalScope;
        Collection collection = descriptors2 = ScopeUtilsKt.collectDescriptorsFiltered$default(scope2, null, (Function1)new Function1<Name, Boolean>(name2){
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull Name it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.asString(), (Object)this.$name);
            }
            {
                this.$name = string;
                super(1);
            }
        }, false, 5, null);
        if (collection.isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $receiver$iv = descriptors2;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(it = (DeclarationDescriptor)(element$iv = iterator2.next())).asString(), (Object)("kotlin." + name2)));
        return false;
    }

    private static final void startInPlaceRename(@NotNull PsiElement $receiver) {
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Project project2 = project;
        PsiFile psiFile = $receiver.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"containingFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"containingFile.viewProvider.document ?: return");
        Document document2 = document;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        Editor editor2 = fileEditorManager.getSelectedTextEditor();
        if (editor2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"FileEditorManager.getIns\u2026ectedTextEditor ?: return");
        Editor editor3 = editor2;
        if (Intrinsics.areEqual((Object)editor3.getDocument(), (Object)document2)) {
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor3.getDocument());
            editor3.getCaretModel().moveToOffset(PsiUtilsKt.getStartOffset($receiver));
            new KotlinVariableInplaceRenameHandler().doRename($receiver, editor3, null);
        }
    }

    public static final /* synthetic */ String access$getCounterpart(KtCallExpression expression2) {
        return ScopeFunctionConversionInspectionKt.getCounterpart(expression2);
    }

    public static final /* synthetic */ void access$startInPlaceRename(PsiElement $receiver) {
        ScopeFunctionConversionInspectionKt.startInPlaceRename($receiver);
    }
}

