/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithStdLibFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "methodName", "", "receiver", "(Ljava/lang/String;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
final class ReplaceWithStdLibFix
implements LocalQuickFix {
    private final String methodName;
    private final String receiver;

    @NotNull
    public String getName() {
        return "Replace with " + this.receiver + '.' + this.methodName;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
            psiElement2 = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
        if (ktDotQualifiedExpression == null) {
            return;
        }
        KtDotQualifiedExpression expression2 = ktDotQualifiedExpression;
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(expression2);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        List<KtValueArgument> list2 = callExpression2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callExpression.valueArguments");
        List<KtValueArgument> valueArguments = list2;
        KtElement ktElement = (KtValueArgument)CollectionsKt.getOrNull(valueArguments, (int)0);
        if (ktElement == null || (ktElement = ktElement.getArgumentExpression()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"valueArguments.getOrNull\u2026entExpression() ?: return");
        KtElement firstArg = ktElement;
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull(valueArguments, (int)1);
        KtExpression secondArg = ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        if (secondArg != null) {
            if (Intrinsics.areEqual((Object)this.methodName, (Object)"sort")) {
                Object[] objectArray = new Object[2];
                objectArray[0] = firstArg;
                String string = secondArg.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"secondArg.text");
                objectArray[1] = string;
                ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "$0.sortWith(Comparator $1)", objectArray, false, 4, null);
            } else {
                ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "$0." + this.methodName + "($1)", new Object[]{firstArg, secondArg}, false, 4, null);
            }
        } else {
            ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "$0." + this.methodName + "()", new Object[]{firstArg}, false, 4, null);
        }
        KtExpression newExpression2 = ktExpression;
        expression2.replace((PsiElement)newExpression2);
    }

    public ReplaceWithStdLibFix(@NotNull String methodName, @NotNull String receiver) {
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        this.methodName = methodName;
        this.receiver = receiver;
    }
}

