/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.dependencies.ScriptReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.highlighter.ScriptExternalHighlightingPass$WhenMappings;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0019B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\n*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "computeOffsets", "Lkotlin/Pair;", "", "position", "Lkotlin/script/experimental/dependencies/ScriptReport$Position;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "coerceLineIn", "convertSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Lkotlin/script/experimental/dependencies/ScriptReport$Severity;", "offsetBy", "line", "col", "Factory", "idea-core"})
public final class ScriptExternalHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private final KtFile file;

    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkParameterIsNotNull((Object)progress2, (String)"progress");
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        void $receiver$iv$iv;
        Object element$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"document ?: return");
        Document document2 = document;
        List list2 = (List)this.file.getVirtualFile().getUserData((Key)IdeScriptReportSink.Reports.INSTANCE);
        if (list2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"file.virtualFile.getUser\u2026rtSink.Reports) ?: return");
        List reports = list2;
        Iterable iterable = $receiver$iv = (Iterable)reports;
        Iterable<Annotation> destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv2;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Annotation annotation2;
            Annotation annotation3;
            Pair<Integer, Integer> pair2;
            ScriptReport.Severity severity;
            String message2;
            block11: {
                block10: {
                    Pair<Integer, Integer> pair3;
                    Object element$iv$iv$iv;
                    element$iv$iv = element$iv$iv$iv = iterator2.next();
                    ScriptReport $message_severity_position = (ScriptReport)element$iv$iv;
                    message2 = $message_severity_position.component1();
                    severity = $message_severity_position.component2();
                    Pair<Integer, Integer> position = $message_severity_position.component3();
                    pair2 = position;
                    if (pair2 == null) break block10;
                    Pair<Integer, Integer> it = pair3 = pair2;
                    pair2 = this.computeOffsets(document2, (ScriptReport.Position)position);
                    if (pair2 != null) break block11;
                }
                pair2 = TuplesKt.to((Object)0, (Object)0);
            }
            Pair<Integer, Integer> pair4 = pair2;
            int n = ((Number)pair4.component1()).intValue();
            int endOffset = ((Number)pair4.component2()).intValue();
            if (this.convertSeverity(severity) == null) {
                Annotation annotation4;
                annotation3 = annotation4 = null;
            } else {
                void startOffset;
                HighlightSeverity highlightSeverity;
                int n2;
                void var36_26;
                String string = message2;
                String string2 = message2;
                Annotation annotation5 = new Annotation((int)var36_26, n2, highlightSeverity, string2, string);
                annotation5.setFileLevelAnnotation(startOffset == endOffset);
                annotation3 = annotation5;
            }
            if (annotation3 == null) continue;
            Annotation it$iv$iv = annotation2 = annotation3;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotations2 = (List)destination$iv$iv;
        Iterable $receiver$iv2 = annotations2;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            element$iv$iv = (Annotation)item$iv$iv;
            Collection collection = destination$iv$iv2;
            HighlightInfo highlightInfo = HighlightInfo.fromAnnotation((Annotation)it);
            collection.add(highlightInfo);
        }
        List infos2 = (List)destination$iv$iv2;
        Document document3 = this.myDocument;
        if (document3 == null) {
            Intrinsics.throwNpe();
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)document3, (int)0, (int)this.file.getTextLength(), (Collection)infos2, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private final Pair<Integer, Integer> computeOffsets(Document document, ScriptReport.Position position) {
        int startLine = this.coerceLineIn(position.getStartLine(), document);
        int startOffset = this.offsetBy(document, startLine, position.getStartColumn());
        Integer n = position.getEndLine();
        int endLine = n != null ? this.coerceLineIn(RangesKt.coerceAtLeast((int)n, (int)startLine), document) : startLine;
        Integer n2 = position.getEndColumn();
        int endOffset = RangesKt.coerceAtLeast((int)this.offsetBy(document, endLine, n2 != null ? n2.intValue() : document.getLineEndOffset(endLine)), (int)startOffset);
        return TuplesKt.to((Object)startOffset, (Object)endOffset);
    }

    private final int coerceLineIn(int $receiver, Document document) {
        return RangesKt.coerceIn((int)$receiver, (int)0, (int)(document.getLineCount() - 1));
    }

    private final int offsetBy(@NotNull Document $receiver, int line, int col) {
        return RangesKt.coerceIn((int)($receiver.getLineStartOffset(line) + col), (int)$receiver.getLineStartOffset(line), (int)$receiver.getLineEndOffset(line));
    }

    private final HighlightSeverity convertSeverity(@NotNull ScriptReport.Severity $receiver) {
        HighlightSeverity highlightSeverity;
        switch (ScriptExternalHighlightingPass$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                highlightSeverity = HighlightSeverity.ERROR;
                break;
            }
            case 2: {
                highlightSeverity = HighlightSeverity.ERROR;
                break;
            }
            case 3: {
                highlightSeverity = HighlightSeverity.WARNING;
                break;
            }
            case 4: {
                highlightSeverity = HighlightSeverity.INFORMATION;
                break;
            }
            case 5: {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) {
                    highlightSeverity = HighlightSeverity.INFORMATION;
                    break;
                }
                highlightSeverity = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return highlightSeverity;
    }

    public ScriptExternalHighlightingPass(@NotNull KtFile file, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        super(file.getProject(), document);
        this.file = file;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass$Factory;", "Lcom/intellij/openapi/components/ProjectComponent;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "(Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea-core"})
    public static final class Factory
    implements ProjectComponent,
    TextEditorHighlightingPassFactory {
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor2) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
            if (!(file instanceof KtFile)) {
                return null;
            }
            KtFile ktFile = (KtFile)file;
            Document document = editor2.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
            return new ScriptExternalHighlightingPass(ktFile, document);
        }

        public Factory(@NotNull TextEditorHighlightingPassRegistrar registrar) {
            Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 1, false, false);
        }
    }
}

