/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportUtils;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportWrapper;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/OutsidersPsiFileSupportUtils;", "", "()V", "getOutsiderFileOrigin", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "idea-core"})
public final class OutsidersPsiFileSupportUtils {
    public static final OutsidersPsiFileSupportUtils INSTANCE;

    @Nullable
    public final VirtualFile getOutsiderFileOrigin(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        if (!OutsidersPsiFileSupportWrapper.INSTANCE.isOutsiderFile(virtualFile)) {
            return null;
        }
        String string = OutsidersPsiFileSupportWrapper.INSTANCE.getOriginalFilePath(virtualFile);
        if (string == null) {
            return null;
        }
        String originalFilePath = string;
        File file = (File)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence((Object)new File(originalFilePath), (Function1)((Function1)new Function1<File, File>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final File invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = it.getCanonicalPath();
                VirtualFile virtualFile = this.$project.getBaseDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"project.baseDir");
                return Intrinsics.areEqual((Object)string, (Object)virtualFile.getCanonicalPath()) ? null : it.getParentFile();
            }
            {
                this.$project = project;
                super(1);
            }
        })), (Function1)getOutsiderFileOrigin.2.INSTANCE));
        if (file != null) {
            File file2;
            File it = file2 = file;
            virtualFile2 = VfsUtil.findFileByIoFile((File)it, (boolean)false);
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    private OutsidersPsiFileSupportUtils() {
    }

    static {
        OutsidersPsiFileSupportUtils outsidersPsiFileSupportUtils;
        INSTANCE = outsidersPsiFileSupportUtils = new OutsidersPsiFileSupportUtils();
    }
}

