/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinRainbowVisitor;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinTargetElementEvaluator;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\n\u001a\u00020\u0000H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\f\u0010\u0011\u001a\u00020\f*\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "()V", "addRainbowHighlight", "", "target", "Lcom/intellij/psi/PsiElement;", "rainbowElement", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "clone", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "visit", "element", "isRainbowDeclaration", "Companion", "idea"})
public final class KotlinRainbowVisitor
extends RainbowVisitor {
    @NotNull
    private static final KotlinTargetElementEvaluator KOTLIN_TARGET_ELEMENT_EVALUATOR;
    public static final Companion Companion;

    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file instanceof KtFile;
    }

    @NotNull
    public KotlinRainbowVisitor clone() {
        return new KotlinRainbowVisitor();
    }

    public void visit(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (this.isRainbowDeclaration(element3)) {
            PsiElement psiElement2 = ((KtNamedDeclaration)element3).getNameIdentifier();
            if (psiElement2 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"(element as KtNamedDecla\u2026.nameIdentifier ?: return");
            PsiElement rainbowElement = psiElement2;
            KotlinRainbowVisitor.addRainbowHighlight$default(this, element3, rainbowElement, null, 4, null);
        } else if (element3 instanceof KtSimpleNameExpression) {
            PsiElement itTargetElement;
            KtSimpleNameReference reference2;
            PsiElement targetElement;
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)element3, KtQualifiedExpression.class, (boolean)true, (Class[])new Class[]{KtLambdaExpression.class, KtValueArgumentList.class});
            KtExpression ktExpression = qualifiedExpression;
            if (ktExpression != null && (ktExpression = ktExpression.getSelectorExpression()) != null) {
                if (PsiUtilsKt.isAncestor$default((PsiElement)ktExpression, element3, false, 2, null)) {
                    return;
                }
            }
            if ((targetElement = (reference2 = ReferenceUtilKt.getMainReference((KtSimpleNameExpression)element3)).resolve()) != null) {
                if (this.isRainbowDeclaration(targetElement)) {
                    KotlinRainbowVisitor.addRainbowHighlight$default(this, targetElement, element3, null, 4, null);
                }
            } else if (Intrinsics.areEqual((Object)((KtSimpleNameExpression)element3).getReferencedName(), (Object)"it") && (itTargetElement = KOTLIN_TARGET_ELEMENT_EVALUATOR.getElementByReference((PsiReference)reference2, 1)) != null) {
                KotlinRainbowVisitor.addRainbowHighlight$default(this, itTargetElement, element3, null, 4, null);
            }
        } else if (element3 instanceof KDocName) {
            PsiReference psiReference = ((KDocName)element3).getReference();
            if (psiReference == null || (psiReference = psiReference.resolve()) == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"element.reference?.resolve() ?: return");
            PsiReference target = psiReference;
            if (this.isRainbowDeclaration((PsiElement)target)) {
                this.addRainbowHighlight((PsiElement)target, element3, KotlinHighlightingColors.KDOC_LINK);
            }
        }
    }

    private final void addRainbowHighlight(PsiElement target, PsiElement rainbowElement, TextAttributesKey attributesKey) {
        KtDeclaration ktDeclaration;
        TextAttributesKey attributesKeyToUse;
        Iterator lambdaSequenceIterator2 = SequencesKt.filter((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParents(target), (Function1)addRainbowHighlight.lambdaSequenceIterator.1.INSTANCE), (Function1)addRainbowHighlight.lambdaSequenceIterator.2.INSTANCE).iterator();
        TextAttributesKey textAttributesKey = attributesKey;
        if (textAttributesKey == null) {
            textAttributesKey = attributesKeyToUse = target instanceof KtParameter ? KotlinHighlightingColors.PARAMETER : KotlinHighlightingColors.LOCAL_VARIABLE;
        }
        if (lambdaSequenceIterator2.hasNext()) {
            PsiElement lambda2 = (PsiElement)lambdaSequenceIterator2.next();
            int lambdaNestingLevel = 0;
            while (lambdaSequenceIterator2.hasNext()) {
                ++lambdaNestingLevel;
                lambda2 = (PsiElement)lambdaSequenceIterator2.next();
            }
            this.addInfo(this.getInfo(lambda2, rainbowElement, lambdaNestingLevel + rainbowElement.getText(), attributesKeyToUse));
            return;
        }
        PsiElement $receiver$iv = target;
        KtDeclarationWithBody ktDeclarationWithBody = (KtDeclarationWithBody)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclarationWithBody.class, (boolean)true);
        if (ktDeclarationWithBody != null) {
            ktDeclaration = ktDeclarationWithBody;
        } else {
            $receiver$iv = target;
            ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtAnonymousInitializer.class, (boolean)true);
        }
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration context = ktDeclaration;
        this.addInfo(this.getInfo(context, rainbowElement, rainbowElement.getText(), attributesKeyToUse));
    }

    static /* synthetic */ void addRainbowHighlight$default(KotlinRainbowVisitor kotlinRainbowVisitor, PsiElement psiElement2, PsiElement psiElement3, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 4) != 0) {
            textAttributesKey = null;
        }
        kotlinRainbowVisitor.addRainbowHighlight(psiElement2, psiElement3, textAttributesKey);
    }

    private final boolean isRainbowDeclaration(@NotNull PsiElement $receiver) {
        PsiElement $receiver$iv;
        return $receiver instanceof KtProperty && ((KtProperty)$receiver).isLocal() || $receiver instanceof KtParameter && PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = $receiver), KtPrimaryConstructor.class, (boolean)true) == null || $receiver instanceof KtDestructuringDeclarationEntry;
    }

    static {
        Companion = new Companion(null);
        KOTLIN_TARGET_ELEMENT_EVALUATOR = new KotlinTargetElementEvaluator();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRainbowVisitor$Companion;", "", "()V", "KOTLIN_TARGET_ELEMENT_EVALUATOR", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinTargetElementEvaluator;", "getKOTLIN_TARGET_ELEMENT_EVALUATOR", "()Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinTargetElementEvaluator;", "idea"})
    public static final class Companion {
        @NotNull
        public final KotlinTargetElementEvaluator getKOTLIN_TARGET_ELEMENT_EVALUATOR() {
            return KOTLIN_TARGET_ELEMENT_EVALUATOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

