/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.AsyncDependenciesResolver;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesCache;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdater;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdaterKt;
import org.jetbrains.kotlin.idea.core.script.dependencies.AsyncScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.FromFileAttributeScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.SyncScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProviderKt;
import org.jetbrains.kotlin.script.LegacyResolverWrapper;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;)V", "asyncLoader", "Lorg/jetbrains/kotlin/idea/core/script/dependencies/AsyncScriptDependenciesLoader;", "fileAttributeLoader", "Lorg/jetbrains/kotlin/idea/core/script/dependencies/FromFileAttributeScriptDependenciesLoader;", "scriptChangesListenerDelay", "", "scriptsQueue", "Lcom/intellij/util/Alarm;", "syncLoader", "Lorg/jetbrains/kotlin/idea/core/script/dependencies/SyncScriptDependenciesLoader;", "getCurrentDependencies", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "listenForChangesInScripts", "", "updateDependencies", "scriptDef", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "idea-core"})
public final class ScriptDependenciesUpdater {
    private final Alarm scriptsQueue;
    private final int scriptChangesListenerDelay = 1400;
    private final AsyncScriptDependenciesLoader asyncLoader;
    private final SyncScriptDependenciesLoader syncLoader;
    private final FromFileAttributeScriptDependenciesLoader fileAttributeLoader;
    private final Project project;
    private final ScriptDependenciesCache cache;

    @NotNull
    public final ScriptDependencies getCurrentDependencies(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ScriptDependencies scriptDependencies2 = this.cache.get(file);
        if (scriptDependencies2 != null) {
            ScriptDependencies scriptDependencies3;
            ScriptDependencies it = scriptDependencies3 = scriptDependencies2;
            return it;
        }
        KotlinScriptDefinition kotlinScriptDefinition = KotlinScriptDefinitionProviderKt.findScriptDefinition(file, this.project);
        if (kotlinScriptDefinition == null) {
            return ScriptDependencies.Companion.getEmpty();
        }
        KotlinScriptDefinition scriptDef = kotlinScriptDefinition;
        this.fileAttributeLoader.updateDependencies(file, scriptDef);
        this.updateDependencies(file, scriptDef);
        ScriptDependencies scriptDependencies4 = this.cache.get(file);
        if (scriptDependencies4 == null) {
            scriptDependencies4 = ScriptDependencies.Companion.getEmpty();
        }
        return scriptDependencies4;
    }

    private final void updateDependencies(VirtualFile file, KotlinScriptDefinition scriptDef) {
        DependenciesResolver dependenciesResolver = scriptDef.getDependencyResolver();
        ScriptDependenciesLoader loader = dependenciesResolver instanceof AsyncDependenciesResolver || dependenciesResolver instanceof LegacyResolverWrapper ? (ScriptDependenciesLoader)this.asyncLoader : (ScriptDependenciesLoader)this.syncLoader;
        loader.updateDependencies(file, scriptDef);
    }

    private final void listenForChangesInScripts() {
        this.project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ ScriptDependenciesUpdater this$0;

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.runScriptDependenciesUpdateIfNeeded(file);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                block0: {
                    VirtualFile virtualFile;
                    VirtualFile it;
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    VirtualFile virtualFile2 = event.getNewFile();
                    if (virtualFile2 == null) break block0;
                    VirtualFile virtualFile3 = it = (virtualFile = virtualFile2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"it");
                    this.runScriptDependenciesUpdateIfNeeded(virtualFile3);
                }
            }

            private final void runScriptDependenciesUpdateIfNeeded(VirtualFile file) {
                Object object;
                if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)KotlinFileType.INSTANCE)) ^ true || !file.isValid()) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)ScriptDependenciesUpdater.access$getProject$p(this.this$0)).findFile(file);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                KtFile ktFile = (KtFile)psiFile;
                if (ktFile == null) {
                    return;
                }
                KtFile ktFile2 = ktFile;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    Application application2 = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
                    if (Intrinsics.areEqual((Object)ScriptDependenciesUpdaterKt.isScriptDependenciesUpdaterDisabled(application2), (Object)true)) {
                        return;
                    }
                }
                if ((object = ktFile2.getScript()) == null || (object = object.getKotlinScriptDefinition()) == null) {
                    return;
                }
                Object scriptDef = object;
                if (!ProjectRootsUtil.isInProjectSource((PsiElement)ktFile2, true)) {
                    return;
                }
                ScriptDependenciesUpdater.access$updateDependencies(this.this$0, file, (KotlinScriptDefinition)((Object)scriptDef));
            }
            {
                this.this$0 = $outer;
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ ScriptDependenciesUpdater this$0;

            public void documentChanged(@NotNull DocumentEvent event) {
                Object object;
                Document document;
                block13: {
                    block12: {
                        VirtualFile virtualFile;
                        VirtualFile it;
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        if (ScriptDependenciesUpdater.access$getProject$p(this.this$0).isDisposed()) {
                            return;
                        }
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                        if (application.isUnitTestMode()) {
                            Application application2 = ApplicationManager.getApplication();
                            Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
                            if (Intrinsics.areEqual((Object)ScriptDependenciesUpdaterKt.isScriptDependenciesUpdaterDisabled(application2), (Object)true)) {
                                return;
                            }
                        }
                        Document document2 = event.getDocument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"event.document");
                        document = document2;
                        object = FileDocumentManager.getInstance().getFile(document);
                        if (object == null) break block12;
                        VirtualFile virtualFile2 = it = (virtualFile = object);
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it");
                        object = virtualFile2.isInLocalFileSystem() ? virtualFile : null;
                        if (object != null) break block13;
                    }
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"FileDocumentManager.getI\u2026calFileSystem } ?: return");
                VirtualFile file = object;
                if (!file.isValid()) {
                    ScriptDependenciesUpdater.access$getCache$p(this.this$0).delete(file);
                    return;
                }
                if (ScriptDependenciesUpdater.access$getCache$p(this.this$0).get(file) == null) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)ScriptDependenciesUpdater.access$getProject$p(this.this$0)).findFile(file);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                KtFile ktFile = (KtFile)psiFile;
                if (ktFile == null) {
                    return;
                }
                KtFile ktFile2 = ktFile;
                Object object2 = ktFile2.getScript();
                if (object2 == null || (object2 = object2.getKotlinScriptDefinition()) == null) {
                    return;
                }
                Object scriptDef = object2;
                if (!ProjectRootsUtil.isInProjectSource((PsiElement)ktFile2, true)) {
                    return;
                }
                ScriptDependenciesUpdater.access$getScriptsQueue$p(this.this$0).cancelAllRequests();
                ScriptDependenciesUpdater.access$getScriptsQueue$p(this.this$0).addRequest(new Runnable(this, document, file, (KotlinScriptDefinition)((Object)scriptDef)){
                    final /* synthetic */ listenForChangesInScripts.2 this$0;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ KotlinScriptDefinition $scriptDef;

                    public final void run() {
                        FileDocumentManager.getInstance().saveDocument(this.$document);
                        ScriptDependenciesUpdater.access$updateDependencies(this.this$0.this$0, this.$file, this.$scriptDef);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$document = document;
                        this.$file = virtualFile;
                        this.$scriptDef = kotlinScriptDefinition;
                    }
                }, ScriptDependenciesUpdater.access$getScriptChangesListenerDelay$p(this.this$0), true);
            }
            {
                this.this$0 = $outer;
            }
        }, (Disposable)this.project.getMessageBus().connect());
    }

    public ScriptDependenciesUpdater(@NotNull Project project, @NotNull ScriptDependenciesCache cache2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)cache2, (String)"cache");
        this.project = project;
        this.cache = cache2;
        this.scriptsQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.project);
        this.scriptChangesListenerDelay = 1400;
        this.asyncLoader = new AsyncScriptDependenciesLoader(this.project);
        this.syncLoader = new SyncScriptDependenciesLoader(this.project);
        this.fileAttributeLoader = new FromFileAttributeScriptDependenciesLoader(this.project);
        this.listenForChangesInScripts();
    }

    public static final /* synthetic */ Project access$getProject$p(ScriptDependenciesUpdater $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$updateDependencies(ScriptDependenciesUpdater $this, VirtualFile file, KotlinScriptDefinition scriptDef) {
        $this.updateDependencies(file, scriptDef);
    }

    public static final /* synthetic */ ScriptDependenciesCache access$getCache$p(ScriptDependenciesUpdater $this) {
        return $this.cache;
    }

    public static final /* synthetic */ Alarm access$getScriptsQueue$p(ScriptDependenciesUpdater $this) {
        return $this.scriptsQueue;
    }

    public static final /* synthetic */ int access$getScriptChangesListenerDelay$p(ScriptDependenciesUpdater $this) {
        return $this.scriptChangesListenerDelay;
    }
}

