/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.util.VersioningKt;

public class ConfigurePluginUpdatesForm {
    public JComboBox<String> channelCombo;
    public JButton reCheckButton;
    public JPanel mainPanel;
    public AsyncProcessIcon updateCheckProgressIcon;
    public JLabel updateStatusLabel;
    public JButton installButton;
    public JLabel installStatusLabel;
    private JLabel verifierDisabledText;
    private JTextPane currentVersion;
    private JPanel bundledCompilerVersionPanel;
    private JTextPane compilerVersion;

    public ConfigurePluginUpdatesForm() {
        this.$$$setupUI$$$();
        this.showVerifierDisabledStatus();
        this.currentVersion.setText(KotlinPluginUtil.getPluginVersion());
        if (ApplicationManager.getApplication().isInternal()) {
            String buildNumber2 = VersioningKt.getBuildNumber();
            this.compilerVersion.setText(buildNumber2);
        } else {
            this.bundledCompilerVersionPanel.setVisible(false);
        }
    }

    public void initChannels(List<String> channels) {
        this.channelCombo.removeAllItems();
        for (String channel : channels) {
            this.channelCombo.addItem(channel);
        }
        int size = this.channelCombo.getModel().getSize();
        String maxLengthItem = "";
        for (int i2 = 0; i2 < size; ++i2) {
            String item = (String)this.channelCombo.getModel().getElementAt(i2);
            if (item.length() <= maxLengthItem.length()) continue;
            maxLengthItem = item;
        }
        this.channelCombo.setPrototypeDisplayValue(maxLengthItem + " ");
    }

    private void createUIComponents() {
        this.updateCheckProgressIcon = new AsyncProcessIcon("Plugin update check progress");
    }

    public void resetUpdateStatus() {
        this.updateStatusLabel.setText(" ");
        this.installButton.setVisible(false);
        this.installStatusLabel.setVisible(false);
    }

    public void setUpdateStatus(String message2, boolean showInstallButton) {
        this.installButton.setEnabled(true);
        this.installButton.setVisible(showInstallButton);
        this.updateStatusLabel.setText(message2);
        this.installStatusLabel.setVisible(true);
        this.installStatusLabel.setText("");
    }

    public void showInstallButton() {
        this.installButton.setEnabled(true);
        this.installButton.setVisible(true);
    }

    public void hideInstallButton() {
        this.installButton.setEnabled(false);
        this.installButton.setVisible(false);
    }

    private void showVerifierDisabledStatus() {
        if (!Registry.is((String)"kotlin.plugin.update.verifier.enabled", (boolean)true)) {
            this.verifierDisabledText.setText("(verifier disabled)");
        } else {
            this.verifierDisabledText.setText("");
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel2;
        JTextPane jTextPane2;
        JButton jButton;
        JLabel jLabel;
        JLabel jLabel2;
        JButton jButton2;
        JLabel jLabel3;
        JPanel jPanel3;
        this.createUIComponents();
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, 5, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.updateStatusLabel = jLabel3 = new JLabel();
        jLabel3.setText(" ");
        Component component = jPanel4.add(jLabel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 5, 0));
        jPanel3.add((Component)jPanel5, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.installButton = jButton2 = new JButton();
        jButton2.setActionCommand("Install");
        jButton2.setLabel("Install");
        jButton2.setText("Install");
        jButton2.setMnemonic('I');
        jButton2.setDisplayedMnemonicIndex(0);
        ((Component)jButton2).setVisible(true);
        Component component2 = jPanel5.add(jButton2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1, 0, 5));
        Component component3 = jPanel5.add(jPanel6);
        this.installStatusLabel = jLabel2 = new JLabel();
        jLabel2.setText(" ");
        Component component4 = jPanel6.add(jLabel2);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 5, 0));
        jPanel3.add((Component)jPanel7, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.verifierDisabledText = jLabel = new JLabel();
        ((Component)jLabel).setForeground(new Color(-65536));
        jLabel.setText("(status)");
        Component component5 = jPanel7.add(jLabel);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(0, 5, 0));
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Update channel:");
        jLabel4.setDisplayedMnemonic('C');
        jLabel4.setDisplayedMnemonicIndex(7);
        Component component6 = jPanel8.add(jLabel4);
        JComboBox jComboBox = new JComboBox();
        this.channelCombo = jComboBox;
        Component component7 = jPanel8.add(jComboBox);
        this.reCheckButton = jButton = new JButton();
        jButton.setText("Check again");
        jButton.setMnemonic('K');
        jButton.setDisplayedMnemonicIndex(4);
        Component component8 = jPanel8.add(jButton);
        AsyncProcessIcon asyncProcessIcon = this.updateCheckProgressIcon;
        Component component9 = jPanel8.add((Component)asyncProcessIcon);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(0, 5, 0));
        jPanel3.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(335, 24), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Current Kotlin plugin version:");
        Component component10 = jPanel9.add(jLabel5);
        this.currentVersion = jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setText("{version}");
        Component component11 = jPanel9.add(jTextPane2);
        this.bundledCompilerVersionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(335, 24), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Build number (internal mode):");
        Component component12 = jPanel2.add(jLabel6);
        this.compilerVersion = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setText("{version}");
        Component component13 = jPanel2.add(jTextPane);
        jLabel4.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

