/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.KotlinDescriptorIconProvider;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.completion.BasicLookupElementFactory;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.ItemPriority;
import org.jetbrains.kotlin.idea.completion.LookupElementsCollector;
import org.jetbrains.kotlin.idea.completion.OverridesCompletion;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObjectKt;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMembersHandler;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/OverridesCompletion;", "", "collector", "Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "(Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;)V", "PRESENTATION_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "canOverride", "", "descriptorToOverride", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "complete", "", "position", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class OverridesCompletion {
    private final DescriptorRenderer PRESENTATION_RENDERER;
    private final LookupElementsCollector collector;
    private final BasicLookupElementFactory lookupElementFactory;

    /*
     * WARNING - void declaration
     */
    public final void complete(@NotNull PsiElement position, @Nullable KtCallableDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        PsiElement $receiver$iv = position;
        boolean isConstructorParameter = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtPrimaryConstructor.class, (boolean)false) != null;
        PsiElement $receiver$iv2 = position;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        Collection<OverrideMemberChooserObject> members2 = new OverrideMembersHandler(isConstructorParameter).collectMembersToGenerate(classOrObject);
        for (OverrideMemberChooserObject memberObject : members2) {
            String baseClassName;
            void lookupElement2;
            void text2;
            CallableMemberDescriptor descriptor2 = memberObject.getDescriptor();
            if (declaration2 != null && !this.canOverride(descriptor2, declaration2) || isConstructorParameter && !(descriptor2 instanceof PropertyDescriptor)) continue;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = BasicLookupElementFactory.createLookupElement$default(this.lookupElementFactory, descriptor2, false, false, false, 14, null);
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = "override " + this.PRESENTATION_RENDERER.render(descriptor2);
            if (descriptor2 instanceof FunctionDescriptor) {
                text2.element = (String)text2.element + " {...}";
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor baseClass = (ClassDescriptor)declarationDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)baseClass.getName().asString(), (String)"baseClass.name.asString()");
            Object object = ((LookupElement)lookupElement2.element).getObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject");
            }
            Icon baseIcon = ((DeclarationLookupObject)object).getIcon(0);
            boolean isImplement = descriptor2.getModality() == Modality.ABSTRACT;
            Icon additionalIcon = isImplement ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod;
            RowIcon icon = new RowIcon(new Icon[]{baseIcon, additionalIcon});
            Project project = position.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"position.project");
            PsiElement baseClassDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, baseClass);
            Icon baseClassIcon = KotlinDescriptorIconProvider.getIcon(baseClass, baseClassDeclaration, 0);
            lookupElement2.element = (LookupElement)new LookupElementDecorator<LookupElement>(declaration2, (Ref.ObjectRef)text2, isImplement, icon, baseClassName, baseClassIcon, isConstructorParameter, memberObject, classOrObject, (Ref.ObjectRef)lookupElement2, (LookupElement)lookupElement2.element){
                final /* synthetic */ KtCallableDeclaration $declaration;
                final /* synthetic */ Ref.ObjectRef $text;
                final /* synthetic */ boolean $isImplement;
                final /* synthetic */ RowIcon $icon;
                final /* synthetic */ String $baseClassName;
                final /* synthetic */ Icon $baseClassIcon;
                final /* synthetic */ boolean $isConstructorParameter;
                final /* synthetic */ OverrideMemberChooserObject $memberObject;
                final /* synthetic */ KtClassOrObject $classOrObject;
                final /* synthetic */ Ref.ObjectRef $lookupElement;

                @NotNull
                public String getLookupString() {
                    String string;
                    if (this.$declaration == null) {
                        string = "override";
                    } else {
                        LookupElement lookupElement2 = this.getDelegate();
                        Intrinsics.checkExpressionValueIsNotNull((Object)lookupElement2, (String)"delegate");
                        String string2 = lookupElement2.getLookupString();
                        string = string2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"delegate.lookupString");
                    }
                    return string;
                }

                @NotNull
                public Set<String> getAllLookupStrings() {
                    Object[] objectArray = new String[2];
                    objectArray[0] = this.getLookupString();
                    LookupElement lookupElement2 = this.getDelegate();
                    Intrinsics.checkExpressionValueIsNotNull((Object)lookupElement2, (String)"delegate");
                    String string = lookupElement2.getLookupString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"delegate.lookupString");
                    objectArray[1] = string;
                    return SetsKt.setOf((Object[])objectArray);
                }

                public void renderElement(@NotNull LookupElementPresentation presentation) {
                    Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
                    super.renderElement(presentation);
                    presentation.setItemText((String)this.$text.element);
                    presentation.setItemTextBold(this.$isImplement);
                    presentation.setIcon((Icon)this.$icon);
                    presentation.clearTail();
                    presentation.setTypeText(this.$baseClassName, this.$baseClassIcon);
                }

                public void handleInsert(@NotNull InsertionContext context) {
                    KtCallableDeclaration insertedMember;
                    KtCallableDeclaration ktCallableDeclaration;
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    String dummyMemberHead = this.$declaration != null ? "" : (this.$isConstructorParameter ? "override val " : "override fun ");
                    String dummyMemberTail = this.$isConstructorParameter || this.$declaration instanceof KtProperty ? "dummy: Dummy ,@" : "dummy() {}";
                    String dummyMemberText = dummyMemberHead + dummyMemberTail;
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.OVERRIDE_KEYWORD");
                    String string = ktModifierKeywordToken.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KtTokens.OVERRIDE_KEYWORD.value");
                    String override = string;
                    Function2<Integer, Integer, Integer> calcStartOffset$ = new Function2<Integer, Integer, Integer>(context, override){
                        final /* synthetic */ InsertionContext $context;
                        final /* synthetic */ String $override;

                        public final int invoke(int startOffset, int diff) {
                            while (true) {
                                Document document = this.$context.getDocument();
                                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"context.document");
                                if (!CharsKt.isWhitespace((char)document.getText().charAt(startOffset - 1))) break;
                                ++diff;
                                --startOffset;
                            }
                            Document document = this.$context.getDocument();
                            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"context.document");
                            String string = document.getText();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.document.text");
                            String string2 = string;
                            int n = startOffset - this.$override.length();
                            String string3 = string2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string4 = string3.substring(n, startOffset);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            if (Intrinsics.areEqual((Object)string4, (Object)this.$override)) {
                                return startOffset - this.$override.length();
                            }
                            return diff + startOffset;
                        }

                        public static /* synthetic */ int invoke$default(complete.handleInsert.1 var0, int n, int n2, int n3, Object object) {
                            if ((n3 & 2) != 0) {
                                n2 = 0;
                            }
                            return var0.invoke(n, n2);
                        }
                        {
                            this.$context = insertionContext;
                            this.$override = string;
                            super(2);
                        }
                    };
                    int startOffset = complete.handleInsert.1.invoke$default(calcStartOffset$, context.getStartOffset(), 0, 2, null);
                    int tailOffset = context.getTailOffset();
                    context.getDocument().replaceString(startOffset, tailOffset, (CharSequence)dummyMemberText);
                    PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
                    psiDocumentManager.commitAllDocuments();
                    PsiElement psiElement2 = context.getFile().findElementAt(startOffset);
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"context.file.findElementAt(startOffset)!!");
                    PsiElement $receiver$iv = psiElement2;
                    PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNamedDeclaration.class, (boolean)true);
                    if (psiElement3 == null) {
                        Intrinsics.throwNpe();
                    }
                    KtNamedDeclaration dummyMember = (KtNamedDeclaration)psiElement3;
                    Project project = context.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
                    KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
                    KtModifierList ktModifierList = dummyMember.getModifierList();
                    if (ktModifierList == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierList, (String)"dummyMember.modifierList!!");
                    String string2 = ktModifierList.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dummyMember.modifierList!!.text");
                    KtModifierList modifierList = ktPsiFactory.createModifierList(string2);
                    KtCallableDeclaration prototype2 = OverrideMemberChooserObjectKt.generateMember(this.$memberObject, this.$classOrObject, false);
                    KtModifierList ktModifierList2 = prototype2.getModifierList();
                    if (ktModifierList2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ktModifierList2.replace((PsiElement)modifierList);
                    PsiElement $receiver$iv2 = dummyMember;
                    PsiElement result$iv = $receiver$iv2.replace((PsiElement)prototype2);
                    PsiElement psiElement4 = result$iv;
                    if (!(psiElement4 instanceof KtCallableDeclaration)) {
                        psiElement4 = null;
                    }
                    if ((ktCallableDeclaration = (KtCallableDeclaration)psiElement4) == null) {
                        PsiElement psiElement5 = result$iv;
                        if (psiElement5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        }
                        KtExpression ktExpression = ((KtParenthesizedExpression)psiElement5).getExpression();
                        if (ktExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                        }
                        ktCallableDeclaration = insertedMember = (KtCallableDeclaration)ktExpression;
                    }
                    if (DescriptorUtilsKt.isSuspend(this.$memberObject.getDescriptor())) {
                        insertedMember.addModifier(KtTokens.SUSPEND_KEYWORD);
                    }
                    ShortenReferences.process$default(ShortenReferences.DEFAULT, insertedMember, null, 2, null);
                    if (this.$isConstructorParameter) {
                        psiDocumentManager.doPostponedOperationsAndUnblockDocument(context.getDocument());
                        int offset2 = PsiUtilsKt.getEndOffset(insertedMember);
                        Document document = context.getDocument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"context.document");
                        CharSequence charSequence = document.getCharsSequence();
                        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"context.document.charsSequence");
                        CharSequence chars = charSequence;
                        Integer n = HandlerUtilsKt.indexOfSkippingSpace(chars, ',', offset2);
                        if (n == null) {
                            Intrinsics.throwNpe();
                        }
                        int commaOffset = n;
                        Integer n2 = HandlerUtilsKt.indexOfSkippingSpace(chars, '@', commaOffset + 1);
                        if (n2 == null) {
                            Intrinsics.throwNpe();
                        }
                        int atCharOffset = n2;
                        context.getDocument().deleteString(offset2, atCharOffset + 1);
                        Editor editor2 = context.getEditor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"context.editor");
                        GenerateUtilKt.moveCaret$default(editor2, offset2, null, 2, null);
                    } else {
                        Editor editor3 = context.getEditor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"context.editor");
                        GenerateUtilKt.moveCaretIntoGeneratedElement(editor3, insertedMember);
                    }
                }
                {
                    this.$declaration = $captured_local_variable$0;
                    this.$text = $captured_local_variable$1;
                    this.$isImplement = $captured_local_variable$2;
                    this.$icon = $captured_local_variable$3;
                    this.$baseClassName = $captured_local_variable$4;
                    this.$baseClassIcon = $captured_local_variable$5;
                    this.$isConstructorParameter = $captured_local_variable$6;
                    this.$memberObject = $captured_local_variable$7;
                    this.$classOrObject = $captured_local_variable$8;
                    this.$lookupElement = $captured_local_variable$9;
                    super($super_call_param$10);
                }
            };
            CompletionUtilsKt.assignPriority((LookupElement)lookupElement2.element, isImplement ? ItemPriority.IMPLEMENT : ItemPriority.OVERRIDE);
            LookupElementsCollector.addElement$default(this.collector, (LookupElement)lookupElement2.element, false, 2, null);
        }
    }

    private final boolean canOverride(CallableMemberDescriptor descriptorToOverride, KtCallableDeclaration declaration2) {
        KtCallableDeclaration ktCallableDeclaration = declaration2;
        if (ktCallableDeclaration instanceof KtFunction) {
            return descriptorToOverride instanceof FunctionDescriptor;
        }
        if (ktCallableDeclaration instanceof KtValVarKeywordOwner) {
            if (!(descriptorToOverride instanceof PropertyDescriptor)) {
                return false;
            }
            PsiElement psiElement2 = ((KtValVarKeywordOwner)((Object)declaration2)).getValOrVarKeyword();
            return Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)((Object)KtTokens.VAL_KEYWORD)) ? !((PropertyDescriptor)descriptorToOverride).isVar() : true;
        }
        return false;
    }

    public OverridesCompletion(@NotNull LookupElementsCollector collector2, @NotNull BasicLookupElementFactory lookupElementFactory2) {
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Intrinsics.checkParameterIsNotNull((Object)lookupElementFactory2, (String)"lookupElementFactory");
        this.collector = collector2;
        this.lookupElementFactory = lookupElementFactory2;
        this.PRESENTATION_RENDERER = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)PRESENTATION_RENDERER.1.INSTANCE));
    }
}

