/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWithIfExpressionSurrounder;", "Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder;", "withElse", "", "(Z)V", "getWithElse", "()Z", "getTemplateDescription", "", "isApplicable", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "surroundExpression", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class KotlinWithIfExpressionSurrounder
extends KotlinExpressionSurrounder {
    private final boolean withElse;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApplicable(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (!super.isApplicable(expression2)) return false;
        KotlinType kotlinType2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL).getType(expression2);
        if (kotlinType2 == null) return false;
        boolean bl = TypeUtilsKt.isBoolean(kotlinType2);
        if (!bl) return false;
        return true;
    }

    @Override
    @Nullable
    protected TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor2, @NotNull KtExpression expression2) {
        KtBlockExpression $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        PsiElement psiElement2 = expression2.replace((PsiElement)factory2.createIf(expression2, factory2.createBlock("blockStubContentToBeRemovedLater"), this.withElse ? factory2.createEmptyBody() : null));
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression replaceResult = (KtExpression)psiElement2;
        KtExpression ktExpression = KtPsiUtil.deparenthesizeOnce(replaceResult);
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        KtIfExpression ifExpression2 = (KtIfExpression)ktExpression;
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)ifExpression2));
        KtExpression ktExpression2 = ifExpression2.getThen();
        if (!(ktExpression2 instanceof KtBlockExpression)) {
            ktExpression2 = null;
        }
        KtBlockExpression ktBlockExpression = $receiver$iv = (KtBlockExpression)ktExpression2;
        if (ktBlockExpression == null) {
            String string;
            String string2 = string = "Then branch should exist and be a block expression";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        List<KtExpression> list2 = ktBlockExpression.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"(ifExpression.then as? K\u2026ion\"\n        }.statements");
        Object object = CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"(ifExpression.then as? K\u2026     }.statements.first()");
        TextRange firstStatementInThenRange = RangeUtilsKt.getRange((PsiElement)object);
        editor2.getDocument().deleteString(firstStatementInThenRange.getStartOffset(), firstStatementInThenRange.getEndOffset());
        return new TextRange(firstStatementInThenRange.getStartOffset(), firstStatementInThenRange.getStartOffset());
    }

    @NotNull
    public String getTemplateDescription() {
        return "if (expr) { ... }" + (this.withElse ? " else { ... }" : "");
    }

    public final boolean getWithElse() {
        return this.withElse;
    }

    public KotlinWithIfExpressionSurrounder(boolean withElse) {
        this.withElse = withElse;
    }
}

