/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

public class MoveDeclarationsOutHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiElement[] move(@NotNull PsiElement container2, @NotNull PsiElement[] statements, boolean generateDefaultInitializers) {
        if (container2 == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(0);
        }
        if (statements == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(1);
        }
        if (statements.length == 0) {
            return statements;
        }
        Project project = container2.getProject();
        ArrayList<PsiElement> resultStatements = new ArrayList<PsiElement>();
        ArrayList<KtProperty> propertiesDeclarations = new ArrayList<KtProperty>();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(project);
        PsiElement dummyFirstStatement = container2.addBefore((PsiElement)psiFactory.createExpression("dummyStatement"), statements[0]);
        try {
            LocalSearchScope scope2 = new LocalSearchScope(container2);
            int lastStatementOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            for (PsiElement statement2 : statements) {
                if (MoveDeclarationsOutHelper.needToDeclareOut(statement2, lastStatementOffset, (SearchScope)scope2)) {
                    if (statement2 instanceof KtProperty && ((KtProperty)statement2).getInitializer() != null) {
                        KtProperty property = (KtProperty)statement2;
                        KtProperty declaration2 = MoveDeclarationsOutHelper.createVariableDeclaration(property, generateDefaultInitializers);
                        declaration2 = (KtProperty)container2.addBefore((PsiElement)declaration2, dummyFirstStatement);
                        propertiesDeclarations.add(declaration2);
                        container2.addAfter(psiFactory.createNewLine(), (PsiElement)declaration2);
                        KtBinaryExpression assignment = MoveDeclarationsOutHelper.createVariableAssignment(property);
                        resultStatements.add(property.replace((PsiElement)assignment));
                        continue;
                    }
                    PsiElement newStatement = container2.addBefore(statement2, dummyFirstStatement);
                    container2.addAfter(psiFactory.createNewLine(), newStatement);
                    container2.deleteChildRange(statement2, statement2);
                    continue;
                }
                resultStatements.add(statement2);
            }
        }
        finally {
            dummyFirstStatement.delete();
        }
        ShortenReferences.DEFAULT.process(propertiesDeclarations);
        return PsiUtilCore.toPsiElementArray(resultStatements);
    }

    @NotNull
    private static KtBinaryExpression createVariableAssignment(@NotNull KtProperty property) {
        if (property == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(2);
        }
        String propertyName = property.getName();
        assert (propertyName != null) : "Property should have a name " + property.getText();
        KtBinaryExpression assignment = (KtBinaryExpression)KtPsiFactoryKt.KtPsiFactory(property).createExpression(propertyName + " = x");
        KtExpression right = assignment.getRight();
        assert (right != null) : "Created binary expression should have a right part " + assignment.getText();
        KtExpression initializer2 = property.getInitializer();
        assert (initializer2 != null) : "Initializer should exist for property " + property.getText();
        right.replace((PsiElement)initializer2);
        KtBinaryExpression ktBinaryExpression = assignment;
        if (ktBinaryExpression == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(3);
        }
        return ktBinaryExpression;
    }

    @NotNull
    private static KtProperty createVariableDeclaration(@NotNull KtProperty property, boolean generateDefaultInitializers) {
        if (property == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(4);
        }
        KotlinType propertyType = MoveDeclarationsOutHelper.getPropertyType(property);
        String defaultInitializer = null;
        if (generateDefaultInitializers && property.isVar()) {
            defaultInitializer = CodeInsightUtils.defaultInitializer(propertyType);
        }
        KtProperty ktProperty = MoveDeclarationsOutHelper.createProperty(property, propertyType, defaultInitializer);
        if (ktProperty == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(5);
        }
        return ktProperty;
    }

    @NotNull
    private static KotlinType getPropertyType(@NotNull KtProperty property) {
        if (property == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(6);
        }
        VariableDescriptor variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny(property, BodyResolveMode.PARTIAL);
        assert (variableDescriptor != null) : "Couldn't resolve property to property descriptor " + property.getText();
        KotlinType kotlinType2 = variableDescriptor.getType();
        if (kotlinType2 == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(7);
        }
        return kotlinType2;
    }

    @NotNull
    private static KtProperty createProperty(@NotNull KtProperty property, @NotNull KotlinType propertyType, @Nullable String initializer2) {
        if (property == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(8);
        }
        if (propertyType == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(9);
        }
        KtTypeReference typeRef = property.getTypeReference();
        String typeString = null;
        if (typeRef != null) {
            typeString = typeRef.getText();
        } else if (!KotlinTypeKt.isError(propertyType)) {
            typeString = IdeDescriptorRenderers.SOURCE_CODE.renderType(propertyType);
        }
        KtProperty ktProperty = KtPsiFactoryKt.KtPsiFactory(property).createProperty(property.getName(), typeString, property.isVar(), initializer2);
        if (ktProperty == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(10);
        }
        return ktProperty;
    }

    private static boolean needToDeclareOut(@NotNull PsiElement element3, int lastStatementOffset, @NotNull SearchScope scope2) {
        PsiReference lastRef;
        PsiReference[] refs;
        if (element3 == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(11);
        }
        if (scope2 == null) {
            MoveDeclarationsOutHelper.$$$reportNull$$$0(12);
        }
        return (element3 instanceof KtProperty || element3 instanceof KtClassOrObject || element3 instanceof KtFunction) && (refs = (PsiReference[])ReferencesSearch.search((PsiElement)element3, (SearchScope)scope2, (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)).length > 0 && (lastRef = refs[refs.length - 1]).getElement().getTextOffset() > lastStatementOffset;
    }

    private MoveDeclarationsOutHelper() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableAssignment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVariableAssignment";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVariableDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "needToDeclareOut";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

