/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.project.ResolveElementCache;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J2\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0002J\f\u0010\"\u001a\u00020 *\u00020 H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;", "", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "qualifierResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "(Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "<set-?>", "Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;", "resolveElementCache", "getResolveElementCache", "()Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;", "setResolveElementCache", "(Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;)V", "analyzeCodeFragment", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "getScopeAndDataFlowForAnalyzeFragment", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "resolveToElement", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "correctContextForElement", "idea-core"})
public final class CodeFragmentAnalyzer {
    @Nullable
    private ResolveElementCache resolveElementCache;
    private final ResolveSession resolveSession;
    private final QualifiedExpressionResolver qualifierResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final TypeResolver typeResolver;

    @Nullable
    public final ResolveElementCache getResolveElementCache() {
        return this.resolveElementCache;
    }

    @Inject
    public final void setResolveElementCache(@Nullable ResolveElementCache resolveElementCache) {
        this.resolveElementCache = resolveElementCache;
    }

    /*
     * WARNING - void declaration
     */
    public final void analyzeCodeFragment(@NotNull KtCodeFragment codeFragment, @NotNull BindingTrace trace, @NotNull BodyResolveMode bodyResolveMode) {
        void scopeForContextElement;
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bodyResolveMode), (String)"bodyResolveMode");
        KtElement codeFragmentElement = codeFragment.getContentElement();
        Pair<LexicalScope, DataFlowInfo> pair2 = this.getScopeAndDataFlowForAnalyzeFragment(codeFragment, (Function1<? super KtElement, ? extends BindingContext>)((Function1)new Function1<KtElement, BindingContext>(this, bodyResolveMode){
            final /* synthetic */ CodeFragmentAnalyzer this$0;
            final /* synthetic */ BodyResolveMode $bodyResolveMode;

            @NotNull
            public final BindingContext invoke(@NotNull KtElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ResolveElementCache resolveElementCache = this.this$0.getResolveElementCache();
                if (resolveElementCache == null) {
                    Intrinsics.throwNpe();
                }
                return resolveElementCache.resolveToElements(CollectionsKt.listOf((Object)it), this.$bodyResolveMode);
            }
            {
                this.this$0 = codeFragmentAnalyzer;
                this.$bodyResolveMode = bodyResolveMode;
                super(1);
            }
        }));
        if (pair2 == null) {
            return;
        }
        Object object = pair2;
        LexicalScope lexicalScope = (LexicalScope)object.component1();
        DataFlowInfo dataFlowInfo = (DataFlowInfo)object.component2();
        object = codeFragmentElement;
        if (object instanceof KtExpression) {
            KtExpression ktExpression = (KtExpression)codeFragmentElement;
            LanguageVersionSettings languageVersionSettings = this.expressionTypingServices.getLanguageVersionSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)languageVersionSettings, (String)"expressionTypingServices.languageVersionSettings");
            PreliminaryDeclarationVisitor.Companion.createForExpression(ktExpression, trace, languageVersionSettings);
            Intrinsics.checkExpressionValueIsNotNull((Object)this.expressionTypingServices.getTypeInfo((LexicalScope)scopeForContextElement, (KtExpression)codeFragmentElement, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, trace, false), (String)"expressionTypingServices\u2026  false\n                )");
        } else if (object instanceof KtTypeReference) {
            TypeResolutionContext typeResolutionContext = new TypeResolutionContext((LexicalScope)scopeForContextElement, trace, true, true, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(codeFragment)).noBareTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeResolutionContext, (String)"TypeResolutionContext(\n \u2026          ).noBareTypes()");
            TypeResolutionContext context = typeResolutionContext;
            this.typeResolver.resolvePossiblyBareType(context, (KtTypeReference)codeFragmentElement);
        }
    }

    private final KtElement correctContextForElement(@NotNull KtElement $receiver) {
        KtExpression ktExpression;
        KtElement ktElement = $receiver;
        if (ktElement instanceof KtProperty) {
            ktExpression = ((KtProperty)$receiver).getDelegateExpressionOrInitializer();
        } else if (ktElement instanceof KtFunctionLiteral) {
            Object object = ((KtFunctionLiteral)$receiver).getBodyExpression();
            ktExpression = object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)object) : null;
        } else if (ktElement instanceof KtDeclarationWithBody) {
            ktExpression = ((KtDeclarationWithBody)$receiver).getBodyExpression();
        } else if (ktElement instanceof KtBlockExpression) {
            List<KtExpression> list2 = ((KtBlockExpression)$receiver).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"this.statements");
            ktExpression = (KtExpression)CollectionsKt.lastOrNull(list2);
        } else {
            ktExpression = null;
        }
        return ktExpression != null ? (KtElement)ktExpression : $receiver;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<LexicalScope, DataFlowInfo> getScopeAndDataFlowForAnalyzeFragment(KtCodeFragment codeFragment, Function1<? super KtElement, ? extends BindingContext> resolveToElement) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        BindingContext contextForElement;
        KtElement correctedContext;
        DataFlowInfo dataFlowInfo;
        LexicalScope scopeForContextElement;
        ClassDescriptorWithResolutionScopes descriptor2;
        PsiElement context = codeFragment.getContext();
        Function1<KtClassOrObject, ClassDescriptor> getClassDescriptor$ = new Function1<KtClassOrObject, ClassDescriptor>(this, resolveToElement){
            final /* synthetic */ CodeFragmentAnalyzer this$0;
            final /* synthetic */ Function1 $resolveToElement;

            @Nullable
            public final ClassDescriptor invoke(@NotNull KtClassOrObject classOrObject) {
                Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                if (!KtPsiUtil.isLocal(classOrObject)) {
                    return CodeFragmentAnalyzer.access$getResolveSession$p(this.this$0).getClassDescriptor(classOrObject, NoLookupLocation.FROM_IDE);
                }
                return (ClassDescriptor)((BindingContext)this.$resolveToElement.invoke((Object)classOrObject)).get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
            }
            {
                this.this$0 = codeFragmentAnalyzer;
                this.$resolveToElement = function1;
                super(1);
            }
        };
        PsiElement psiElement2 = context;
        if (psiElement2 instanceof KtPrimaryConstructor) {
            ClassDescriptor classDescriptor2 = getClassDescriptor$.invoke(((KtPrimaryConstructor)context).getContainingClassOrObject());
            if (!(classDescriptor2 instanceof ClassDescriptorWithResolutionScopes)) {
                classDescriptor2 = null;
            }
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = (ClassDescriptorWithResolutionScopes)classDescriptor2;
            if (classDescriptorWithResolutionScopes == null) {
                return null;
            }
            descriptor2 = classDescriptorWithResolutionScopes;
            scopeForContextElement = descriptor2.getScopeForInitializerResolution();
            dataFlowInfo = DataFlowInfo.Companion.getEMPTY();
        } else if (psiElement2 instanceof KtSecondaryConstructor) {
            KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtSecondaryConstructor)context).getDelegationCall().getCalleeExpression();
            if (ktConstructorDelegationReferenceExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktConstructorDelegationReferenceExpression, (String)"context.getDelegationCall().calleeExpression!!");
            correctedContext = ktConstructorDelegationReferenceExpression;
            contextForElement = (BindingContext)resolveToElement.invoke((Object)correctedContext);
            scopeForContextElement = (LexicalScope)contextForElement.get(BindingContext.LEXICAL_SCOPE, correctedContext);
            dataFlowInfo = DataFlowInfo.Companion.getEMPTY();
        } else if (psiElement2 instanceof KtClassOrObject) {
            ClassDescriptor classDescriptor3 = getClassDescriptor$.invoke((KtClassOrObject)context);
            if (!(classDescriptor3 instanceof ClassDescriptorWithResolutionScopes)) {
                classDescriptor3 = null;
            }
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = (ClassDescriptorWithResolutionScopes)classDescriptor3;
            if (classDescriptorWithResolutionScopes == null) {
                return null;
            }
            descriptor2 = classDescriptorWithResolutionScopes;
            scopeForContextElement = descriptor2.getScopeForMemberDeclarationResolution();
            dataFlowInfo = DataFlowInfo.Companion.getEMPTY();
        } else if (psiElement2 instanceof KtFile) {
            scopeForContextElement = this.resolveSession.getFileScopeProvider().getFileResolutionScope((KtFile)context);
            dataFlowInfo = DataFlowInfo.Companion.getEMPTY();
        } else if (psiElement2 instanceof KtElement) {
            correctedContext = this.correctContextForElement((KtElement)context);
            contextForElement = (BindingContext)resolveToElement.invoke((Object)correctedContext);
            scopeForContextElement = (LexicalScope)contextForElement.get(BindingContext.LEXICAL_SCOPE, correctedContext);
            dataFlowInfo = BindingContextUtilsKt.getDataFlowInfoAfter(contextForElement, (PsiElement)correctedContext);
        } else {
            return null;
        }
        if (scopeForContextElement == null) {
            return null;
        }
        KtImportList importList = codeFragment.importsAsImportList();
        if (importList == null || importList.getImports().isEmpty()) {
            return TuplesKt.to((Object)scopeForContextElement, (Object)dataFlowInfo);
        }
        List<KtImportDirective> list2 = importList.getImports();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"importList.imports");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ImportingScope importingScope;
            KtImportDirective it;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            KtImportDirective ktImportDirective = it = (KtImportDirective)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktImportDirective, (String)"it");
            KtImportInfo ktImportInfo = ktImportDirective;
            ModuleDescriptor moduleDescriptor2 = this.resolveSession.getModuleDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor2, (String)"resolveSession.moduleDescriptor");
            BindingTrace bindingTrace = this.resolveSession.getTrace();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"resolveSession.trace");
            if (this.qualifierResolver.processImportReference(ktImportInfo, moduleDescriptor2, bindingTrace, CollectionsKt.emptyList(), null) == null) continue;
            ImportingScope it$iv$iv = importingScope;
            destination$iv$iv.add(it$iv$iv);
        }
        List importScopes = (List)destination$iv$iv;
        return TuplesKt.to((Object)ScopeUtilsKt.addImportingScopes(scopeForContextElement, importScopes), (Object)dataFlowInfo);
    }

    public CodeFragmentAnalyzer(@NotNull ResolveSession resolveSession, @NotNull QualifiedExpressionResolver qualifierResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkParameterIsNotNull((Object)resolveSession, (String)"resolveSession");
        Intrinsics.checkParameterIsNotNull((Object)qualifierResolver, (String)"qualifierResolver");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
        this.resolveSession = resolveSession;
        this.qualifierResolver = qualifierResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.typeResolver = typeResolver;
    }

    public static final /* synthetic */ ResolveSession access$getResolveSession$p(CodeFragmentAnalyzer $this) {
        return $this.resolveSession;
    }
}

