/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.reference.SoftReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.CachedAttributeData;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0014\u0010\u0019\u001a\u00020\r*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R(\u0010\u0003\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache;", "", "()V", "KOTLIN_BINARY_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/reference/SoftReference;", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryData;", "kotlin.jvm.PlatformType", "KOTLIN_IS_COMPILED_FILE_ATTRIBUTE", "", "attributeService", "Lorg/jetbrains/kotlin/idea/caches/FileAttributeService;", "createHeaderInfo", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "kotlinBinaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getKotlinBinaryClass", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileContent", "", "getKotlinBinaryClassHeaderData", "getKotlinBinaryFromCache", "isKotlinJvmCompiledFile", "", "toLightHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "KotlinBinaryClassHeaderData", "KotlinBinaryData", "idea-core"})
public final class IDEKotlinBinaryClassCache {
    private static final FileAttributeService attributeService;
    private static final String KOTLIN_IS_COMPILED_FILE_ATTRIBUTE;
    private static final Key<SoftReference<KotlinBinaryData>> KOTLIN_BINARY_DATA_KEY;
    public static final IDEKotlinBinaryClassCache INSTANCE;

    public final boolean isKotlinJvmCompiledFile(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getExtension();
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        if (javaClassFileType == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)string, (Object)javaClassFileType.getDefaultExtension()) ^ true) {
            return false;
        }
        KotlinBinaryData cached = this.getKotlinBinaryFromCache(file);
        if (cached != null) {
            return cached.isKotlinBinary();
        }
        return this.getKotlinBinaryClass(file, fileContent) != null;
    }

    public static /* synthetic */ boolean isKotlinJvmCompiledFile$default(IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return iDEKotlinBinaryClassCache.isKotlinJvmCompiledFile(virtualFile, byArray);
    }

    @Nullable
    public final KotlinJvmBinaryClass getKotlinBinaryClass(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
        boolean isKotlinBinaryClass;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KotlinBinaryData cached = this.getKotlinBinaryFromCache(file);
        if (cached != null && !cached.isKotlinBinary()) {
            return null;
        }
        KotlinClassFinder.Result result2 = KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent(file, fileContent);
        KotlinJvmBinaryClass kotlinBinaryClass = result2 != null ? result2.toKotlinJvmBinaryClass() : null;
        boolean bl = isKotlinBinaryClass = kotlinBinaryClass != null;
        if (file instanceof VirtualFileWithId) {
            attributeService.writeBooleanAttribute(KOTLIN_IS_COMPILED_FILE_ATTRIBUTE, file, isKotlinBinaryClass);
        }
        if (isKotlinBinaryClass) {
            KotlinBinaryClassHeaderData headerInfo = this.createHeaderInfo(kotlinBinaryClass);
            file.putUserData(KOTLIN_BINARY_DATA_KEY, (Object)new SoftReference((Object)new KotlinBinaryData(isKotlinBinaryClass, file.getTimeStamp(), headerInfo)));
        }
        return kotlinBinaryClass;
    }

    @Nullable
    public static /* synthetic */ KotlinJvmBinaryClass getKotlinBinaryClass$default(IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return iDEKotlinBinaryClassCache.getKotlinBinaryClass(virtualFile, byArray);
    }

    @Nullable
    public final KotlinBinaryClassHeaderData getKotlinBinaryClassHeaderData(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KotlinBinaryData cached = this.getKotlinBinaryFromCache(file);
        if (cached != null) {
            if (!cached.isKotlinBinary()) {
                return null;
            }
            if (cached.getHeaderData() != null) {
                return cached.getHeaderData();
            }
        }
        KotlinJvmBinaryClass kotlinBinaryClass = this.getKotlinBinaryClass(file, fileContent);
        return this.createHeaderInfo(kotlinBinaryClass);
    }

    @Nullable
    public static /* synthetic */ KotlinBinaryClassHeaderData getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return iDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(virtualFile, byArray);
    }

    private final KotlinBinaryClassHeaderData createHeaderInfo(KotlinJvmBinaryClass kotlinBinaryClass) {
        Object object = kotlinBinaryClass;
        if (object == null || (object = object.getClassId()) == null) {
            return null;
        }
        Object classId = object;
        return this.toLightHeader(kotlinBinaryClass.getClassHeader(), (ClassId)classId);
    }

    private final KotlinBinaryClassHeaderData toLightHeader(@NotNull KotlinClassHeader $receiver, ClassId classId) {
        return new KotlinBinaryClassHeaderData(classId, $receiver.getKind(), $receiver.getMetadataVersion(), $receiver.getMultifilePartNames(), $receiver.getPackageName());
    }

    private final KotlinBinaryData getKotlinBinaryFromCache(VirtualFile file) {
        CachedAttributeData<Boolean> isKotlinBinaryAttribute;
        KotlinBinaryData userData;
        SoftReference softReference = (SoftReference)file.getUserData(KOTLIN_BINARY_DATA_KEY);
        KotlinBinaryData kotlinBinaryData = userData = softReference != null ? (KotlinBinaryData)softReference.get() : null;
        if (userData != null && userData.getTimestamp() == file.getTimeStamp()) {
            return userData;
        }
        CachedAttributeData<Boolean> cachedAttributeData = isKotlinBinaryAttribute = file instanceof VirtualFileWithId ? attributeService.readBooleanAttribute(KOTLIN_IS_COMPILED_FILE_ATTRIBUTE, file) : null;
        if (isKotlinBinaryAttribute != null) {
            boolean isKotlinBinary = isKotlinBinaryAttribute.getValue();
            KotlinBinaryData kotlinBinaryData2 = new KotlinBinaryData(isKotlinBinary, file.getTimeStamp(), null);
            if (isKotlinBinary) {
                file.putUserData(KOTLIN_BINARY_DATA_KEY, (Object)new SoftReference((Object)kotlinBinaryData2));
            }
            return kotlinBinaryData2;
        }
        return null;
    }

    private IDEKotlinBinaryClassCache() {
    }

    static {
        String string;
        IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache;
        INSTANCE = iDEKotlinBinaryClassCache = new IDEKotlinBinaryClassCache();
        attributeService = (FileAttributeService)ServiceManager.getService(FileAttributeService.class);
        String $receiver = string = "kotlin-is-binary-compiled";
        FileAttributeService fileAttributeService = (FileAttributeService)ServiceManager.getService(FileAttributeService.class);
        if (fileAttributeService != null) {
            FileAttributeService.DefaultImpls.register$default(fileAttributeService, $receiver, 1, false, 4, null);
        }
        KOTLIN_IS_COMPILED_FILE_ATTRIBUTE = string;
        Key key = Key.create((String)KOTLIN_IS_COMPILED_FILE_ATTRIBUTE);
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<SoftReference\u2026_COMPILED_FILE_ATTRIBUTE)");
        KOTLIN_BINARY_DATA_KEY = key;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "kind", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "partNamesIfMultifileFacade", "", "", "packageName", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;Ljava/util/List;Ljava/lang/String;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getKind", "()Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "getPackageName", "()Ljava/lang/String;", "getPartNamesIfMultifileFacade", "()Ljava/util/List;", "idea-core"})
    public static final class KotlinBinaryClassHeaderData {
        @NotNull
        private final ClassId classId;
        @NotNull
        private final KotlinClassHeader.Kind kind;
        @NotNull
        private final JvmMetadataVersion metadataVersion;
        @NotNull
        private final List<String> partNamesIfMultifileFacade;
        @Nullable
        private final String packageName;

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @NotNull
        public final KotlinClassHeader.Kind getKind() {
            return this.kind;
        }

        @NotNull
        public final JvmMetadataVersion getMetadataVersion() {
            return this.metadataVersion;
        }

        @NotNull
        public final List<String> getPartNamesIfMultifileFacade() {
            return this.partNamesIfMultifileFacade;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public KotlinBinaryClassHeaderData(@NotNull ClassId classId, @NotNull KotlinClassHeader.Kind kind, @NotNull JvmMetadataVersion metadataVersion, @NotNull List<String> partNamesIfMultifileFacade, @Nullable String packageName) {
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            Intrinsics.checkParameterIsNotNull((Object)metadataVersion, (String)"metadataVersion");
            Intrinsics.checkParameterIsNotNull(partNamesIfMultifileFacade, (String)"partNamesIfMultifileFacade");
            this.classId = classId;
            this.kind = kind;
            this.metadataVersion = metadataVersion;
            this.partNamesIfMultifileFacade = partNamesIfMultifileFacade;
            this.packageName = packageName;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryData;", "", "isKotlinBinary", "", "timestamp", "", "headerData", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "(ZJLorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;)V", "getHeaderData", "()Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "()Z", "getTimestamp", "()J", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "idea-core"})
    public static final class KotlinBinaryData {
        private final boolean isKotlinBinary;
        private final long timestamp;
        @Nullable
        private final KotlinBinaryClassHeaderData headerData;

        public final boolean isKotlinBinary() {
            return this.isKotlinBinary;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public final KotlinBinaryClassHeaderData getHeaderData() {
            return this.headerData;
        }

        public KotlinBinaryData(boolean isKotlinBinary, long timestamp, @Nullable KotlinBinaryClassHeaderData headerData) {
            this.isKotlinBinary = isKotlinBinary;
            this.timestamp = timestamp;
            this.headerData = headerData;
        }

        public final boolean component1() {
            return this.isKotlinBinary;
        }

        public final long component2() {
            return this.timestamp;
        }

        @Nullable
        public final KotlinBinaryClassHeaderData component3() {
            return this.headerData;
        }

        @NotNull
        public final KotlinBinaryData copy(boolean isKotlinBinary, long timestamp, @Nullable KotlinBinaryClassHeaderData headerData) {
            return new KotlinBinaryData(isKotlinBinary, timestamp, headerData);
        }

        @NotNull
        public static /* synthetic */ KotlinBinaryData copy$default(KotlinBinaryData kotlinBinaryData, boolean bl, long l, KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData, int n, Object object) {
            if ((n & 1) != 0) {
                bl = kotlinBinaryData.isKotlinBinary;
            }
            if ((n & 2) != 0) {
                l = kotlinBinaryData.timestamp;
            }
            if ((n & 4) != 0) {
                kotlinBinaryClassHeaderData = kotlinBinaryData.headerData;
            }
            return kotlinBinaryData.copy(bl, l, kotlinBinaryClassHeaderData);
        }

        @NotNull
        public String toString() {
            return "KotlinBinaryData(isKotlinBinary=" + this.isKotlinBinary + ", timestamp=" + this.timestamp + ", headerData=" + this.headerData + ")";
        }

        public int hashCode() {
            int n = this.isKotlinBinary ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = this.headerData;
            return (n * 31 + Long.hashCode(this.timestamp)) * 31 + (kotlinBinaryClassHeaderData != null ? kotlinBinaryClassHeaderData.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KotlinBinaryData)) break block3;
                    KotlinBinaryData kotlinBinaryData = (KotlinBinaryData)object;
                    if (!(this.isKotlinBinary == kotlinBinaryData.isKotlinBinary) || !(this.timestamp == kotlinBinaryData.timestamp) || !Intrinsics.areEqual((Object)this.headerData, (Object)kotlinBinaryData.headerData)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

