/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class InlineAdapter
extends InstructionAdapter {
    private final SourceMapper sourceMapper;
    private final List<CatchBlock> blocks = new ArrayList<CatchBlock>();
    private boolean isLambdaInlining = false;
    private int nextLocalIndex = 0;
    private int nextLocalIndexBeforeInline = -1;

    public InlineAdapter(@NotNull MethodVisitor mv, int localsSize, @NotNull SourceMapper sourceMapper) {
        super(458752, mv);
        this.nextLocalIndex = localsSize;
        this.sourceMapper = sourceMapper;
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.updateIndex(var, 1);
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.updateIndex(var, InlineCodegenUtilsKt.getLoadStoreArgSize(opcode));
    }

    private void updateIndex(int var, int varSize) {
        int newIndex = var + varSize;
        if (newIndex > this.nextLocalIndex) {
            this.nextLocalIndex = newIndex;
        }
    }

    public int getNextLocalIndex() {
        return this.nextLocalIndex;
    }

    public void setLambdaInlining(boolean isInlining) {
        this.isLambdaInlining = isInlining;
        if (isInlining) {
            this.nextLocalIndexBeforeInline = this.nextLocalIndex;
        } else {
            this.nextLocalIndex = this.nextLocalIndexBeforeInline;
        }
    }

    public void visitTryCatchBlock(@NotNull Label start2, @NotNull Label end, @NotNull Label handler2, @Nullable String type2) {
        if (!this.isLambdaInlining) {
            this.blocks.add(new CatchBlock(start2, end, handler2, type2));
        } else {
            super.visitTryCatchBlock(start2, end, handler2, type2);
        }
    }

    public void visitLineNumber(int line, @NotNull Label start2) {
        if ((line = this.sourceMapper.mapLineNumber(line)) >= 0) {
            super.visitLineNumber(line, start2);
        }
    }

    public void visitMaxs(int stack, int locals) {
        for (CatchBlock b : this.blocks) {
            super.visitTryCatchBlock(b.start, b.end, b.handler, b.type);
        }
        super.visitMaxs(stack, locals);
    }

    private static class CatchBlock {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final String type;

        public CatchBlock(@NotNull Label start2, @NotNull Label end, @NotNull Label handler2, @Nullable String type2) {
            this.start = start2;
            this.end = end;
            this.handler = handler2;
            this.type = type2;
        }
    }
}

