/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.UniqueIdConfigurationProducer;
import com.intellij.execution.testframework.AbstractInClassConfigurationProducer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import org.jetbrains.annotations.NotNull;

public final class TestInClassConfigurationProducer
extends JUnitConfigurationProducer {
    private final JUnitInClassConfigurationProducerDelegate myDelegate = new JUnitInClassConfigurationProducerDelegate();

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        return this.myDelegate.setupConfigurationFromContext(configuration, context, sourceElement);
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext fromContext, @NotNull Runnable performRunnable) {
        if (configuration == null) {
            TestInClassConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (fromContext == null) {
            TestInClassConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (performRunnable == null) {
            TestInClassConfigurationProducer.$$$reportNull$$$0(2);
        }
        this.myDelegate.onFirstRun(configuration, fromContext, performRunnable);
    }

    public boolean isConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context) {
        String[] nodeIds = UniqueIdConfigurationProducer.getNodeIds(context);
        if (nodeIds != null && nodeIds.length > 0) {
            return false;
        }
        return super.isConfigurationFromContext((JavaTestConfigurationBase)configuration, context);
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return this.myDelegate.isApplicableTestType(type, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fromContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "performRunnable";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/junit/TestInClassConfigurationProducer";
        objectArray[2] = "onFirstRun";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JUnitInClassConfigurationProducerDelegate
    extends AbstractInClassConfigurationProducer<JUnitConfiguration> {
        private JUnitInClassConfigurationProducerDelegate() {
        }

        @NotNull
        public ConfigurationFactory getConfigurationFactory() {
            ConfigurationFactory configurationFactory = JUnitConfigurationType.getInstance().getConfigurationFactories()[0];
            if (configurationFactory == null) {
                JUnitInClassConfigurationProducerDelegate.$$$reportNull$$$0(0);
            }
            return configurationFactory;
        }

        protected boolean isApplicableTestType(String type, ConfigurationContext context) {
            return "class".equals(type) || "method".equals(type);
        }

        protected boolean isRequiredVisibility(PsiMember psiElement) {
            if (JUnitUtil.isJUnit5((PsiElement)psiElement)) {
                return true;
            }
            return super.isRequiredVisibility(psiElement);
        }

        protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
            return super.setupConfigurationFromContext((JavaTestConfigurationBase)configuration, context, sourceElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestInClassConfigurationProducer$JUnitInClassConfigurationProducerDelegate", "getConfigurationFactory"));
        }
    }
}

