/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;
import org.jetbrains.idea.eclipse.importWizard.EclipseImportBuilder;
import org.jetbrains.idea.eclipse.importer.EclipseProjectCodeStyleData;

public class EclipseCodeStyleImportStep
extends ProjectImportWizardStep {
    private JPanel myTopPanel;
    private JBList<EclipseProjectCodeStyleData> myCodeStylesList;
    private JBRadioButton myUseDefaultCodeStyleRB;
    private JBRadioButton myImportCodeStyleRB;
    private JPanel myTitlePanel;
    private JLabel myImportCodeStyleLabel;
    private JBLabel myUseDefaultHint;
    private JBLabel myImportHint;
    private JCheckBox myOrganizeImportsCheckBox;
    private final DefaultListModel<EclipseProjectCodeStyleData> myCodeStylesListModel;

    public EclipseCodeStyleImportStep(WizardContext context) {
        super(context);
        this.$$$setupUI$$$();
        this.myCodeStylesListModel = new DefaultListModel();
        this.myCodeStylesList.setModel(this.myCodeStylesListModel);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myUseDefaultCodeStyleRB);
        group.add((AbstractButton)this.myImportCodeStyleRB);
        this.myTitlePanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Choose project code style"));
        this.myCodeStylesList.setEmptyText("Code styles not found");
        this.myUseDefaultCodeStyleRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EclipseCodeStyleImportStep.this.updateProjectListEnabledStatus();
            }
        });
        this.myImportCodeStyleRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EclipseCodeStyleImportStep.this.updateProjectListEnabledStatus();
            }
        });
        this.myCodeStylesList.getSelectionModel().setSelectionMode(0);
        this.myCodeStylesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EclipseProjectCodeStyleData codeStyleData = (EclipseProjectCodeStyleData)EclipseCodeStyleImportStep.this.myCodeStylesList.getSelectedValue();
                EclipseCodeStyleImportStep.this.updateOnSelectedItemChange(codeStyleData);
            }
        });
        this.myOrganizeImportsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EclipseCodeStyleImportStep.this.updateOnOrganizeImportsBoxChange();
            }
        });
        this.myUseDefaultHint.setText(EclipseBundle.message("eclipse.import.code.style.default.hint", new Object[0]));
        EclipseCodeStyleImportStep.customizeHintLabel(this.myUseDefaultHint);
        this.myImportHint.setText(EclipseBundle.message("eclipse.import.code.style.import.hint", new Object[0]));
        EclipseCodeStyleImportStep.customizeHintLabel(this.myImportHint);
    }

    private static void customizeHintLabel(@NotNull JBLabel hintLabel) {
        if (hintLabel == null) {
            EclipseCodeStyleImportStep.$$$reportNull$$$0(0);
        }
        hintLabel.setForeground((Color)JBColor.GRAY);
        hintLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    public JComponent getComponent() {
        return this.myTopPanel;
    }

    public void updateDataModel() {
        EclipseImportBuilder builder = (EclipseImportBuilder)this.getWizardContext().getProjectBuilder();
        assert (builder != null);
        if (this.myImportCodeStyleRB.isSelected()) {
            builder.getParameters().codeStyleData = (EclipseProjectCodeStyleData)this.myCodeStylesList.getSelectedValue();
        }
    }

    private void updateOnSelectedItemChange(@Nullable EclipseProjectCodeStyleData codeStyleData) {
        this.myOrganizeImportsCheckBox.setEnabled(codeStyleData != null && codeStyleData.isEclipseImportsConfigAvailable());
        this.myOrganizeImportsCheckBox.setSelected(codeStyleData != null && codeStyleData.isImportOrganizeImportsConfig());
    }

    private void updateOnOrganizeImportsBoxChange() {
        EclipseProjectCodeStyleData codeStyleData = (EclipseProjectCodeStyleData)this.myCodeStylesList.getSelectedValue();
        if (codeStyleData != null) {
            codeStyleData.setImportOrganizeImportsConfig(this.myOrganizeImportsCheckBox.isSelected());
        }
    }

    public void updateStep() {
        this.myCodeStylesListModel.clear();
        for (EclipseProjectCodeStyleData codeStyleData : this.getCodeStylesList()) {
            this.myCodeStylesListModel.addElement(codeStyleData);
        }
        boolean isEnabled = !this.myCodeStylesListModel.isEmpty();
        this.myImportCodeStyleRB.setEnabled(isEnabled);
        this.myImportCodeStyleLabel.setEnabled(isEnabled);
        this.myUseDefaultCodeStyleRB.setSelected(true);
        this.updateProjectListEnabledStatus();
    }

    private void updateProjectListEnabledStatus() {
        boolean isEnabled = this.myImportCodeStyleRB.isSelected() && !this.myCodeStylesListModel.isEmpty();
        this.myCodeStylesList.setEnabled(isEnabled);
        this.myOrganizeImportsCheckBox.setEnabled(isEnabled);
        if (isEnabled) {
            this.myCodeStylesList.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.myCodeStylesList.getSelectionModel().clearSelection();
        }
    }

    private List<EclipseProjectCodeStyleData> getCodeStylesList() {
        ArrayList<EclipseProjectCodeStyleData> codeStyleDataList = new ArrayList<EclipseProjectCodeStyleData>();
        ProjectBuilder builder = this.getWizardContext().getProjectBuilder();
        if (builder instanceof EclipseImportBuilder) {
            EclipseImportBuilder eclipseImportBuilder = (EclipseImportBuilder)builder;
            for (String projectPath : eclipseImportBuilder.getParameters().projectsToConvert) {
                EclipseProjectCodeStyleData codeStyleData;
                String projectName = EclipseProjectFinder.findProjectName((String)projectPath);
                if (projectName == null || !(codeStyleData = new EclipseProjectCodeStyleData(projectName, projectPath)).loadEclipsePreferences()) continue;
                codeStyleDataList.add(codeStyleData);
            }
        }
        return codeStyleDataList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintLabel", "org/jetbrains/idea/eclipse/importWizard/EclipseCodeStyleImportStep", "customizeHintLabel"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBList jBList;
        JLabel jLabel;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitlePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(), (String)"Choose project code style", (int)0, (int)0, null, null));
        this.myUseDefaultCodeStyleRB = jBRadioButton2 = new JBRadioButton();
        jPanel.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 4, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("EclipseBundle").getString("eclipse.import.code.style.default.option"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImportCodeStyleRB = jBRadioButton = new JBRadioButton();
        jPanel.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myImportCodeStyleLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("EclipseBundle").getString("eclipse.import.code.style.import.option"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(5, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCodeStylesList = jBList = new JBList();
        DefaultListModel defaultListModel = new DefaultListModel();
        jBList.setModel(defaultListModel);
        jBScrollPane.setViewportView((Component)jBList);
        this.myUseDefaultHint = jBLabel2 = new JBLabel();
        jBLabel2.setText("Text");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myImportHint = jBLabel = new JBLabel();
        jBLabel.setText("Text");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 1, 1, 1, 1, 0, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5)));
        this.myOrganizeImportsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("EclipseBundle").getString("eclipse.import.code.style.organize.imports.box"));
        jPanel.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

