/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtCompilingExecutor;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0002!\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "backgroundProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkForErrors", "", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "compileFileToTempDir", "Ljava/io/File;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "module", "Lcom/intellij/openapi/module/Module;", "mainClassName", "", "tempOutDir", "execute", "", "stop", "writeClassFilesToTempDir", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "findExpression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "psiElement", "Lcom/intellij/psi/PsiElement;", "lineStart", "", "lineEnd", "Companion", "ProcessOutputParser", "idea-jvm"})
public final class KtCompilingExecutor
extends ScratchExecutor {
    private ProgressIndicator backgroundProcessIndicator;
    private static final int TIMEOUT_MS = 30000;
    public static final Companion Companion = new Companion(null);

    @Override
    public void execute() {
        this.getHandler().onStart(this.getFile());
        Module module = this.getFile().getModule();
        if (module == null) {
            ScratchExecutor.errorOccurs$default(this, "Module should be selected", null, true, 2, null);
            return;
        }
        Module module2 = module;
        PsiFile psiFile = this.getFile().getPsiFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            ScratchExecutor.errorOccurs$default(this, "Couldn't find KtFile for current editor", null, true, 2, null);
            return;
        }
        KtFile psiFile2 = ktFile;
        if (!this.checkForErrors(psiFile2)) {
            return;
        }
        KtScratchSourceFileProcessor.Result result2 = (KtScratchSourceFileProcessor.Result)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtScratchSourceFileProcessor.Result>(this){
            final /* synthetic */ KtCompilingExecutor this$0;

            @NotNull
            public final KtScratchSourceFileProcessor.Result invoke() {
                return new KtScratchSourceFileProcessor().process(KtCompilingExecutor.access$getFile$p(this.this$0));
            }
            {
                this.this$0 = ktCompilingExecutor;
                super(0);
            }
        }));
        KtScratchSourceFileProcessor.Result result3 = result2;
        if (result3 instanceof KtScratchSourceFileProcessor.Result.Error) {
            ScratchExecutor.errorOccurs$default(this, ((KtScratchSourceFileProcessor.Result.Error)result2).getMessage(), null, true, 2, null);
            return;
        }
        if (result3 instanceof KtScratchSourceFileProcessor.Result.OK) {
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "After processing by KtScratchSourceFileProcessor:\n " + ((KtScratchSourceFileProcessor.Result.OK)result2).getCode());
            new Task.Backgroundable(this, psiFile2, result2, module2, psiFile2.getProject(), "Running Kotlin Scratch...", true){
                final /* synthetic */ KtCompilingExecutor this$0;
                final /* synthetic */ KtFile $psiFile;
                final /* synthetic */ KtScratchSourceFileProcessor.Result $result;
                final /* synthetic */ Module $module;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    KtCompilingExecutor.access$setBackgroundProcessIndicator$p(this.this$0, indicator);
                    KtFile modifiedScratchSourceFile2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(this){
                        final /* synthetic */ execute.1 this$0;

                        @NotNull
                        public final KtFile invoke() {
                            Project project = this.this$0.$psiFile.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
                            return new KtPsiFactory(project, false, 2, null).createFileWithLightClassSupport("tmp.kt", ((KtScratchSourceFileProcessor.Result.OK)this.this$0.$result).getCode(), (PsiElement)this.this$0.$psiFile);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    try {
                        File file2 = (File)DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode((Computable)new Computable<File>(this, modifiedScratchSourceFile2){
                            final /* synthetic */ execute.1 this$0;
                            final /* synthetic */ KtFile $modifiedScratchSourceFile;

                            @Nullable
                            public final File compute() {
                                return KtCompilingExecutor.access$compileFileToTempDir(this.this$0.this$0, this.$modifiedScratchSourceFile);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$modifiedScratchSourceFile = ktFile;
                            }
                        });
                        if (file2 == null) {
                            return;
                        }
                        File tempDir2 = file2;
                        try {
                            String string = ((KtScratchSourceFileProcessor.Result.OK)this.$result).getMainClassName();
                            String string2 = tempDir2.getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tempDir.path");
                            GeneralCommandLine commandLine = KtCompilingExecutor.access$createCommandLine(this.this$0, this.$module, string, string2);
                            Logger logger = ScratchUtilsKt.getLOG();
                            String string3 = commandLine.getCommandLineString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"commandLine.commandLineString");
                            ScratchUtilsKt.printDebugMessage(logger, string3);
                            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
                            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator, KtCompilingExecutor.access$getTIMEOUT_MS$cp());
                            Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"processHandler.runProces\u2026or(indicator, TIMEOUT_MS)");
                            ProcessOutput executionResult = processOutput;
                            if (executionResult.isTimeout()) {
                                ScratchExecutor.errorOccurs$default(this.this$0, "Couldn't get scratch execution result - stopped by timeout (" + KtCompilingExecutor.access$getTIMEOUT_MS$cp() + " ms)", null, false, 6, null);
                            } else if (executionResult.isCancelled()) {
                            } else {
                                this.this$0.new ProcessOutputParser().parse(executionResult);
                            }
                        }
                        finally {
                            tempDir2.delete();
                            KtCompilingExecutor.access$getHandler$p(this.this$0).onFinish(KtCompilingExecutor.access$getFile$p(this.this$0));
                        }
                    }
                    catch (Throwable e) {
                        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), ((KtScratchSourceFileProcessor.Result.OK)this.$result).getCode());
                        String string = e.getMessage();
                        if (string == null) {
                            string = "Couldn't compile " + this.$psiFile.getName();
                        }
                        this.this$0.errorOccurs(string, e, true);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$psiFile = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                    this.$module = $captured_local_variable$3;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }
            }.queue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            if (progressIndicator != null) {
                progressIndicator.cancel();
            }
        }
        finally {
            this.getHandler().onFinish(this.getFile());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File compileFileToTempDir(KtFile psiFile) {
        void bindingContext2;
        if (!this.checkForErrors(psiFile)) {
            return null;
        }
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)((KtElement)psiFile));
        Pair pair = DebuggerUtils.analyzeInlinedFunctions$default(DebuggerUtils.INSTANCE, resolutionFacade, psiFile, false, null, 8, null);
        BindingContext bindingContext3 = (BindingContext)pair.component1();
        List files = (List)pair.component2();
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Analyzed files: \n" + CollectionsKt.joinToString$default((Iterable)files, (CharSequence)"\n", null, null, (int)0, null, (Function1)compileFileToTempDir.1.INSTANCE, (int)30, null));
        GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(psiFile){
            final /* synthetic */ KtFile $psiFile;

            public boolean shouldGeneratePackagePart(@NotNull KtFile ktFile) {
                Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
                return Intrinsics.areEqual((Object)ktFile, (Object)this.$psiFile);
            }

            public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
                Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                return true;
            }

            public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
                Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                return Intrinsics.areEqual((Object)processingClassOrObject.getContainingKtFile(), (Object)this.$psiFile);
            }

            public boolean shouldGenerateScript(@NotNull KtScript script) {
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                return false;
            }
            {
                this.$psiFile = $captured_local_variable$0;
            }
        };
        Project project = this.getFile().getProject();
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.BINARIES");
        ModuleDescriptor moduleDescriptor = resolutionFacade.getModuleDescriptor();
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"CompilerConfiguration.EMPTY");
        GenerationState state = new GenerationState.Builder(project, classBuilderFactory, moduleDescriptor, (BindingContext)bindingContext2, files, compilerConfiguration).generateDeclaredClassFilter(generateClassFilter2).build();
        KotlinCodegenFacade.compileCorrectFiles((GenerationState)state, (CompilationErrorHandler)CompilationErrorHandler.THROW_EXCEPTION);
        return this.writeClassFilesToTempDir(state);
    }

    private final File writeClassFilesToTempDir(GenerationState state) {
        List list2 = state.getFactory().asList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"state.factory.asList()");
        Iterable classFiles = ClassFileUtilsKt.filterClassFiles((List)list2);
        File file2 = FileUtil.createTempDirectory((String)"compile", (String)"scratch");
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempDirectory(\"compile\", \"scratch\")");
        File dir = file2;
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Temp output dir: " + dir.getPath());
        for (OutputFile classFile : classFiles) {
            File tmpOutFile = new File(dir, classFile.getRelativePath());
            tmpOutFile.getParentFile().mkdirs();
            tmpOutFile.createNewFile();
            FilesKt.writeBytes((File)tmpOutFile, (byte[])classFile.asByteArray());
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Generated class file: " + classFile.getRelativePath());
        }
        return dir;
    }

    private final GeneralCommandLine createCommandLine(Module module, String mainClassName, String tempOutDir) {
        JavaParameters javaParameters = KotlinConsoleKeeper.Companion.createJavaParametersWithSdk(module);
        javaParameters.setMainClass(mainClassName);
        Object[] objectArray = CompilerPathsEx.getOutputPaths((Module[])new Module[]{module});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"CompilerPathsEx.getOutputPaths(arrayOf(module))");
        List compiledModulePath = ArraysKt.toList((Object[])objectArray);
        OrderEnumerator orderEnumerator = OrderEnumerator.orderEntries((Module)module).recursively();
        Intrinsics.checkExpressionValueIsNotNull((Object)orderEnumerator, (String)"OrderEnumerator.orderEntries(module).recursively()");
        PathsList pathsList = orderEnumerator.getPathsList();
        Intrinsics.checkExpressionValueIsNotNull((Object)pathsList, (String)"OrderEnumerator.orderEnt\u2026).recursively().pathsList");
        List list2 = pathsList.getPathList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"OrderEnumerator.orderEnt\u2026vely().pathsList.pathList");
        List moduleDependencies = list2;
        javaParameters.getClassPath().add(tempOutDir);
        javaParameters.getClassPath().addAll(compiledModulePath);
        javaParameters.getClassPath().addAll(moduleDependencies);
        GeneralCommandLine generalCommandLine = javaParameters.toCommandLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"javaParameters.toCommandLine()");
        return generalCommandLine;
    }

    private final boolean checkForErrors(KtFile psiFile) {
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this, psiFile){
            final /* synthetic */ KtCompilingExecutor this$0;
            final /* synthetic */ KtFile $psiFile;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                try {
                    AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)this.$psiFile));
                }
                catch (IllegalArgumentException e) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Couldn't compile " + this.$psiFile.getName();
                    }
                    ScratchExecutor.errorOccurs$default(this.this$0, string, null, true, 2, null);
                    return false;
                }
                AnalysisResult analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks((KtFile)this.$psiFile, (KtFile[])new KtFile[0]);
                if (analysisResult.isError()) {
                    String string = analysisResult.getError().getMessage();
                    if (string == null) {
                        string = "Couldn't compile " + this.$psiFile.getName();
                    }
                    ScratchExecutor.errorOccurs$default(this.this$0, string, null, true, 2, null);
                    return false;
                }
                BindingContext bindingContext2 = analysisResult.getBindingContext();
                Diagnostics diagnostics = bindingContext2.getDiagnostics();
                Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics, (String)"bindingContext.diagnostics");
                Iterable iterable = $receiver$iv = (Iterable)diagnostics;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    Diagnostic it = (Diagnostic)element$iv$iv;
                    if (!(it.getSeverity() == Severity.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List diagnostics2 = (List)destination$iv$iv;
                $receiver$iv = diagnostics2;
                if (!$receiver$iv.isEmpty()) {
                    PsiFile scratchPsiFile = KtCompilingExecutor.access$getFile$p(this.this$0).getPsiFile();
                    Iterable $receiver$iv2 = diagnostics2;
                    for (T element$iv : $receiver$iv2) {
                        String errorText;
                        Diagnostic diagnostic = (Diagnostic)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)DefaultErrorMessages.render((Diagnostic)diagnostic), (String)"DefaultErrorMessages.render(diagnostic)");
                        if (Intrinsics.areEqual((Object)this.$psiFile, (Object)scratchPsiFile)) {
                            PsiElement psiElement = diagnostic.getPsiElement();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"diagnostic.psiElement");
                            if (Intrinsics.areEqual((Object)psiElement.getContainingFile(), (Object)this.$psiFile)) {
                                ScratchFile scratchFile = KtCompilingExecutor.access$getFile$p(this.this$0);
                                PsiElement psiElement2 = diagnostic.getPsiElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
                                ScratchExpression scratchExpression = KtCompilingExecutor.access$findExpression(this.this$0, scratchFile, psiElement2);
                                if (scratchExpression == null) {
                                    Logger logger = ScratchUtilsKt.getLOG();
                                    StringBuilder stringBuilder = new StringBuilder().append("Couldn't find expression to report error: ");
                                    PsiElement psiElement3 = diagnostic.getPsiElement();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"diagnostic.psiElement");
                                    logger.error(stringBuilder.append(PsiUtilsKt.getElementTextWithContext((PsiElement)psiElement3)).toString());
                                    KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText);
                                    continue;
                                }
                                KtCompilingExecutor.access$getHandler$p(this.this$0).handle(KtCompilingExecutor.access$getFile$p(this.this$0), scratchExpression, new ScratchOutput(errorText, ScratchOutputType.ERROR));
                                continue;
                            }
                            KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText);
                            continue;
                        }
                        KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText);
                    }
                    KtCompilingExecutor.access$getHandler$p(this.this$0).onFinish(KtCompilingExecutor.access$getFile$p(this.this$0));
                    return false;
                }
                return true;
            }
            {
                this.this$0 = ktCompilingExecutor;
                this.$psiFile = ktFile;
                super(0);
            }
        }));
    }

    private final ScratchExpression findExpression(@NotNull ScratchFile $receiver, PsiElement psiElement) {
        int elementLine = KotlinRefactoringUtilKt.getLineNumber$default((PsiElement)psiElement, (boolean)false, (int)1, null);
        return (ScratchExpression)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<ScratchExpression>($receiver, elementLine){
            final /* synthetic */ ScratchFile $this_findExpression;
            final /* synthetic */ int $elementLine;

            @Nullable
            public final ScratchExpression invoke() {
                Object v0;
                block1: {
                    Iterable $receiver$iv = this.$this_findExpression.getExpressions();
                    for (T element$iv : $receiver$iv) {
                        ScratchExpression it = (ScratchExpression)element$iv;
                        int n = this.$elementLine;
                        if (!(it.getLineStart() <= n && it.getLineEnd() >= n)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
            {
                this.$this_findExpression = scratchFile;
                this.$elementLine = n;
                super(0);
            }
        }));
    }

    private final ScratchExpression findExpression(@NotNull ScratchFile $receiver, int lineStart, int lineEnd) {
        return (ScratchExpression)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<ScratchExpression>($receiver, lineStart, lineEnd){
            final /* synthetic */ ScratchFile $this_findExpression;
            final /* synthetic */ int $lineStart;
            final /* synthetic */ int $lineEnd;

            @Nullable
            public final ScratchExpression invoke() {
                Object v0;
                block1: {
                    Iterable $receiver$iv = this.$this_findExpression.getExpressions();
                    for (T element$iv : $receiver$iv) {
                        ScratchExpression it = (ScratchExpression)element$iv;
                        if (!(it.getLineStart() == this.$lineStart && it.getLineEnd() == this.$lineEnd)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
            {
                this.$this_findExpression = scratchFile;
                this.$lineStart = n;
                this.$lineEnd = n2;
                super(0);
            }
        }));
    }

    public KtCompilingExecutor(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        super(file2);
    }

    static {
        TIMEOUT_MS = 30000;
    }

    public static final /* synthetic */ ProgressIndicator access$getBackgroundProcessIndicator$p(KtCompilingExecutor $this) {
        return $this.backgroundProcessIndicator;
    }

    public static final /* synthetic */ void access$setBackgroundProcessIndicator$p(KtCompilingExecutor $this, ProgressIndicator progressIndicator) {
        $this.backgroundProcessIndicator = progressIndicator;
    }

    public static final /* synthetic */ File access$compileFileToTempDir(KtCompilingExecutor $this, KtFile psiFile) {
        return $this.compileFileToTempDir(psiFile);
    }

    public static final /* synthetic */ GeneralCommandLine access$createCommandLine(KtCompilingExecutor $this, Module module, String mainClassName, String tempOutDir) {
        return $this.createCommandLine(module, mainClassName, tempOutDir);
    }

    public static final /* synthetic */ int access$getTIMEOUT_MS$cp() {
        return TIMEOUT_MS;
    }

    public static final /* synthetic */ ScratchExpression access$findExpression(KtCompilingExecutor $this, ScratchFile $receiver, PsiElement psiElement) {
        return $this.findExpression($receiver, psiElement);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor$ProcessOutputParser;", "", "(Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;)V", "extractLineInfoFrom", "Lkotlin/Pair;", "", "encoded", "", "isGeneratedOutput", "", "line", "isOutputEnd", "isResultEnd", "parse", "", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "parseStdOut", "out", "idea-jvm"})
    private final class ProcessOutputParser {
        public final void parse(@NotNull ProcessOutput processOutput) {
            Intrinsics.checkParameterIsNotNull((Object)processOutput, (String)"processOutput");
            String string = processOutput.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processOutput.stdout");
            String out = string;
            String string2 = processOutput.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"processOutput.stderr");
            String err = string2;
            CharSequence charSequence = err;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                KtCompilingExecutor.this.getHandler().error(KtCompilingExecutor.this.getFile(), err);
            }
            if (!StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)out))) {
                this.parseStdOut(out);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseStdOut(String out) {
            ArrayList<String> results = new ArrayList<String>();
            ArrayList<String> userOutput = new ArrayList<String>();
            for (String line : StringsKt.split$default((CharSequence)out, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)) {
                ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Compiling executor output: " + line);
                if (this.isOutputEnd(line)) {
                    return;
                }
                if (this.isGeneratedOutput(line)) {
                    String lineWoPrefix = StringsKt.removePrefix((String)line, (CharSequence)"##scratch##generated##");
                    if (this.isResultEnd(lineWoPrefix)) {
                        void startLine;
                        Pair<Integer, Integer> extractedLineInfo;
                        if (this.extractLineInfoFrom(lineWoPrefix) == null) {
                            ScratchExecutor.errorOccurs$default(KtCompilingExecutor.this, "Couldn't extract line info from line: " + lineWoPrefix, null, true, 2, null);
                            return;
                        }
                        Pair<Integer, Integer> pair = extractedLineInfo;
                        int n = ((Number)pair.component1()).intValue();
                        int endLine = ((Number)pair.component2()).intValue();
                        ScratchExpression scratchExpression = KtCompilingExecutor.this.findExpression(KtCompilingExecutor.this.getFile(), (int)startLine, endLine);
                        if (scratchExpression == null) {
                            ScratchUtilsKt.getLOG().error("Couldn't find expression with start line = " + (int)startLine + ", end line = " + endLine + ".\n" + CollectionsKt.joinToString$default((Iterable)KtCompilingExecutor.this.getFile().getExpressions(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                        } else {
                            Iterable $receiver$iv = userOutput;
                            for (Object element$iv : $receiver$iv) {
                                String output = (String)element$iv;
                                KtCompilingExecutor.this.getHandler().handle(KtCompilingExecutor.this.getFile(), scratchExpression, new ScratchOutput(output, ScratchOutputType.OUTPUT));
                            }
                            $receiver$iv = results;
                            for (Object element$iv : $receiver$iv) {
                                String result2 = (String)element$iv;
                                KtCompilingExecutor.this.getHandler().handle(KtCompilingExecutor.this.getFile(), scratchExpression, new ScratchOutput(result2, ScratchOutputType.RESULT));
                            }
                        }
                        results = new ArrayList();
                        userOutput = new ArrayList();
                        continue;
                    }
                    if (!(Intrinsics.areEqual((Object)lineWoPrefix, (Object)Unit.INSTANCE.toString()) ^ true)) continue;
                    results.add(lineWoPrefix);
                    continue;
                }
                userOutput.add(line);
            }
        }

        private final boolean isOutputEnd(String line) {
            return Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)line, (CharSequence)"\n"), (Object)"end##!@#%^&*");
        }

        private final boolean isResultEnd(String line) {
            return StringsKt.startsWith$default((String)line, (String)"end##", (boolean)false, (int)2, null);
        }

        private final boolean isGeneratedOutput(String line) {
            return StringsKt.startsWith$default((String)line, (String)"##scratch##generated##", (boolean)false, (int)2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> extractLineInfoFrom(String encoded) {
            List lineInfo = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)encoded, (CharSequence)"end##"), (CharSequence)"\n"), (char[])new char[]{'|'}, (boolean)false, (int)0, (int)6, null);
            if (lineInfo.size() == 2) {
                try {
                    void a;
                    String string = (String)lineInfo.get(0);
                    Integer n = Integer.parseInt(string);
                    string = (String)lineInfo.get(1);
                    Integer n2 = n;
                    int n3 = Integer.parseInt(string);
                    Pair pair = TuplesKt.to((Object)n2, (Object)n3);
                    int n4 = ((Number)pair.component1()).intValue();
                    int b = ((Number)pair.component2()).intValue();
                    if (a > -1 && b > -1) {
                        return TuplesKt.to((Object)((int)a), (Object)b);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor$Companion;", "", "()V", "TIMEOUT_MS", "", "idea-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

