/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ.\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "()V", "defineClass", "", "name", "", "bytes", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "defineClasses", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "isApplicable", "", "info", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "loadClasses", "ClassBytes", "Companion", "idea-jvm"})
public final class OrdinaryClassLoadingAdapter
implements ClassLoadingAdapter {
    private static final List<ClassBytes> LAMBDA_SUPERCLASSES;
    @Deprecated
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull EvaluationContextImpl context, @NotNull ClassLoadingAdapter.Companion.ClassInfoForEvaluator info) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        ClassLoadingAdapter.Companion.ClassInfoForEvaluator $receiver = info;
        if (!$receiver.isCompilingEvaluatorPreferred()) return false;
        if (context.getClassLoader() == null) return false;
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
        if (NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)debugProcessImpl)) return false;
        return true;
    }

    @Override
    @NotNull
    public ClassLoaderReference loadClasses(@NotNull EvaluationContextImpl context, @NotNull Collection<ClassToLoad> classes) {
        ClassLoaderReference classLoaderReference;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
        DebugProcessImpl process2 = debugProcessImpl;
        try {
            classLoaderReference = ClassLoadingUtils.getClassLoader((EvaluationContext)((EvaluationContext)context), (DebugProcess)((DebugProcess)process2));
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error creating evaluation class loader: " + e, (Throwable)e);
        }
        ClassLoaderReference classLoader = classLoaderReference;
        String debugProcessVersionString = process2.getVirtualMachineProxy().version();
        JavaSdkVersion javaSdkVersion = JavaSdkVersion.fromVersionString((String)debugProcessVersionString);
        if (javaSdkVersion == null) {
            throw (Throwable)new EvaluateException("Unable to parse java version from " + debugProcessVersionString + '.');
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSdkVersion, (String)"JavaSdkVersion.fromVersi\u2026ugProcessVersionString.\")");
        JavaSdkVersion debugProcessVersion = javaSdkVersion;
        JavaSdkVersion javaSdkVersion2 = JavaSdkVersion.fromVersionString((String)SystemInfo.JAVA_RUNTIME_VERSION);
        if (javaSdkVersion2 == null) {
            throw (Throwable)new EvaluateException("Unable to parse java version from " + SystemInfo.JAVA_RUNTIME_VERSION + '.');
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSdkVersion2, (String)"JavaSdkVersion.fromVersi\u2026.JAVA_RUNTIME_VERSION}.\")");
        JavaSdkVersion ideaJavaVersion = javaSdkVersion2;
        if (!ideaJavaVersion.isAtLeast(debugProcessVersion)) {
            throw (Throwable)new EvaluateException("Unable to compile for target level " + debugProcessVersion.getDescription() + ". " + "Need to run IDEA on java version at least " + debugProcessVersion + ", " + "currently running on " + ideaJavaVersion);
        }
        try {
            ClassLoaderReference classLoaderReference2 = classLoader;
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoaderReference2, (String)"classLoader");
            this.defineClasses(classes, context, process2, classLoaderReference2);
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error during classes definition " + e, (Throwable)e);
        }
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    private final void defineClasses(Collection<ClassToLoad> classes, EvaluationContextImpl context, DebugProcessImpl process2, ClassLoaderReference classLoader) {
        Collection collection;
        if (classes.size() == 1) {
            collection = classes;
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)LAMBDA_SUPERCLASSES;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ClassBytes classBytes = (ClassBytes)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                ClassToLoad classToLoad = new ClassToLoad(it.getName(), StringsKt.replace$default((String)it.getName(), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class", it.getBytes());
                collection2.add(classToLoad);
            }
            List lambdaSuperclasses = (List)destination$iv$iv;
            collection = CollectionsKt.plus((Collection)lambdaSuperclasses, (Iterable)classes);
        }
        Collection classesToLoad = collection;
        for (ClassToLoad classToLoad : classesToLoad) {
            String className = classToLoad.component1();
            byte[] bytes2 = classToLoad.component3();
            byte[] patchedBytes = Companion.changeSuperToMagicAccessor(bytes2);
            this.defineClass(className, patchedBytes, context, process2, classLoader);
        }
    }

    public final void defineClass(@NotNull String name, @NotNull byte[] bytes2, @NotNull EvaluationContextImpl context, @NotNull DebugProcessImpl process2, @NotNull ClassLoaderReference classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        try {
            VirtualMachineProxyImpl virtualMachineProxyImpl = process2.getVirtualMachineProxy();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"process.virtualMachineProxy");
            VirtualMachineProxyImpl vm = virtualMachineProxyImpl;
            ReferenceType referenceType = classLoader.referenceType();
            if (referenceType == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            ClassType classLoaderType = (ClassType)referenceType;
            Method defineMethod = classLoaderType.concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            StringReference nameObj = vm.mirrorOf(name);
            DebuggerUtilsEx.keep((Value)nameObj, (EvaluationContext)((EvaluationContext)context));
            process2.invokeMethod((EvaluationContext)context, (ObjectReference)classLoader, defineMethod, CollectionsKt.listOf((Object[])new Value[]{nameObj, this.mirrorOfByteArray(bytes2, context, process2), vm.mirrorOf(0), vm.mirrorOf(bytes2.length)}));
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error during class " + name + " definition: " + e, (Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        LAMBDA_SUPERCLASSES = CollectionsKt.listOf((Object)new ClassBytes("kotlin.jvm.internal.Lambda"));
    }

    @Override
    @NotNull
    public ArrayReference mirrorOfByteArray(@NotNull byte[] bytes2, @NotNull EvaluationContextImpl context, @NotNull DebugProcessImpl process2) {
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        return ClassLoadingAdapter.DefaultImpls.mirrorOfByteArray(this, bytes2, context, process2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$ClassBytes;", "", "name", "", "(Ljava/lang/String;)V", "bytes", "", "getBytes", "()[B", "bytes$delegate", "Lkotlin/Lazy;", "getName", "()Ljava/lang/String;", "idea-jvm"})
    private static final class ClassBytes {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final Lazy bytes$delegate;
        @NotNull
        private final String name;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ClassBytes.class), "bytes", "getBytes()[B"))};
        }

        @NotNull
        public final byte[] getBytes() {
            Lazy lazy = this.bytes$delegate;
            ClassBytes classBytes = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (byte[])lazy.getValue();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public ClassBytes(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.name = name;
            this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
                final /* synthetic */ ClassBytes this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final byte[] invoke() {
                    byte[] byArray;
                    InputStream inputStream = this.this$0.getClass().getClassLoader().getResourceAsStream(StringsKt.replace$default((String)this.this$0.getName(), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class");
                    if (inputStream == null) {
                        throw (Throwable)new EvaluateException("Couldn't find " + this.this$0.getName() + " class in current class loader");
                    }
                    InputStream inputStream2 = inputStream;
                    Closeable closeable = inputStream2;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        byArray = ByteStreamsKt.readBytes((InputStream)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return byArray;
                }
                {
                    this.this$0 = classBytes;
                    super(0);
                }
            }));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$Companion;", "", "()V", "LAMBDA_SUPERCLASSES", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$ClassBytes;", "changeSuperToMagicAccessor", "", "bytes", "idea-jvm"})
    private static final class Companion {
        @NotNull
        public final byte[] changeSuperToMagicAccessor(@NotNull byte[] bytes2) {
            Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
            ClassWriter classWriter = new ClassWriter(0);
            ClassVisitor classVisitor2 = new ClassVisitor(classWriter, 458752, (ClassVisitor)classWriter){
                final /* synthetic */ ClassWriter $classWriter;

                public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    String newSuperName = superName;
                    if (Intrinsics.areEqual((Object)"java/lang/Object", (Object)newSuperName)) {
                        newSuperName = "sun/reflect/MagicAccessorImpl";
                    }
                    super.visit(version, access, name, signature, newSuperName, interfaces);
                }
                {
                    this.$classWriter = $captured_local_variable$0;
                    super($super_call_param$1, $super_call_param$2);
                }
            };
            new ClassReader(bytes2).accept(classVisitor2, 0);
            byte[] byArray = classWriter.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"classWriter.toByteArray()");
            return byArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

