/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.basic.BasicListUI;

final class WideSelectionListUI
extends BasicListUI {
    private Rectangle myPaintBounds;

    WideSelectionListUI() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.myPaintBounds = !WideSelectionListUI.isVerticalList(c) ? null : g.getClipBounds();
        super.paint(g, c);
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer renderer, ListModel model, ListSelectionModel selectionModel, int leadSelectionIndex) {
        if (0 > row || row >= model.getSize()) {
            return;
        }
        Rectangle paintBounds = this.myPaintBounds;
        if (paintBounds != null) {
            boolean selected = selectionModel.isSelectedIndex(row);
            boolean focused = row == leadSelectionIndex && this.list.hasFocus();
            Component component = renderer.getListCellRendererComponent(this.list, model.getElementAt(row), row, selected, focused);
            if (component != null) {
                if (this.rendererPane != component.getParent()) {
                    this.rendererPane.add(component);
                }
                g.setClip(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                WideSelectionListUI.paintRenderer(g, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, this.list, component);
                g.clipRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
            }
        }
        super.paintCell(g, row, rowBounds, renderer, model, selectionModel, leadSelectionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintRenderer(Graphics g, int x, int y, int width, int height, Component owner, Component renderer) {
        g.clipRect(0, y, owner.getWidth(), height);
        WideSelectionListUI.paintBackground(g, y, height, owner, renderer);
        if (renderer instanceof Container) {
            Component[] children;
            Container container = (Container)renderer;
            Component[] componentArray = container.getTreeLock();
            synchronized (componentArray) {
                children = container.getComponents();
            }
            if (children.length > 0) {
                renderer.setBounds(x, y, width, height);
                renderer.validate();
                for (Component child : children) {
                    if (0 != child.getX() || width != child.getWidth() || 0 >= child.getHeight()) continue;
                    WideSelectionListUI.paintBackground(g, y + child.getY(), child.getHeight(), owner, child);
                }
            }
        }
    }

    private static void paintBackground(Graphics g, int y, int height, Component owner, Component child) {
        Color color;
        if (child.isOpaque() && (color = child.getBackground()) != null && !color.equals(owner.getBackground())) {
            g.setColor(color);
            g.fillRect(0, y, owner.getWidth(), height);
        }
    }

    private static boolean isVerticalList(Component component) {
        if (component instanceof JList) {
            JList list = (JList)component;
            return 0 == list.getLayoutOrientation();
        }
        return false;
    }

    public int locationToIndex(JList list, Point location) {
        if (location.y <= list.getPreferredSize().height) {
            return super.locationToIndex(list, location);
        }
        return -1;
    }

    public Rectangle getCellBounds(JList list, int index1, int index2) {
        Rectangle bounds = super.getCellBounds(list, index1, index2);
        if (bounds != null && index1 == index2 && list instanceof JBList && 0 == list.getLayoutOrientation() && ((JBList)list).getExpandableItemsHandler().getExpandedItems().contains(index1)) {
            JScrollBar bar;
            JScrollPane pane = JBScrollPane.findScrollPane(list);
            JScrollBar jScrollBar = bar = pane == null ? null : pane.getVerticalScrollBar();
            if (bar != null && !bar.isOpaque()) {
                bounds.width += bar.getWidth();
            }
        }
        return bounds;
    }
}

