/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTaskContext
extends UserDataHolderBase {
    @Nullable
    private final Object mySessionId;
    @Nullable
    private final RunConfiguration myRunConfiguration;
    private final boolean myAutoRun;
    private final MultiMap<String, String> myGeneratedFiles;
    private volatile boolean myCollectGeneratedFiles;

    public ProjectTaskContext() {
        this(null, null, false);
    }

    public ProjectTaskContext(boolean autoRun) {
        this(null, null, autoRun);
    }

    public ProjectTaskContext(@Nullable Object sessionId) {
        this(sessionId, null, false);
    }

    public ProjectTaskContext(@Nullable Object sessionId, @Nullable RunConfiguration runConfiguration) {
        this(sessionId, runConfiguration, false);
    }

    public ProjectTaskContext(@Nullable Object sessionId, @Nullable RunConfiguration runConfiguration, boolean autoRun) {
        this.mySessionId = sessionId;
        this.myRunConfiguration = runConfiguration;
        this.myAutoRun = autoRun;
        this.myGeneratedFiles = MultiMap.createConcurrentSet();
    }

    @Nullable
    public Object getSessionId() {
        return this.mySessionId;
    }

    @Nullable
    public RunConfiguration getRunConfiguration() {
        return this.myRunConfiguration;
    }

    public boolean isAutoRun() {
        return this.myAutoRun;
    }

    @ApiStatus.Experimental
    public void enableCollectionOfGeneratedFiles() {
        this.myCollectGeneratedFiles = true;
    }

    @NotNull
    @ApiStatus.Experimental
    public Collection<String> getGeneratedFilesRoots() {
        Set set = this.myGeneratedFiles.keySet();
        if (set == null) {
            ProjectTaskContext.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    @ApiStatus.Experimental
    public Collection<String> getGeneratedFilesRelativePaths(@NotNull String root) {
        if (root == null) {
            ProjectTaskContext.$$$reportNull$$$0(1);
        }
        Collection collection = this.myGeneratedFiles.get((Object)root);
        if (collection == null) {
            ProjectTaskContext.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @ApiStatus.Experimental
    public void fileGenerated(@NotNull String root, @NotNull String relativePath) {
        if (root == null) {
            ProjectTaskContext.$$$reportNull$$$0(3);
        }
        if (relativePath == null) {
            ProjectTaskContext.$$$reportNull$$$0(4);
        }
        if (this.myCollectGeneratedFiles) {
            this.myGeneratedFiles.putValue((Object)root, (Object)relativePath);
        }
    }

    public <T> ProjectTaskContext withUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            ProjectTaskContext.$$$reportNull$$$0(5);
        }
        this.putUserData(key, value);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/task/ProjectTaskContext";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedFilesRoots";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/task/ProjectTaskContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedFilesRelativePaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedFilesRelativePaths";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileGenerated";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

