/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.DataManager;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileDescriptor
implements Navigatable,
Comparable<OpenFileDescriptor> {
    public static final DataKey<Editor> NAVIGATE_IN_EDITOR = DataKey.create("NAVIGATE_IN_EDITOR");
    private final Project myProject;
    private final VirtualFile myFile;
    private final int myLogicalLine;
    private final int myLogicalColumn;
    private final int myOffset;
    private final RangeMarker myRangeMarker;
    private boolean myUseCurrentWindow;
    private ScrollType myScrollType;

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(1);
        }
        this(project, file, -1, -1, offset, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(3);
        }
        this(project, file, logicalLine, logicalColumn, -1, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn, boolean persistent) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(5);
        }
        this(project, file, logicalLine, logicalColumn, -1, persistent);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(6);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(7);
        }
        this(project, file, -1, -1, -1, false);
    }

    private OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn, int offset, boolean persistent) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(8);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(9);
        }
        this.myScrollType = ScrollType.CENTER;
        this.myProject = project;
        this.myFile = file;
        this.myLogicalLine = logicalLine;
        this.myLogicalColumn = logicalColumn;
        this.myOffset = offset;
        this.myRangeMarker = offset >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, offset) : (logicalLine >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, logicalLine, Math.max(0, logicalColumn), persistent) : null);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(10);
        }
        return virtualFile2;
    }

    @Nullable
    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    public int getOffset() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid() ? this.myRangeMarker.getStartOffset() : this.myOffset;
    }

    public int getLine() {
        return this.myLogicalLine;
    }

    public int getColumn() {
        return this.myLogicalColumn;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (!this.canNavigate()) {
            throw new IllegalStateException("target not valid");
        }
        if (!this.myFile.isDirectory() && this.navigateInEditorOrNativeApp(this.myProject, requestFocus)) {
            return;
        }
        if (this.navigateInProjectView(requestFocus)) {
            return;
        }
        String message = IdeBundle.message("error.files.of.this.type.cannot.be.opened", ApplicationNamesInfo.getInstance().getProductName());
        Messages.showErrorDialog(this.myProject, message, IdeBundle.message("title.cannot.open.file", new Object[0]));
    }

    private boolean navigateInEditorOrNativeApp(@NotNull Project project, boolean requestFocus) {
        FileType type;
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(11);
        }
        if ((type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(this.myFile, project)) == null || !this.myFile.isValid()) {
            return false;
        }
        if (type instanceof INativeFileType) {
            return ((INativeFileType)type).openFileInAssociatedApplication(project, this.myFile);
        }
        return this.navigateInEditor(project, requestFocus);
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(12);
        }
        return this.navigateInRequestedEditor() || this.navigateInAnyFileEditor(project, requestFocus);
    }

    private boolean navigateInRequestedEditor() {
        DataContext ctx = DataManager.getInstance().getDataContext();
        Editor e = NAVIGATE_IN_EDITOR.getData(ctx);
        if (e == null) {
            return false;
        }
        if (!Comparing.equal((Object)FileDocumentManager.getInstance().getFile(e.getDocument()), (Object)this.myFile)) {
            return false;
        }
        this.navigateIn(e);
        return true;
    }

    protected boolean navigateInAnyFileEditor(Project project, boolean focusEditor) {
        List<FileEditor> editors = FileEditorManager.getInstance(project).openEditor(this, focusEditor);
        for (FileEditor editor : editors) {
            if (!(editor instanceof TextEditor)) continue;
            Editor e = ((TextEditor)editor).getEditor();
            FileEditorManager.getInstance(this.myProject).runWhenLoaded(e, () -> {
                OpenFileDescriptor.unfoldCurrentLine(e);
                if (focusEditor) {
                    IdeFocusManager.getInstance(this.myProject).requestFocus(e.getContentComponent(), true);
                }
            });
        }
        return !editors.isEmpty();
    }

    private boolean navigateInProjectView(boolean requestFocus) {
        FileSelectInContext context = new FileSelectInContext(this.myProject, this.myFile, null);
        for (SelectInTarget target : SelectInManager.getInstance(this.myProject).getTargets()) {
            if (!context.selectIn(target, requestFocus)) continue;
            return true;
        }
        return false;
    }

    public void navigateIn(@NotNull Editor e) {
        if (e == null) {
            OpenFileDescriptor.$$$reportNull$$$0(13);
        }
        int offset = this.getOffset();
        CaretModel caretModel = e.getCaretModel();
        boolean caretMoved = false;
        if (this.myLogicalLine >= 0) {
            LogicalPosition pos = new LogicalPosition(this.myLogicalLine, Math.max(this.myLogicalColumn, 0));
            if (offset < 0 || offset == e.logicalPositionToOffset(pos)) {
                caretModel.removeSecondaryCarets();
                caretModel.moveToLogicalPosition(pos);
                caretMoved = true;
            }
        }
        if (!caretMoved && offset >= 0) {
            caretModel.removeSecondaryCarets();
            caretModel.moveToOffset(Math.min(offset, e.getDocument().getTextLength()));
            caretMoved = true;
        }
        if (caretMoved) {
            e.getSelectionModel().removeSelection();
            FileEditorManager.getInstance(this.myProject).runWhenLoaded(e, () -> {
                this.scrollToCaret(e);
                OpenFileDescriptor.unfoldCurrentLine(e);
            });
        }
    }

    protected static void unfoldCurrentLine(@NotNull Editor editor) {
        if (editor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(14);
        }
        FoldRegion[] allRegions = editor.getFoldingModel().getAllFoldRegions();
        TextRange range = OpenFileDescriptor.getRangeToUnfoldOnNavigation(editor);
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            for (FoldRegion region : allRegions) {
                if (region.isExpanded() || !range.intersects(TextRange.create((Segment)region))) continue;
                region.setExpanded(true);
            }
        });
    }

    @NotNull
    public static TextRange getRangeToUnfoldOnNavigation(@NotNull Editor editor) {
        if (editor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(15);
        }
        int offset = editor.getCaretModel().getOffset();
        int line = editor.getDocument().getLineNumber(offset);
        int start = editor.getDocument().getLineStartOffset(line);
        int end = editor.getDocument().getLineEndOffset(line);
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            OpenFileDescriptor.$$$reportNull$$$0(16);
        }
        return textRange;
    }

    private void scrollToCaret(@NotNull Editor e) {
        if (e == null) {
            OpenFileDescriptor.$$$reportNull$$$0(17);
        }
        e.getScrollingModel().scrollToCaret(this.myScrollType);
    }

    @Override
    public boolean canNavigate() {
        return this.myFile.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(18);
        }
        return project;
    }

    public OpenFileDescriptor setUseCurrentWindow(boolean search) {
        this.myUseCurrentWindow = search;
        return this;
    }

    public boolean isUseCurrentWindow() {
        return this.myUseCurrentWindow;
    }

    public void setScrollType(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            OpenFileDescriptor.$$$reportNull$$$0(19);
        }
        this.myScrollType = scrollType;
    }

    public void dispose() {
        if (this.myRangeMarker != null) {
            this.myRangeMarker.dispose();
        }
    }

    @Override
    public int compareTo(@NotNull OpenFileDescriptor o) {
        int i;
        if (o == null) {
            OpenFileDescriptor.$$$reportNull$$$0(20);
        }
        if ((i = this.myProject.getName().compareTo(o.myProject.getName())) != 0) {
            return i;
        }
        i = this.myFile.getName().compareTo(o.myFile.getName());
        if (i != 0) {
            return i;
        }
        if (this.myRangeMarker != null) {
            if (o.myRangeMarker == null) {
                return 1;
            }
            i = this.myRangeMarker.getStartOffset() - o.myRangeMarker.getStartOffset();
            if (i != 0) {
                return i;
            }
            return this.myRangeMarker.getEndOffset() - o.myRangeMarker.getEndOffset();
        }
        return o.myRangeMarker == null ? 0 : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/OpenFileDescriptor";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/OpenFileDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToUnfoldOnNavigation";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 16: 
            case 18: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "navigateInEditorOrNativeApp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateInEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "navigateIn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unfoldCurrentLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToUnfoldOnNavigation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCaret";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setScrollType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

