/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.CaretSpecificDataContext;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorActionHandler {
    private final boolean myRunForEachCaret;
    private boolean myWorksInInjected;
    private boolean inExecution;
    private boolean inCheck;

    protected EditorActionHandler() {
        this(false);
    }

    protected EditorActionHandler(boolean runForEachCaret) {
        this.myRunForEachCaret = runForEachCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isEnabled(Editor editor, DataContext dataContext) {
        if (this.inCheck) {
            return true;
        }
        this.inCheck = true;
        try {
            Editor hostEditor;
            if (editor == null) {
                boolean bl = false;
                return bl;
            }
            Editor editor2 = hostEditor = dataContext == null ? null : CommonDataKeys.HOST_EDITOR.getData(dataContext);
            if (hostEditor == null) {
                hostEditor = editor;
            }
            boolean[] result2 = new boolean[1];
            CaretTask check = (___, __) -> {
                result2[0] = true;
            };
            if (this.myRunForEachCaret) {
                hostEditor.getCaretModel().runForEachCaret(caret -> this.doIfEnabled(caret, dataContext, check));
            } else {
                this.doIfEnabled(hostEditor.getCaretModel().getCurrentCaret(), dataContext, check);
            }
            boolean bl = result2[0];
            return bl;
        }
        finally {
            this.inCheck = false;
        }
    }

    private void doIfEnabled(@NotNull Caret hostCaret, @Nullable DataContext context, @NotNull CaretTask task) {
        DataContext injectedCaretContext;
        Caret injectedCaret;
        if (hostCaret == null) {
            EditorActionHandler.$$$reportNull$$$0(0);
        }
        if (task == null) {
            EditorActionHandler.$$$reportNull$$$0(1);
        }
        CaretSpecificDataContext caretContext = context == null ? null : new CaretSpecificDataContext(context, hostCaret);
        Editor editor = hostCaret.getEditor();
        if (this.myWorksInInjected && caretContext != null && (injectedCaret = CommonDataKeys.CARET.getData(injectedCaretContext = AnActionEvent.getInjectedDataContext(caretContext))) != null && injectedCaret != hostCaret && this.isEnabledForCaret(injectedCaret.getEditor(), injectedCaret, injectedCaretContext)) {
            task.perform(injectedCaret, injectedCaretContext);
            return;
        }
        if (this.isEnabledForCaret(editor, hostCaret, caretContext)) {
            task.perform(hostCaret, caretContext);
        }
    }

    static boolean ensureInjectionUpToDate(@NotNull Caret hostCaret) {
        Editor editor;
        Project project;
        if (hostCaret == null) {
            EditorActionHandler.$$$reportNull$$$0(2);
        }
        if ((project = (editor = hostCaret.getEditor()).getProject()) != null && InjectedLanguageManager.getInstance(project).mightHaveInjectedFragmentAtOffset(editor.getDocument(), hostCaret.getOffset())) {
            PsiDocumentManager.getInstance(project).commitDocument(editor.getDocument());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(3);
        }
        if (caret == null) {
            EditorActionHandler.$$$reportNull$$$0(4);
        }
        if (this.inCheck) {
            return true;
        }
        this.inCheck = true;
        try {
            boolean bl = this.isEnabled(editor, dataContext);
            return bl;
        }
        finally {
            this.inCheck = false;
        }
    }

    public final boolean isEnabled(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(5);
        }
        return caret == null ? this.isEnabled(editor, dataContext) : this.isEnabledForCaret(editor, caret, dataContext);
    }

    @Deprecated
    public void execute(@NotNull Editor editor, @Nullable DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(6);
        }
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(7);
        }
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(8);
        }
        return true;
    }

    public boolean runForAllCarets() {
        return this.myRunForEachCaret;
    }

    public final void execute(@NotNull Editor editor, @Nullable Caret contextCaret, DataContext dataContext) {
        Editor hostEditor;
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(9);
        }
        Editor editor2 = hostEditor = dataContext == null ? null : CommonDataKeys.HOST_EDITOR.getData(dataContext);
        if (hostEditor == null) {
            hostEditor = editor;
        }
        if (contextCaret == null && this.runForAllCarets()) {
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                if (this.myWorksInInjected) {
                    EditorActionHandler.ensureInjectionUpToDate(caret);
                }
                this.doIfEnabled(caret, dataContext, (caret1, dc) -> this.doExecute(caret1.getEditor(), caret1, dc));
            });
        } else if (contextCaret == null) {
            if (this.myWorksInInjected) {
                EditorActionHandler.ensureInjectionUpToDate(hostEditor.getCaretModel().getCurrentCaret());
            }
            this.doIfEnabled(hostEditor.getCaretModel().getCurrentCaret(), dataContext, (caret, dc) -> this.doExecute(caret.getEditor(), null, dc));
        } else {
            this.doExecute(editor, contextCaret, dataContext);
        }
    }

    void setWorksInInjected(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public DocCommandGroupId getCommandGroupId(@NotNull Editor editor) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(10);
        }
        return DocCommandGroupId.noneGroupId(editor.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostCaret";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actionSystem/EditorActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doIfEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureInjectionUpToDate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommandGroupId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    private static interface CaretTask {
        public void perform(@NotNull Caret var1, @Nullable DataContext var2);
    }
}

